/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstBreakStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.SimpleName;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class BreakStmt
extends Stmt
implements AstBreakStatement {
    private JavaToken breakToken;
    private SimpleName label;
    private JavaToken semiToken;
    public Stmt target;

    public BreakStmt(JavaToken breakToken, SimpleName label, JavaToken semiToken) {
        this.breakToken = breakToken;
        this.label = label;
        this.semiToken = semiToken;
        if (label != null) {
            label.setParent(this);
        }
    }

    public int astType() {
        return 57;
    }

    public int getObjectKind() {
        return 18;
    }

    public AstObject[] getChildren() {
        return Ast.EMPTY_NODE_SET;
    }

    public String getLabelName() {
        return this.label != null ? this.label.getName() : null;
    }

    public AstStatement getBreakTarget() {
        return this.target;
    }

    public SimpleName label() {
        return this.label;
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitBreakStatement(this);
        } else {
            visitor.visitBreakStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        if (this.label != null) {
            this.label.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.label == oldObj) {
            this.label = (SimpleName)newObj;
            return true;
        }
        return false;
    }

    public JavaToken leftToken() {
        return this.breakToken;
    }

    public JavaToken rightToken() {
        return this.semiToken;
    }
}

