/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.DeclarationStmt;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclaration;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class Block
extends Stmt
implements AstCompoundStatement {
    private Stmt[] statements;
    AstVector locals;
    private JavaToken leftBrace;
    private JavaToken rightBrace;

    public Block(JavaToken leftBrace, Stmt[] statements, JavaToken rightBrace) {
        this.statements = statements;
        this.leftBrace = leftBrace;
        this.rightBrace = rightBrace;
        int i = 0;
        while (i < statements.length) {
            statements[i].setParent(this);
            ++i;
        }
        this.collectLocalVariables();
    }

    public int astType() {
        return 3;
    }

    public int getObjectKind() {
        return 21;
    }

    public AstObject[] getChildren() {
        return this.getStatements();
    }

    public AstComment[] getComments() {
        return this.getComments(new JavaToken[]{this.leftBrace, this.rightBrace});
    }

    public AstStatement[] getStatements() {
        AstStatement[] arrStmt = new AstStatement[this.statements.length];
        System.arraycopy(this.statements, 0, arrStmt, 0, this.statements.length);
        return arrStmt;
    }

    public AstVariable[] getLocalVariables() {
        if (this.locals == null) {
            return new AstVariable[0];
        }
        return this.locals.toArray(new AstVariable[this.locals.size()]);
    }

    public int numStatements() {
        return this.statements.length;
    }

    public Stmt statement(int i) {
        return this.statements[i];
    }

    void addLocalVariable(VariableDeclarator v, boolean front) {
        if (this.locals == null) {
            this.locals = new AstVector();
        }
        if (front) {
            this.locals.add(0, v);
        } else {
            this.locals.add(v);
        }
    }

    void collectLocalVariables() {
        this.locals = null;
        int i = 0;
        while (i < this.statements.length) {
            if (this.statements[i].astType() == 59) {
                DeclarationStmt d = (DeclarationStmt)this.statements[i];
                if (d.decl.astType() == 28) {
                    VariableDeclaration v = (VariableDeclaration)d.decl;
                    int j = 0;
                    while (j < v.numDeclarators()) {
                        this.addLocalVariable(v.getDeclarator(j), false);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitCompoundStatement(this);
        } else {
            visitor.visitBlock(this);
        }
    }

    public void traverse(Visitor visitor) {
        int i = 0;
        while (i < this.statements.length) {
            this.statements[i].action(visitor);
            ++i;
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        int i = 0;
        while (i < this.statements.length) {
            if (this.statements[i] == oldObj) {
                this.statements[i] = (Stmt)newObj;
                return true;
            }
            ++i;
        }
        return false;
    }

    public JavaToken leftToken() {
        return this.leftBrace;
    }

    public JavaToken rightToken() {
        return this.rightBrace;
    }

    public void prepend(AstStatement stmt) {
        Stmt[] newStatements = new Stmt[this.statements.length + 1];
        newStatements[0] = (Stmt)stmt;
        System.arraycopy(this.statements, 0, newStatements, 1, this.statements.length);
        this.statements = newStatements;
        if (newStatements.length > 1) {
            newStatements[0].leftToken().setPosition(newStatements[1].leftToken());
        }
    }
}

