/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstBinaryExpression;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class BinaryExpr
extends Expr
implements AstBinaryExpression {
    private int kind;
    private Expr leftExpression;
    public JavaToken opToken;
    private Expr rightExpression;

    public BinaryExpr(int kind, Expr leftExpression, JavaToken opToken, Expr rightExpression) {
        this.kind = kind;
        this.leftExpression = leftExpression;
        this.opToken = opToken;
        this.rightExpression = rightExpression;
        leftExpression.setParent(this);
        rightExpression.setParent(this);
    }

    public int astType() {
        return 2;
    }

    public int getObjectKind() {
        return 33;
    }

    public AstExpression[] getOperands() {
        return new AstExpression[]{this.leftExpression, this.rightExpression};
    }

    public int getExpressionKind() {
        return this.kind;
    }

    public AstExpression getLeftOperand() {
        return this.leftExpr();
    }

    public AstExpression getRightOperand() {
        return this.rightExpr();
    }

    public Expr leftExpr() {
        return this.leftExpression;
    }

    public Expr rightExpr() {
        return this.rightExpression;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitBinaryExpression(this);
        } else {
            visitor.visitBinaryExpr(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.leftExpression.action(visitor);
        this.rightExpression.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.leftExpression == oldObj) {
            this.leftExpression = (Expr)newObj;
        } else if (this.rightExpression == oldObj) {
            this.rightExpression = (Expr)newObj;
        } else {
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.leftExpression.leftToken();
    }

    public JavaToken rightToken() {
        return this.rightExpression.rightToken();
    }
}

