/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstSourcePosition;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.visitor.AstExpressionVisitor;
import com.togethersoft.sca.ast.visitor.AstStatementVisitor;
import com.togethersoft.sca.internal.jparser.ast.AstVisitorAdapter;
import com.togethersoft.sca.internal.jparser.ast.Comment;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class Ast
implements AstObject,
AstSourcePosition,
Serializable {
    private boolean deleted;
    Ast parent;
    public static final int N_A = 0;
    public static final int ASSIGN_EXPR = 1;
    public static final int BINARY_EXPR = 2;
    public static final int BLOCK = 3;
    public static final int CAST_EXPR = 4;
    public static final int THROW_SPEC = 5;
    public static final int COMP_UNIT = 6;
    public static final int COND_EXPR = 7;
    public static final int EMPTY_STMT = 8;
    public static final int EXPR_STMT = 9;
    public static final int FIELD_ACCESS = 10;
    public static final int FORMAL_PARAM = 11;
    public static final int IMPORT_DECL = 13;
    public static final int LITERAL = 14;
    public static final int METHOD_DECL = 15;
    public static final int METHOD_CALL = 16;
    public static final int MODIFIER = 17;
    public static final int MODIFIERS = 18;
    public static final int BUILTIN_TYPE = 19;
    public static final int NEW_EXPR = 20;
    public static final int PACKAGE_DECL = 21;
    public static final int SIMPLE_NAME = 22;
    public static final int SUPER_EXPR = 24;
    public static final int THIS_EXPR = 25;
    public static final int TYPE_DECL = 26;
    public static final int TYPE_EXPR = 27;
    public static final int VAR_DECLARATION = 28;
    public static final int VAR_DECLARATOR = 29;
    public static final int SUPER_CALL = 30;
    public static final int UNARY_PLUS_MINUS_EXPR = 31;
    public static final int INC_DEC_EXPR = 32;
    public static final int BINARY_NOT_EXPR = 34;
    public static final int LOGICAL_NOT_EXPR = 35;
    public static final int ARRAY_ACCESS = 36;
    public static final int BRACKETS = 37;
    public static final int ARRAY_INITIALIZER = 38;
    public static final int ARRAY_CREATION_EXPR = 39;
    public static final int IF_STMT = 41;
    public static final int DO_STMT = 42;
    public static final int WHILE_STMT = 43;
    public static final int FOR_STMT = 44;
    public static final int SYNCHRONIZED_STMT = 45;
    public static final int PAR_EXPR = 46;
    public static final int FINALLY_CLAUSE = 47;
    public static final int CATCH_CLAUSE = 48;
    public static final int DEFAULT_LABEL = 49;
    public static final int CASE_LABEL = 50;
    public static final int TRY_STMT = 51;
    public static final int THROW_STMT = 52;
    public static final int SWITCH_STMT = 53;
    public static final int SWITCH_GROUP = 54;
    public static final int RETURN_STMT = 55;
    public static final int CONTINUE_STMT = 56;
    public static final int BREAK_STMT = 57;
    public static final int THIS_CALL = 58;
    public static final int DECL_STMT = 59;
    public static final int CLASS_INIT = 60;
    public static final int INHERITANCE = 61;
    public static final int ASSERT_STMT = 62;
    public static final int COMMENT = 63;
    public static final int DBC_RESULT_EXPR = 64;
    protected static final AstObject[] EMPTY_NODE_SET = new AstObject[0];
    protected static final AstComment[] EMPTY_COMMENT_SET = new AstComment[0];

    protected Ast() {
    }

    public int id() {
        return 0;
    }

    public void setParent(Ast parent) {
        this.parent = parent;
    }

    public Ast parent() {
        return this.parent;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted() {
        this.deleted = true;
    }

    void setReferee(Declaration decl) {
        System.err.println(this.getClass() + ":" + this.toString() + " " + decl.getClass() + ":" + decl);
    }

    public abstract void accept(Visitor var1);

    public abstract void traverse(Visitor var1);

    public void action(Visitor visitor) {
        if ((visitor.getAction() & 1) != 0) {
            this.accept(visitor);
        }
        this.traverse(visitor);
        if ((visitor.getAction() & 2) != 0) {
            this.accept(visitor);
        }
    }

    public abstract JavaToken leftToken();

    public abstract JavaToken rightToken();

    public String getLocation() {
        JavaToken lt = this.leftToken();
        if (lt != null) {
            return "[" + this.getFileName() + ":" + lt.getLine() + ":" + lt.getColumn() + "]";
        }
        return "";
    }

    public String toString() {
        return this.getLocation();
    }

    public abstract int astType();

    public AstObject getParent() {
        return this.parent;
    }

    public AstSourcePosition getPosition() {
        if (this.leftToken() != null && this.rightToken() != null) {
            return this;
        }
        return null;
    }

    public void setPosition(AstSourcePosition position) {
        JavaToken left = this.leftToken();
        if (left != null) {
            left.setPosition(position.getStartColumn(), position.getStartLine());
        }
    }

    public void setPositionAfter(AstSourcePosition position) {
        JavaToken left = this.leftToken();
        if (left != null) {
            left.setPosition(position.getStartColumn(), position.getEndLine());
        }
    }

    public AstMethod getDeclaringMethod() {
        AstObject parent = this.getParent();
        while (parent != null && !(parent instanceof AstMethod)) {
            if (parent instanceof AstType) {
                return null;
            }
            parent = parent.getParent();
        }
        return (AstMethod)parent;
    }

    public AstType getDeclaringType() {
        AstObject parent = this.getParent();
        while (parent != null && !(parent instanceof AstType)) {
            parent = parent.getParent();
        }
        return (AstType)parent;
    }

    public AstCompilationUnit getCompilationUnit() {
        AstObject parent = this.getParent();
        while (parent != null && !(parent instanceof AstCompilationUnit)) {
            parent = parent.getParent();
        }
        return (AstCompilationUnit)parent;
    }

    public AstPackage getPackage() {
        AstObject parent = this.getParent();
        while (parent != null && !(parent instanceof AstPackage)) {
            parent = parent.getParent();
        }
        return (AstPackage)parent;
    }

    public AstComment[] getComments() {
        AstComment[] comments;
        JavaToken left = this.leftToken();
        if (left != null && (comments = left.getComments()) != null) {
            int i = 0;
            while (i < comments.length) {
                ((Ast)((Object)comments[i])).setParent(this);
                ++i;
            }
            return comments;
        }
        return EMPTY_COMMENT_SET;
    }

    public void addComment(AstComment comment) {
        Comment cmt = (Comment)comment;
        cmt.leftToken().setType(43);
        JavaToken left = this.leftToken();
        if (left != null) {
            left.addComment(cmt);
        }
    }

    AstComment[] getComments(JavaToken[] tokens) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        int i = 0;
        while (i < tokens.length) {
            Comment[] cs;
            if (tokens[i] != null && (cs = tokens[i].getComments()) != null) {
                int j = 0;
                while (j < cs.length) {
                    comments.add(cs[j]);
                    ++j;
                }
            }
            ++i;
        }
        return comments.toArray(new AstComment[comments.size()]);
    }

    public void visitStatements(AstStatementVisitor visitor) {
        int options = 2;
        if ((visitor.getOptions() & 1) == 0) {
            options |= 4;
        }
        AstVisitorAdapter adapter = new AstVisitorAdapter(options);
        adapter.stmtVisitor = visitor;
        this.action(adapter);
    }

    public void visitExpressions(AstExpressionVisitor visitor) {
        int options = 2;
        if ((visitor.getOptions() & 1) == 0) {
            options |= 4;
        }
        AstVisitorAdapter adapter = new AstVisitorAdapter(options);
        adapter.exprVisitor = visitor;
        this.action(adapter);
    }

    public String getFileName() {
        AstObject ast = this;
        while (ast != null && !(ast instanceof AstCompilationUnit)) {
            ast = ast.getParent();
        }
        return ast != null ? ((AstCompilationUnit)ast).getElementName() : "";
    }

    public int getOffset() {
        return this.leftToken().getOffset();
    }

    public int getStartLine() {
        return this.leftToken().getLine();
    }

    public int getStartColumn() {
        return this.leftToken().getColumn();
    }

    public int getEndLine() {
        return this.rightToken().getEndLine();
    }

    public int getEndColumn() {
        return this.rightToken().getEndColumn();
    }

    public int getStartLineWithComments() {
        return this.leftToken().getStartLine();
    }

    public int getStartColumnWithComments() {
        return this.leftToken().getStartColumn();
    }

    public int getAdjustedLine() {
        return this.getStartLineWithComments();
    }

    public void remove() {
        this.setDeleted();
    }

    public void replaceWith(AstObject obj, AstObject parent) {
        Ast ast = (Ast)obj;
        JavaToken left = this.leftToken();
        ast.leftToken().setPosition(left);
        if (!((Ast)parent).replace(this, obj)) {
            throw new Error("Invalid replacement of " + this + " with " + obj);
        }
        ast.setParent((Ast)parent);
        ast.leftToken().setComments(left.getComments());
    }

    public void replaceWith(AstObject obj) {
        this.replaceWith(obj, this.parent);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        return false;
    }

    public abstract AstObject[] getChildren();

    public abstract int getObjectKind();
}

