/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class AssignExpr
extends Expr
implements AstAssignmentExpression {
    private int kind;
    public JavaToken opToken;
    private Expr leftHandSide;
    private Expr expression;

    public AssignExpr(int kind, Expr leftHandSide, JavaToken opToken, Expr expression) {
        this.kind = kind;
        this.leftHandSide = leftHandSide;
        this.opToken = opToken;
        this.expression = expression;
        leftHandSide.setParent(this);
        expression.setParent(this);
    }

    public int astType() {
        return 1;
    }

    public int getObjectKind() {
        return 32;
    }

    public AstExpression[] getOperands() {
        return new AstExpression[]{this.leftHandSide, this.expression};
    }

    public int getExpressionKind() {
        return this.kind;
    }

    public AstExpression getLeftOperand() {
        return this.leftExpr();
    }

    public AstExpression getRightOperand() {
        return this.rightExpr();
    }

    public Expr leftExpr() {
        return this.leftHandSide;
    }

    public Expr rightExpr() {
        return this.expression;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitAssignmentExpression(this);
        } else {
            visitor.visitAssignExpr(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.leftHandSide.action(visitor);
        this.expression.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.leftHandSide == oldObj) {
            this.leftHandSide = (Expr)newObj;
        } else if (this.expression == oldObj) {
            this.expression = (Expr)newObj;
        } else {
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.leftHandSide.leftToken();
    }

    public JavaToken rightToken() {
        return this.expression.rightToken();
    }
}

