/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstAssertStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class AssertStmt
extends Stmt
implements AstAssertStatement {
    private JavaToken assertToken;
    private Expr condition;
    public JavaToken colonToken;
    private Expr argument;
    private JavaToken semiToken;
    public Declaration ctor;

    public AssertStmt(JavaToken assertToken, Expr condition, JavaToken colonToken, Expr argument, JavaToken semiToken) {
        this.assertToken = assertToken;
        this.condition = condition;
        this.colonToken = colonToken;
        this.argument = argument;
        this.semiToken = semiToken;
        condition.setParent(this);
        if (argument != null) {
            argument.setParent(this);
        }
    }

    public int astType() {
        return 62;
    }

    public int getObjectKind() {
        return 47;
    }

    public AstObject[] getChildren() {
        if (this.argument != null) {
            return new AstObject[]{this.condition, this.argument};
        }
        return new AstObject[]{this.condition};
    }

    public AstExpression getCondition() {
        return this.condition;
    }

    public AstExpression getArgument() {
        return this.argument;
    }

    public AstDeclaration getReferencedElement() {
        return this.ctor;
    }

    public Expr condition() {
        return this.condition;
    }

    public Expr argument() {
        return this.argument;
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitAssertStatement(this);
        } else {
            visitor.visitAssertStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.condition.action(visitor);
        if (this.argument != null) {
            this.argument.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.condition == oldObj) {
            this.condition = (Expr)newObj;
        } else if (this.argument == oldObj) {
            this.argument = (Expr)newObj;
        } else {
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.assertToken;
    }

    public JavaToken rightToken() {
        return this.semiToken;
    }
}

