/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstArrayInitializer;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class ArrayInitializer
extends Expr
implements AstArrayInitializer {
    AstVector initializers = new AstVector();
    public JavaToken leftBrace;
    public JavaToken rightBrace;

    public ArrayInitializer() {
        if (this.initializers != null) {
            this.initializers.setParent(this);
        }
    }

    public int astType() {
        return 38;
    }

    public int getObjectKind() {
        return 44;
    }

    public AstExpression[] getInitializers() {
        return this.toExprArray(this.initializers);
    }

    public AstExpression[] getOperands() {
        return this.getInitializers();
    }

    public int numInitializers() {
        return this.initializers.size();
    }

    public Expr getInitializer(int i) {
        return (Expr)this.initializers.get(i);
    }

    public void addInitializer(Expr init) {
        this.initializers.add(init);
        init.setParent(this);
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitArrayInitializer(this);
        } else {
            visitor.visitArrayInitializer(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.initializers.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        return AstVector.replace(this.initializers, oldObj, newObj);
    }

    public JavaToken leftToken() {
        return this.leftBrace;
    }

    public JavaToken rightToken() {
        return this.rightBrace;
    }
}

