/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstArrayCreationExpression;
import com.togethersoft.sca.ast.AstArrayInitializer;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.internal.jparser.ast.ArrayInitializer;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Brackets;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class ArrayCreationExpr
extends Expr
implements AstArrayCreationExpression,
AstReference {
    private JavaToken newToken;
    public Name arrayType;
    private AstVector dims;
    public ArrayInitializer initializer;

    public ArrayCreationExpr(JavaToken newToken, Name arrayType, AstVector dims, ArrayInitializer initializer) {
        this.newToken = newToken;
        this.arrayType = arrayType;
        this.dims = dims;
        this.initializer = initializer;
        arrayType.setParent(this);
        dims.setParent(this);
        int i = 0;
        while (i < this.numDimensions()) {
            Expr expr = this.dimension((int)i).expr;
            if (expr != null) {
                expr.setParent(this);
            }
            ++i;
        }
        if (initializer != null) {
            initializer.setParent(this);
        }
    }

    public int astType() {
        return 39;
    }

    public int getObjectKind() {
        return 30;
    }

    public AstExpression[] getDimensions() {
        int count = 0;
        int i = 0;
        while (i < this.numDimensions()) {
            if (this.dimension((int)i).expr != null) {
                ++count;
            }
            ++i;
        }
        AstExpression[] arrDims = new AstExpression[count];
        count = 0;
        int i2 = 0;
        while (i2 < this.numDimensions()) {
            if (this.dimension((int)i2).expr != null) {
                arrDims[count++] = this.dimension((int)i2).expr;
            }
            ++i2;
        }
        return arrDims;
    }

    public AstArrayInitializer getInitializer() {
        return this.initializer;
    }

    public AstExpression[] getOperands() {
        AstExpression[] dimensions = this.getDimensions();
        if (this.initializer == null) {
            return dimensions;
        }
        AstExpression[] operands = new AstExpression[dimensions.length + 1];
        System.arraycopy(dimensions, 0, operands, 0, dimensions.length);
        operands[operands.length - 1] = this.initializer;
        return operands;
    }

    public int numDimensions() {
        return this.dims.size();
    }

    public Brackets dimension(int i) {
        return (Brackets)this.dims.get(i);
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitArrayCreationExpression(this);
        } else {
            visitor.visitArrayCreationExpr(this);
        }
    }

    public void traverse(Visitor visitor) {
        if (!visitor.isExternal()) {
            this.arrayType.action(visitor);
        }
        this.dims.action(visitor);
        if (this.initializer != null) {
            this.initializer.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.initializer == oldObj) {
            this.initializer = (ArrayInitializer)newObj;
        } else if (this.arrayType == oldObj) {
            this.arrayType = (Name)newObj;
        } else {
            return AstVector.replace(this.dims, oldObj, newObj);
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.newToken;
    }

    public JavaToken rightToken() {
        if (this.initializer != null) {
            return this.initializer.rightToken();
        }
        return ((Brackets)this.dims.get(this.dims.size() - 1)).rightToken();
    }
}

