/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstArrayReference;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class ArrayAccess
extends Expr
implements AstArrayReference {
    public Expr base;
    public JavaToken leftBracket;
    public Expr index;
    public JavaToken rightBracket;

    public ArrayAccess(Expr base, Expr index, JavaToken leftBracket, JavaToken rightBracket) {
        this.base = base;
        this.leftBracket = leftBracket;
        this.index = index;
        this.rightBracket = rightBracket;
        base.setParent(this);
        index.setParent(this);
    }

    public int astType() {
        return 36;
    }

    public int getObjectKind() {
        return 31;
    }

    public AstExpression[] getOperands() {
        return new AstExpression[]{this.base, this.index};
    }

    public AstExpression getBase() {
        return this.base;
    }

    public AstExpression getIndex() {
        return this.index;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitArrayReference(this);
        } else {
            visitor.visitArrayAccess(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.base.action(visitor);
        this.index.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.base == oldObj) {
            this.base = (Expr)newObj;
        } else if (this.index == oldObj) {
            this.index = (Expr)newObj;
        } else {
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.base.leftToken();
    }

    public JavaToken rightToken() {
        return this.rightBracket;
    }
}

