/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser;

import com.togethersoft.sca.core.Factory;
import com.togethersoft.sca.core.ILogListener;
import com.togethersoft.sca.core.IMessage;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.internal.core.ClientSourceBase;
import com.togethersoft.sca.internal.core.Project;
import com.togethersoft.sca.internal.jparser.CmdOptions;
import com.togethersoft.sca.internal.jparser.ast.Model;
import java.io.File;
import java.util.Date;

class Main
implements ILogListener {
    private CmdOptions options = new CmdOptions();

    Main() {
    }

    public void receive(IMessage msg) {
        System.err.println(msg.getMessage());
    }

    private void run(String[] args) {
        if (!this.options.parseCommandLine(args)) {
            return;
        }
        if (this.options.infiles.length == 0 && this.options.dbfile == null) {
            this.options.usage();
            System.err.println("No input files specified");
            return;
        }
        try {
            Date start = new Date();
            IProject project = Factory.createProject();
            project.setProjectName(this.options.dbfile);
            project.setTabSize(this.options.tabSize);
            project.setClasspath(this.options.classpath);
            project.enableAssert(this.options.assertEnabled);
            ClientSourceBase base = Factory.createLocalSourceBase();
            project.addSourceBase(base);
            project.getLog().addLogListener(this);
            int i = 0;
            while (i < this.options.infiles.length) {
                File f = new File(this.options.infiles[i]);
                if (f.exists()) {
                    Main.doFile(f, base);
                } else {
                    System.err.println("Warning: file " + this.options.infiles[i] + " does not exist");
                }
                ++i;
            }
            System.err.println("Processing...");
            project.update(false, null);
            Date end = new Date();
            System.err.println("Time elapsed: " + (double)(end.getTime() - start.getTime()) / 1000.0);
            if (this.options.dbfile != null) {
                System.err.println("\nStoring object model in " + this.options.dbfile + " ...");
                project.write();
            }
            if (this.options.showModelTree) {
                System.err.println("\nWriting AST tree ...");
                ((Project)project).getCompiler().showModelTree(System.out, this.options.showAllTypes);
            }
            if (this.options.showSymbolTable) {
                System.err.println("\nWriting symbol table ...");
                ((Project)project).getCompiler().showSymbolTable(System.out, this.options.showAllTypes);
            }
            if (this.options.writeModelTree) {
                System.err.println("\nPrinting sources ...");
                ((Model)project.getModel()).print();
            }
        }
        catch (Exception e) {
            System.err.println("exception: " + e);
            e.printStackTrace(System.err);
        }
    }

    public static void doFile(File f, ClientSourceBase base) throws Exception {
        if (f.isDirectory()) {
            String[] files = f.list();
            int i = 0;
            while (i < files.length) {
                String fname = files[i];
                File file = new File(f, fname);
                if (file.isDirectory() || fname.length() > 5 && fname.substring(fname.length() - 5).equals(".java")) {
                    Main.doFile(file, base);
                }
                ++i;
            }
        } else {
            base.addFile(f.getPath());
        }
    }

    public static void main(String[] args) {
        new Main().run(args);
        System.exit(0);
    }
}

