/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstModelDelta;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.core.Message;
import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.Diff;
import com.togethersoft.sca.internal.jparser.ast.Model;
import com.togethersoft.sca.internal.jparser.ast.VisitorGC;
import com.togethersoft.sca.internal.jparser.ast.VisitorLinker;
import com.togethersoft.sca.internal.jparser.ast.VisitorPrinter;
import com.togethersoft.sca.internal.jparser.parser.JavaLexer;
import com.togethersoft.sca.internal.jparser.parser.JavaRecognizer;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CCompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.ErrorMgr;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;

public class Control {
    private IProject project;
    private Model model;
    private JobControl jobControl;
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("com.togethersoft.sca.core.Messages");

    public Control(IProject project) {
        this.project = project;
        if (project.getProjectName() != null && new File(project.getProjectName()).exists()) {
            try {
                FileInputStream fin = new FileInputStream(project.getProjectName());
                BufferedInputStream out = new BufferedInputStream(fin);
                ObjectInputStream s = new ObjectInputStream(out);
                this.model = new Model(this, s);
                s.close();
                return;
            }
            catch (Exception e) {
                this.logError("jparser.Control.4", new Object[]{e});
            }
        }
        this.model = new Model(this);
    }

    public AstModel getModel() {
        return this.model;
    }

    public IProject getProject() {
        return this.project;
    }

    public void showModelTree(PrintStream s, boolean showAllTypes) {
        VisitorPrinter printer = new VisitorPrinter(s, showAllTypes ? 0 : 8);
        int i = 0;
        while (i < this.model.numPackages()) {
            this.model.getPackage(i).action(printer);
            ++i;
        }
    }

    public void showSymbolTable(PrintStream s, boolean showBinaryTypes) {
        this.model.report(s, showBinaryTypes);
    }

    public void write() {
        try {
            if (this.project.getProjectName() == null) {
                this.logError("jparser.Control.5", null);
            } else {
                FileOutputStream fout = new FileOutputStream(this.project.getProjectName());
                BufferedOutputStream out = new BufferedOutputStream(fout);
                ObjectOutputStream s = new ObjectOutputStream(out);
                this.model.store(s);
                s.flush();
                s.close();
            }
        }
        catch (Exception e) {
            this.logError("jparser.Control.6", new Object[]{e});
        }
    }

    public void deepUpdate(AstCompilationUnit file) {
        ErrorMgr.setModel(this.model);
        ((CompilationUnit)file).deepParse();
    }

    public void update(boolean shallowModel, JobControl jobControl) {
        FileInfo fi;
        this.jobControl = jobControl;
        if (jobControl != null) {
            jobControl.setScale(0.5);
        }
        ErrorMgr.setModel(this.model);
        HashMap<String, FileInfo> newFiles = new HashMap<String, FileInfo>();
        HashMap updatedFiles = new HashMap();
        HashMap expiredFiles = new HashMap();
        this.getUpdatedFiles(newFiles, updatedFiles, expiredFiles, shallowModel);
        HashSet dependClosure = this.buildDependenceClosure(expiredFiles.values());
        ArrayList<FileInfo> expiredList = new ArrayList<FileInfo>();
        AstModelDelta delta = new AstModelDelta();
        delta.addedFiles = this.asArray(newFiles);
        Iterator<Object> i = dependClosure.iterator();
        while (i.hasNext()) {
            if (!this.canContinue()) {
                return;
            }
            CompilationUnit oldFile = (CompilationUnit)i.next();
            String filename = oldFile.getFilename();
            fi = (FileInfo)updatedFiles.get(filename);
            if (fi != null) {
                updatedFiles.remove(filename);
                newFiles.put(filename, fi);
            } else {
                fi = (FileInfo)expiredFiles.get(filename);
                if (fi != null) {
                    newFiles.put(filename, fi);
                } else {
                    CompilationUnit cu = this.parseFile(filename, !shallowModel);
                    if (cu != null) {
                        fi = new FileInfo(oldFile, cu);
                        newFiles.put(filename, fi);
                    }
                    this.project.getLog().log(new Message(1, resourceBundle.getString("jparser.Control.1"), new Object[]{filename}));
                }
            }
            if (fi == null) continue;
            expiredList.add(fi);
        }
        VisitorLinker linker = new VisitorLinker();
        VisitorGC garbageCollector = new VisitorGC();
        i = newFiles.values().iterator();
        while (i.hasNext()) {
            if (!this.canContinue()) {
                return;
            }
            fi = (FileInfo)i.next();
            if (fi.oldFile != null) {
                this.model.removeSourceFile(fi.oldFile);
                fi.oldFile.action(garbageCollector);
            }
            this.model.enqueueFile(fi.newFile);
        }
        i = updatedFiles.values().iterator();
        while (i.hasNext()) {
            if (!this.canContinue()) {
                return;
            }
            fi = (FileInfo)i.next();
            fi.oldFile.action(garbageCollector);
            this.model.removeSourceFile(fi.oldFile);
            this.model.enqueueFile(fi.newFile);
        }
        CompilationUnit[] removedFiles = this.getRemovedFiles();
        int j = 0;
        while (j < removedFiles.length) {
            CompilationUnit cu = removedFiles[j];
            this.model.removeSourceFile(cu);
            cu.action(garbageCollector);
            ++j;
        }
        this.model.processPendingDeclarations();
        if (!this.canContinue()) {
            return;
        }
        i = updatedFiles.values().iterator();
        while (i.hasNext()) {
            FileInfo fi2 = (FileInfo)i.next();
            fi2.oldFile.action(linker);
        }
        this.model.processPendingBodies();
        if (jobControl != null) {
            jobControl.setScale(2.0);
        }
        delta.updatedFiles = this.asArray(updatedFiles);
        delta.expiredFiles = this.asPairArray(expiredList);
        delta.removedFiles = removedFiles;
        this.model.broadastChanges(delta);
    }

    private CompilationUnit[][] asPairArray(ArrayList list) {
        CompilationUnit[][] arr = new CompilationUnit[][]{new CompilationUnit[list.size()], new CompilationUnit[list.size()]};
        int index = 0;
        Iterator iter = ((AbstractList)list).iterator();
        while (iter.hasNext()) {
            FileInfo fi = (FileInfo)iter.next();
            arr[0][index] = fi.oldFile;
            arr[1][index++] = fi.newFile;
        }
        return arr;
    }

    private CompilationUnit[] asArray(HashMap table) {
        CompilationUnit[] arr = new CompilationUnit[table.values().size()];
        int index = 0;
        Iterator iter = table.values().iterator();
        while (iter.hasNext()) {
            arr[index++] = ((FileInfo)iter.next()).newFile;
        }
        return arr;
    }

    private void getUpdatedFiles(HashMap newFiles, HashMap updatedFiles, HashMap expiredFiles, boolean shallowModel) {
        String[] files = this.project.getSourceFiles();
        double delta = 0.0;
        if (this.jobControl != null) {
            if (files.length > 0) {
                delta = 1.0 / (double)files.length;
            } else {
                this.jobControl.update(1.0);
            }
        }
        int i = 0;
        while (i < files.length) {
            CompilationUnit newFile;
            if (!this.canContinue()) {
                return;
            }
            String file = files[i];
            CompilationUnit oldFile = this.model.lookupSourceFile(file);
            if (oldFile != null) {
                if (oldFile.getTimestamp() < this.project.getTimestamp(file) && (newFile = this.parseFile(file, !shallowModel)) != null) {
                    if (Diff.diffFiles(newFile, oldFile)) {
                        expiredFiles.put(file, new FileInfo(oldFile, newFile));
                        this.project.getLog().log(new Message(1, resourceBundle.getString("jparser.Control.1"), new Object[]{file}));
                    } else {
                        updatedFiles.put(file, new FileInfo(oldFile, newFile));
                        this.project.getLog().log(new Message(1, resourceBundle.getString("jparser.Control.2"), new Object[]{file}));
                    }
                }
            } else {
                newFile = this.parseFile(file, !shallowModel);
                if (newFile != null) {
                    newFiles.put(file, new FileInfo(null, newFile));
                    this.project.getLog().log(new Message(1, resourceBundle.getString("jparser.Control.3"), new Object[]{file}));
                }
            }
            if (this.jobControl != null) {
                this.jobControl.update(delta);
            }
            ++i;
        }
    }

    private CompilationUnit[] getRemovedFiles() {
        String[] files = this.project.getSourceFiles();
        Iterator i = this.model.getSourceFiles().iterator();
        LinkedList<CompilationUnit> removed = new LinkedList<CompilationUnit>();
        block0: while (i.hasNext()) {
            CompilationUnit cu = (CompilationUnit)i.next();
            int j = 0;
            while (j < files.length) {
                if (files[j].equals(cu.getFilename())) continue block0;
                ++j;
            }
            removed.add(cu);
        }
        return removed.toArray(new CompilationUnit[removed.size()]);
    }

    private HashSet buildDependenceClosure(Collection expiredTypes) {
        HashSet typeClosure = new HashSet();
        Iterator i = expiredTypes.iterator();
        while (i.hasNext()) {
            FileInfo fi = (FileInfo)i.next();
            CompilationUnit cu = fi.oldFile;
            int j = 0;
            while (j < cu.symbol.numTypes()) {
                this.processType(cu.symbol.getType(j), typeClosure);
                ++j;
            }
        }
        HashSet<Declaration> fileClosure = new HashSet<Declaration>();
        i = typeClosure.iterator();
        while (i.hasNext()) {
            CClassType cls = (CClassType)i.next();
            CCompilationUnit cu = cls.getCompilationUnit();
            if (cu == null) continue;
            fileClosure.add(cu.getAST());
        }
        return fileClosure;
    }

    private void processType(CClassType cls, HashSet set) {
        this.computeTypeClosure(cls, set);
        if (cls.getTypes() != null) {
            Iterator i = cls.getTypes().iterator();
            while (i.hasNext()) {
                this.processType((CClassType)i.next(), set);
            }
        }
    }

    private void computeTypeClosure(CClassType cls, HashSet set) {
        if (!set.add(cls)) {
            return;
        }
        Iterator i = cls.getExportCouplings().iterator();
        while (i.hasNext()) {
            this.computeTypeClosure((CClassType)i.next(), set);
        }
    }

    public boolean canContinue() {
        if (this.jobControl != null && this.jobControl.isCanceled()) {
            this.model.removePendingFiles();
            return false;
        }
        return true;
    }

    public void updateJob(double delta) {
        if (this.jobControl != null) {
            this.jobControl.update(delta);
        }
    }

    public boolean isAssertEnabled() {
        return this.project.isAssertEnabled();
    }

    public CompilationUnit parseFile(String filename, boolean deep) {
        ErrorMgr.setModel(this.model);
        Reader in = null;
        CompilationUnit tree = null;
        try {
            in = this.project.openFile(filename);
            if (in == null) {
                this.logError("jparser.Control.7", new Object[]{filename});
                return null;
            }
            JavaLexer lexer = new JavaLexer(filename, in, this.project.getTabSize(), this.project.isAssertEnabled(), false);
            JavaRecognizer parser = new JavaRecognizer(lexer);
            parser.setLexer(lexer);
            parser.setFilename(filename);
            parser.setDeep(deep);
            tree = parser.compilationUnit();
        }
        catch (Exception e) {
            this.logError("jparser.Control.8", new Object[]{e});
            tree = null;
        }
        try {
            in.close();
        }
        catch (Exception e) {
            this.logError("jparser.Control.9", new Object[]{e});
        }
        if (tree != null) {
            long timestamp = this.project.getTimestamp(filename);
            if (timestamp == -1L) {
                this.logError("jparser.Control.10", new Object[]{filename});
                return null;
            }
            tree.setFile(filename, timestamp);
        }
        ErrorMgr.setModel(null);
        return tree;
    }

    public void logError(String message) {
        if (this.project != null) {
            this.project.getLog().log(new Message(2, message, null));
        }
    }

    public void logError(String message, Object[] values) {
        if (this.project != null) {
            this.project.getLog().log(new Message(2, resourceBundle.getString(message), values));
        }
    }

    private static class FileInfo {
        CompilationUnit oldFile;
        CompilationUnit newFile;

        FileInfo(CompilationUnit oldFile, CompilationUnit newFile) {
            this.oldFile = oldFile;
            this.newFile = newFile;
        }
    }
}

