/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser;

import java.util.Hashtable;

public class CmdOptions {
    public boolean assertEnabled = false;
    public String classpath = null;
    public String dbfile = null;
    public String[] infiles = null;
    public boolean showAllTypes = false;
    public boolean showModelTree = false;
    public boolean writeModelTree = false;
    public boolean showSymbolTable = false;
    public int tabSize = 4;
    private Hashtable opts = new Hashtable();

    public CmdOptions() {
        this.opts.put("--assert", "-A");
        this.opts.put("--classpath", "-c");
        this.opts.put("--showall", "-a");
        this.opts.put("--tabsize", "-b");
        this.opts.put("--showsymbol", "-s");
        this.opts.put("--showtree", "-t");
        this.opts.put("--writetree", "-w");
        this.opts.put("--dbfile", "-f");
        this.opts.put("--help", "-h");
        this.opts.put("--version", "-v");
    }

    public boolean parseCommandLine(String[] argv) {
        int argsInd = 0;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].startsWith("-")) {
                ++argsInd;
                int c = -1;
                if (argv[i].length() > 2) {
                    String shortName = (String)this.opts.get(argv[i]);
                    if (shortName != null) {
                        c = shortName.charAt(1);
                    }
                } else if (argv[i].length() == 2) {
                    c = argv[i].charAt(1);
                }
                switch (c) {
                    case 97: {
                        this.showAllTypes = true;
                        break;
                    }
                    case 65: {
                        this.assertEnabled = true;
                        break;
                    }
                    case 98: {
                        if (i < argv.length - 1) {
                            this.tabSize = this.getInt(argv[i + 1], this.tabSize);
                            ++argsInd;
                            break;
                        }
                        this.tabSize = this.getInt(null, this.tabSize);
                        break;
                    }
                    case 116: {
                        this.showModelTree = true;
                        break;
                    }
                    case 119: {
                        this.writeModelTree = true;
                        break;
                    }
                    case 115: {
                        this.showSymbolTable = true;
                        break;
                    }
                    case 99: {
                        if (i < argv.length - 1) {
                            this.classpath = argv[i + 1];
                            ++argsInd;
                            break;
                        }
                        this.classpath = null;
                        break;
                    }
                    case 102: {
                        if (i < argv.length - 1) {
                            this.dbfile = argv[i + 1];
                            ++argsInd;
                            break;
                        }
                        this.dbfile = null;
                        break;
                    }
                    case 118: {
                        this.version();
                        System.exit(0);
                        break;
                    }
                    default: {
                        this.help();
                        System.exit(0);
                    }
                }
            }
            ++i;
        }
        int size = argv.length - argsInd;
        this.infiles = new String[size];
        System.arraycopy(argv, argsInd, this.infiles, 0, this.infiles.length);
        return true;
    }

    public void printOptions() {
        System.out.println("  --assert, -A:          treat assert as keyword (JDK 1.4)");
        System.out.println("  --classpath, -c path:  use path for CLASSPATH");
        System.out.println("  --showall, -a:         show symbolic information for all types");
        System.out.println("  --showsymbol, -s:      show symbol table");
        System.out.println("  --showtree, -t:        show AST tree structure");
        System.out.println("  --writetree, -w:       print source files from AST tree");
        System.out.println("  --dbfile, -f file:     store/load symbolic information in file");
        System.out.println("  --tabsize, -b tabsize: set tab size (8 by default)");
        System.out.println("  --help, -h:            display help information");
        System.out.println("  --version, -v:         print version information");
    }

    public void version() {
        System.err.println("Sapient for Java 1.0");
        System.err.println("Copyright (C) Togethersoft 2000, 2002. All rights reserved.");
    }

    public void usage() {
        this.version();
        System.out.println();
        System.out.println("usage: com.togethersoft.jparse.JParser [options] [--help] <java-files>");
    }

    public void help() {
        this.usage();
        this.printOptions();
    }

    protected int getInt(String arg, int defaultValue) {
        try {
            return arg != null ? new Integer(arg) : defaultValue;
        }
        catch (Exception e) {
            System.err.println("malformed option: " + arg);
            System.exit(0);
            return 0;
        }
    }
}

