/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.ILatticeElement;
import com.togethersoft.sca.dataflow.values.IObjectDomain;
import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.values.ArrayObjectDomain;
import com.togethersoft.sca.internal.dataflow.values.BadDomain;
import com.togethersoft.sca.internal.dataflow.values.BooleanDomain;
import com.togethersoft.sca.internal.dataflow.values.DoubleDomain;
import com.togethersoft.sca.internal.dataflow.values.FloatDomain;
import com.togethersoft.sca.internal.dataflow.values.IntegralDomain;
import com.togethersoft.sca.internal.dataflow.values.ObjectDomain;
import com.togethersoft.sca.internal.dataflow.values.VoidDomain;
import java.io.PrintStream;

public abstract class ValueDomain
implements IValueDomain {
    public boolean equals(IValueDomain element) {
        if (this == element) {
            return true;
        }
        int type = element.getValueType();
        if (type != this.getValueType() || this.isEmpty() != element.isEmpty()) {
            return false;
        }
        switch (type) {
            case 9: {
                return ((ObjectDomain)this).equals1((IObjectDomain)element);
            }
            case 10: {
                return ((ArrayObjectDomain)this).equals1((IObjectDomain)element);
            }
            case 8: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return ((IntegralDomain)this).equals1((IIntegralDomain)element);
            }
            case 7: {
                return ((DoubleDomain)this).equals1((IRealDomain)element);
            }
            case 6: {
                return ((FloatDomain)this).equals1((IRealDomain)element);
            }
        }
        return true;
    }

    public IValueDomain meet(IValueDomain element) {
        if (this.getValueType() == 0 || element.getValueType() == 0) {
            return BadDomain.instance();
        }
        if (this == element || this.equals(element) || this.isEmpty()) {
            return this;
        }
        if (element.isEmpty()) {
            return element;
        }
        switch (this.getValueType()) {
            case 9: 
            case 10: {
                return ((ObjectDomain)this).intersect((IObjectDomain)element);
            }
            case 8: {
                return element;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return IntegralDomain.intersect((IntegralDomain)this, (IIntegralDomain)element);
            }
            case 7: {
                return ((DoubleDomain)this).intersect((IRealDomain)element);
            }
            case 6: {
                return ((FloatDomain)this).intersect((IRealDomain)element);
            }
        }
        return this;
    }

    public IValueDomain join(IValueDomain element) {
        if (this.getValueType() == 0 || element.getValueType() == 0) {
            return BadDomain.instance();
        }
        if (this == element || this.equals(element) || element.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return element;
        }
        switch (this.getValueType()) {
            case 9: 
            case 10: {
                return ((ObjectDomain)this).combine((IObjectDomain)element);
            }
            case 8: {
                return this;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return ((IntegralDomain)this).combine((IIntegralDomain)element);
            }
            case 7: {
                return ((DoubleDomain)this).combine((IRealDomain)element);
            }
            case 6: {
                return ((FloatDomain)this).combine((IRealDomain)element);
            }
        }
        return this;
    }

    public boolean equals(ILatticeElement element) {
        return this.equals((IValueDomain)element);
    }

    public ILatticeElement meet(ILatticeElement element) {
        return this.meet((IValueDomain)element);
    }

    public ILatticeElement join(ILatticeElement element) {
        return this.join((IValueDomain)element);
    }

    public static ValueDomain getDefault(int type, AstTypeReference javaType) {
        switch (type) {
            case 9: 
            case 10: {
                return ObjectDomain.getDefault(javaType);
            }
            case 8: {
                return BooleanDomain.get();
            }
            case 1: {
                return IntegralDomain.forByte();
            }
            case 3: {
                return IntegralDomain.forChar();
            }
            case 7: {
                return DoubleDomain.getDefault();
            }
            case 6: {
                return FloatDomain.getDefault();
            }
            case 4: {
                return IntegralDomain.forInt();
            }
            case 5: {
                return IntegralDomain.forLong();
            }
            case 2: {
                return IntegralDomain.forShort();
            }
            case 11: {
                return VoidDomain.get();
            }
        }
        return BadDomain.instance();
    }

    public static ValueDomain getEmpty(int type, AstTypeReference javaType) {
        switch (type) {
            case 9: 
            case 10: {
                return ObjectDomain.getEmpty(javaType);
            }
            case 8: {
                return BooleanDomain.get();
            }
            case 1: {
                return IntegralDomain.forEmptyByte();
            }
            case 3: {
                return IntegralDomain.forEmptyChar();
            }
            case 7: {
                return DoubleDomain.getDefault();
            }
            case 6: {
                return FloatDomain.getDefault();
            }
            case 4: {
                return IntegralDomain.forEmptyInt();
            }
            case 5: {
                return IntegralDomain.forEmptyLong();
            }
            case 2: {
                return IntegralDomain.forEmptyShort();
            }
            case 11: {
                return VoidDomain.get();
            }
        }
        return BadDomain.instance();
    }

    public abstract void printBrief(PrintStream var1);

    public abstract boolean isConstant();

    public abstract int getValueType();

    public abstract boolean isEmpty();

    public abstract boolean isBottom();

    public abstract boolean isTop();
}

