/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IShortConstant;
import com.togethersoft.sca.internal.dataflow.values.AbstractIntegralConstant;
import java.io.PrintStream;

public class ShortConstant
extends AbstractIntegralConstant
implements IShortConstant {
    private short value;

    public ShortConstant(short value) {
        super(false);
        this.value = value;
    }

    public ShortConstant(int value) {
        this((short)value, false);
    }

    public ShortConstant(short value, boolean outOfBounds) {
        super(outOfBounds);
        this.value = value;
    }

    public Object asObject() {
        return new Short(this.value);
    }

    public short getValue() {
        return this.value;
    }

    public long minTypeValue() {
        return -32768L;
    }

    public long maxTypeValue() {
        return 32767L;
    }

    public void printBrief(PrintStream out) {
        out.print("ShortConst: " + this.value);
    }

    protected IIntegralDomain buildSelf(long value, boolean outOfBounds) {
        return new ShortConstant((short)value, outOfBounds);
    }

    protected long getLongValue() {
        return this.value;
    }

    protected int getType() {
        return 2;
    }

    public int getValueType() {
        return 2;
    }
}

