/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import com.togethersoft.sca.internal.dataflow.values.BooleanDomain;
import com.togethersoft.sca.internal.dataflow.values.ValueDomain;
import java.io.PrintStream;

public abstract class RealDomain
extends ValueDomain
implements IRealDomain {
    protected int stateMask;

    public boolean isConstant() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean mayBePositiveInfinity() {
        return (this.stateMask & 1) != 0;
    }

    public boolean mayBeNegativeInfinity() {
        return (this.stateMask & 2) != 0;
    }

    public boolean mayBeNaN() {
        return (this.stateMask & 4) != 0;
    }

    protected RealDomain(int maskValue) {
        this.stateMask = maskValue;
    }

    public IBooleanDomain doLT(IRealDomain domain) {
        if (this.getLowValue() >= domain.getHighValue()) {
            return BooleanConstant.forFalse();
        }
        if (this.getHighValue() < domain.getLowValue()) {
            return BooleanConstant.forTrue();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doGT(IRealDomain domain) {
        if (this.getLowValue() > domain.getHighValue()) {
            return BooleanConstant.forTrue();
        }
        if (this.getHighValue() <= domain.getLowValue()) {
            return BooleanConstant.forFalse();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doLE(IRealDomain domain) {
        if (this.getLowValue() > domain.getHighValue()) {
            return BooleanConstant.forFalse();
        }
        if (this.getHighValue() <= domain.getLowValue()) {
            return BooleanConstant.forTrue();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doGE(IRealDomain domain) {
        if (this.getLowValue() >= domain.getHighValue()) {
            return BooleanConstant.forTrue();
        }
        if (this.getHighValue() < domain.getLowValue()) {
            return BooleanConstant.forFalse();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doEQ(IRealDomain domain) {
        if (domain.isConstant()) {
            if (Double.isNaN(domain.getLowValue())) {
                return BooleanConstant.forFalse();
            }
            if (Double.isInfinite(domain.getLowValue())) {
                return BooleanDomain.get();
            }
        }
        if (domain.getHighValue() < this.getLowValue() || domain.getLowValue() > this.getHighValue()) {
            return BooleanConstant.forFalse();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doNE(IRealDomain domain) {
        if (domain.isConstant()) {
            if (Double.isNaN(domain.getLowValue())) {
                return BooleanConstant.forTrue();
            }
            if (Double.isInfinite(domain.getLowValue())) {
                return BooleanDomain.get();
            }
        }
        if (domain.getHighValue() < this.getLowValue() || domain.getLowValue() > this.getHighValue()) {
            return BooleanConstant.forTrue();
        }
        return BooleanDomain.get();
    }

    public void printBrief(PrintStream out) {
        out.print("Real Domain: type =" + this.getValueType() + " [" + this.getLowValue() + ", " + this.getHighValue() + "] may be positive infinity = " + this.mayBePositiveInfinity() + " may be negative infinity " + this.mayBeNegativeInfinity());
    }

    public int getStateMask() {
        return this.stateMask;
    }

    public abstract IRealDomain doDEC();

    public abstract IRealDomain doINC();

    public abstract IRealDomain doNEG();

    public abstract IRealDomain doSUB(IRealDomain var1);

    public abstract IRealDomain doADD(IRealDomain var1);

    public abstract IRealDomain doMOD(IRealDomain var1);

    public abstract IRealDomain doDIV(IRealDomain var1);

    public abstract IRealDomain doMUL(IRealDomain var1);

    public abstract IValueDomain intersect(double var1, double var3);

    public abstract double getHighValue();

    public abstract double getLowValue();

    public abstract double maxTypeValue();

    public abstract double minTypeValue();
}

