/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IObjectDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.known.KnownInfoLoader;
import com.togethersoft.sca.internal.dataflow.values.ArrayObjectDomain;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import com.togethersoft.sca.internal.dataflow.values.BooleanDomain;
import com.togethersoft.sca.internal.dataflow.values.EmptyObjectDomain;
import com.togethersoft.sca.internal.dataflow.values.IntegralDomain;
import com.togethersoft.sca.internal.dataflow.values.ValueDomain;
import java.io.PrintStream;
import java.util.WeakHashMap;

public class ObjectDomain
extends ValueDomain
implements IObjectDomain {
    public static int mayBeNull = 1;
    public static int mayBeNonNull = 2;
    private AstTypeReference javaType;
    private int mask;
    private static WeakHashMap defaultMap = new WeakHashMap();
    private static WeakHashMap emptyMap = new WeakHashMap();

    public boolean mayBeNull() {
        return (this.mask & mayBeNull) != 0;
    }

    public boolean mayBeNonNull() {
        return (this.mask & mayBeNonNull) != 0;
    }

    public boolean isNull() {
        return (this.mask & (mayBeNull | mayBeNonNull)) == mayBeNull;
    }

    public boolean nullSuspicious() {
        return this.isNull();
    }

    public void setAsNullSuspicious() {
    }

    protected ObjectDomain(int mask, AstTypeReference javaType) {
        this.mask = mask;
        this.javaType = javaType;
    }

    protected ObjectDomain(AstTypeReference javaType) {
        this(mayBeNull | mayBeNonNull, javaType);
    }

    public boolean equals1(IObjectDomain element) {
        if (element instanceof ObjectDomain) {
            ObjectDomain domain = (ObjectDomain)element;
            return !domain.isEmpty() && !domain.isArrayObject() && this.mask == domain.mask && this.javaType == domain.javaType;
        }
        return false;
    }

    public int getValueType() {
        return 9;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isTop() {
        return (this.mask & (mayBeNull | mayBeNonNull)) == (mayBeNull | mayBeNonNull);
    }

    private static int typeHeight(AstType t1) {
        int h = 0;
        while (t1 != null) {
            t1 = t1.getSuperClass();
            ++h;
        }
        return h;
    }

    private static AstType[] typeChain(AstType t) {
        AstType[] ta = new AstType[ObjectDomain.typeHeight(t)];
        int idx = ta.length;
        while (t != null) {
            ta[--idx] = t;
            t = t.getSuperClass();
        }
        return ta;
    }

    private static AstType commonType1(AstType t1, AstType t2) {
        AstType[] ta1 = ObjectDomain.typeChain(t1);
        AstType[] ta2 = ObjectDomain.typeChain(t2);
        int idx = 0;
        while (idx < ta1.length && idx < ta2.length && ta1[idx] == ta2[idx]) {
            ++idx;
        }
        if (--idx >= 0) {
            return ta1[idx];
        }
        return KnownInfoLoader.getJavaLangObject().getAstType();
    }

    public static AstTypeReference commonType(AstTypeReference t1, AstTypeReference t2) {
        AstType objType = KnownInfoLoader.getJavaLangObject().getAstType();
        if (t1 == null || t2 == null || t1 == objType || t2 == objType) {
            return objType;
        }
        if (t1 == t2) {
            return t1;
        }
        if (t1.numDimensions() != t2.numDimensions()) {
            return objType;
        }
        AstType b1 = t1.getBaseType();
        AstType b2 = t2.getBaseType();
        if (t1.numDimensions() != 0) {
            AstType b3 = ObjectDomain.commonType1(b1, b2);
            if (b3 == b1) {
                return b1;
            }
            if (b3 == b2) {
                return b2;
            }
            return objType;
        }
        return ObjectDomain.commonType1(b1, b2);
    }

    private static AstType specificType1(AstType t1, AstType t2) {
        AstType[] ta1 = ObjectDomain.typeChain(t1);
        AstType[] ta2 = ObjectDomain.typeChain(t2);
        int i = 0;
        while (i < ta1.length) {
            if (ta1[i] == t2) {
                return t1;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < ta2.length) {
            if (ta2[i2] == t1) {
                return t2;
            }
            ++i2;
        }
        return KnownInfoLoader.getJavaLangObject().getAstType();
    }

    private static AstTypeReference specificType(AstTypeReference t1, AstTypeReference t2) {
        AstType objType = KnownInfoLoader.getJavaLangObject().getAstType();
        if (t1 == null) {
            if (t2 == null) {
                return objType;
            }
            return t2;
        }
        if (t1 == objType) {
            return t2;
        }
        if (t2 == objType) {
            return t1;
        }
        if (t1 == t2) {
            return t1;
        }
        if (t1.numDimensions() != t2.numDimensions()) {
            return objType;
        }
        AstType b1 = t1.getBaseType();
        AstType b2 = t2.getBaseType();
        if (t1.numDimensions() != 0) {
            AstType b3 = ObjectDomain.specificType1(b1, b2);
            if (b3 == b1) {
                return b1;
            }
            if (b3 == b2) {
                return b2;
            }
            return objType;
        }
        return ObjectDomain.specificType1(b1, b2);
    }

    public IValueDomain intersect(IObjectDomain domain) {
        int domainMask = 0;
        if (domain.mayBeNull()) {
            domainMask |= mayBeNull;
        }
        if (domain.mayBeNonNull()) {
            domainMask |= mayBeNonNull;
        }
        int newMask = this.mask & domainMask;
        boolean newIsArray = this.isArrayObject() && domain.isArrayObject();
        boolean newIsNullSuspicious = false;
        AstTypeReference atr = ObjectDomain.specificType(this.frontEndType(), domain.frontEndType());
        IIntegralDomain newLengthDomain = null;
        if (newIsArray) {
            newLengthDomain = this.arrayLengthDomain() != null && domain.arrayLengthDomain() != null ? (IIntegralDomain)this.arrayLengthDomain().meet(domain.arrayLengthDomain()) : IntegralDomain.forArray();
        }
        if (newMask == this.mask && newIsArray == this.isArrayObject() && newIsNullSuspicious == this.nullSuspicious() && atr == this.frontEndType() && (newLengthDomain == this.arrayLengthDomain() || newLengthDomain != null && newLengthDomain.equals(this.arrayLengthDomain()))) {
            return this;
        }
        if (newMask == domainMask && newIsArray == domain.isArrayObject() && newIsNullSuspicious == domain.nullSuspicious() && atr == domain.frontEndType() && (newLengthDomain == domain.arrayLengthDomain() || newLengthDomain != null && newLengthDomain.equals(domain.arrayLengthDomain()))) {
            return domain;
        }
        if (newIsArray) {
            return ObjectDomain.build(newMask, atr, newLengthDomain);
        }
        return ObjectDomain.build(newMask, atr);
    }

    public IValueDomain combine(IObjectDomain domain) {
        int domainMask = 0;
        if (domain.mayBeNull()) {
            domainMask |= mayBeNull;
        }
        if (domain.mayBeNonNull()) {
            domainMask |= mayBeNonNull;
        }
        int newMask = this.mask | domainMask;
        boolean newIsArray = this.isArrayObject() && domain.isArrayObject();
        boolean newIsNullSuspicious = false;
        AstTypeReference atr = ObjectDomain.commonType(this.frontEndType(), domain.frontEndType());
        IIntegralDomain newLengthDomain = null;
        if (newIsArray) {
            newLengthDomain = this.arrayLengthDomain() != null && domain.arrayLengthDomain() != null ? (IIntegralDomain)this.arrayLengthDomain().join(domain.arrayLengthDomain()) : IntegralDomain.forArray();
        }
        if (newMask == this.mask && newIsArray == this.isArrayObject() && newIsNullSuspicious == this.nullSuspicious() && atr == this.frontEndType() && (newLengthDomain == this.arrayLengthDomain() || newLengthDomain != null && newLengthDomain.equals(this.arrayLengthDomain()))) {
            return this;
        }
        if (newMask == domainMask && newIsArray == domain.isArrayObject() && newIsNullSuspicious == domain.nullSuspicious() && atr == domain.frontEndType() && (newLengthDomain == domain.arrayLengthDomain() || newLengthDomain != null && newLengthDomain.equals(domain.arrayLengthDomain()))) {
            return domain;
        }
        if (newIsArray) {
            return ObjectDomain.build(newMask, atr, newLengthDomain);
        }
        return ObjectDomain.build(newMask, atr);
    }

    public IBooleanDomain doEQ(IObjectDomain domain) {
        if (domain.isConstant() && domain.isNull()) {
            if (this.mayBeNull()) {
                this.setAsNullSuspicious();
            } else {
                return BooleanConstant.forFalse();
            }
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doNE(IObjectDomain domain) {
        if (domain.isConstant() && domain.isNull()) {
            if (this.mayBeNull()) {
                this.setAsNullSuspicious();
            } else {
                return BooleanConstant.forTrue();
            }
        }
        return BooleanDomain.get();
    }

    public AstTypeReference frontEndType() {
        return this.javaType;
    }

    public boolean isArrayObject() {
        return false;
    }

    public IIntegralDomain arrayLengthDomain() {
        return null;
    }

    public void printBrief(PrintStream out) {
        out.print("Object domain: null suspicious=" + this.nullSuspicious() + " may be NULL =" + this.mayBeNull() + " may be non null =" + this.mayBeNonNull() + " Front end type is " + (this.javaType == null ? "NULL" : this.javaType.getTypeName()));
    }

    public int getMask() {
        return this.mask;
    }

    public static ObjectDomain build(int mask, AstTypeReference javaType) {
        if ((mask & (mayBeNull | mayBeNonNull)) == (mayBeNull | mayBeNonNull)) {
            return ObjectDomain.getDefault(javaType);
        }
        return new ObjectDomain(mask, javaType);
    }

    public static ObjectDomain build(int mask, AstTypeReference javaType, IIntegralDomain lengthDomain) {
        if ((mask & (mayBeNull | mayBeNonNull)) == (mayBeNull | mayBeNonNull) && IntegralDomain.forArray().equals(lengthDomain)) {
            return ObjectDomain.getDefault(javaType);
        }
        return new ArrayObjectDomain(mask, javaType, lengthDomain);
    }

    public static ObjectDomain getDefault(AstTypeReference javaType) {
        ObjectDomain domain;
        Object o = defaultMap.get(javaType);
        if (o == null) {
            if (javaType == null) {
                javaType = KnownInfoLoader.getJavaLangObject().getAstType();
            }
            domain = javaType.numDimensions() == 0 ? new ObjectDomain(mayBeNull | mayBeNonNull, javaType) : new ArrayObjectDomain(mayBeNull | mayBeNonNull, javaType, IntegralDomain.forArray());
            defaultMap.put(javaType, domain);
        } else {
            domain = (ObjectDomain)o;
        }
        return domain;
    }

    public static ObjectDomain getEmpty(AstTypeReference javaType) {
        ObjectDomain domain;
        Object o = emptyMap.get(javaType);
        if (o == null) {
            domain = new EmptyObjectDomain(javaType);
            emptyMap.put(javaType, domain);
        } else {
            domain = (ObjectDomain)o;
        }
        return domain;
    }

    public static void cleanup() {
        defaultMap.clear();
        emptyMap.clear();
    }
}

