/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.ILatticeElement;
import com.togethersoft.sca.dataflow.values.IObjectConstant;
import com.togethersoft.sca.dataflow.values.IObjectDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import com.togethersoft.sca.internal.dataflow.values.ConstantVal;
import com.togethersoft.sca.internal.dataflow.values.ObjectDomain;
import java.io.PrintStream;

public class ObjectConstant
extends ConstantVal
implements IObjectConstant {
    private static ObjectConstant theNull = new ObjectConstant(null);
    private AstTypeReference javaType;
    private Object value;

    public int getValueType() {
        return 9;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean equals(ILatticeElement element) {
        if (element == this) {
            return true;
        }
        if (element instanceof ObjectConstant) {
            ObjectConstant oc = (ObjectConstant)element;
            return oc.javaType == this.javaType && (this.value == oc.value || oc.value != null && oc.value.equals(this.value));
        }
        return false;
    }

    public boolean equals(IValueDomain element) {
        if (element == this) {
            return true;
        }
        if (element instanceof ObjectConstant) {
            ObjectConstant oc = (ObjectConstant)element;
            return oc.javaType == this.javaType && (this.value == oc.value || oc.value != null && oc.value.equals(this.value));
        }
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public ILatticeElement join(ILatticeElement element) {
        return this.join((IValueDomain)element);
    }

    public IValueDomain join(IValueDomain element) {
        if (element.getValueType() == 0) {
            return element;
        }
        if (element.isEmpty()) {
            return this;
        }
        IObjectDomain domain = (IObjectDomain)element;
        if (!domain.isConstant()) {
            return domain.join(this);
        }
        Object secondValue = ((IObjectConstant)domain).getValue();
        if (this.value == secondValue && this.frontEndType() == domain.frontEndType()) {
            return this;
        }
        ObjectDomain obd = ObjectDomain.build((this.value == null || secondValue == null ? ObjectDomain.mayBeNull : 0) | ObjectDomain.mayBeNonNull, this.value == null ? domain.frontEndType() : this.frontEndType());
        return obd;
    }

    public ILatticeElement meet(ILatticeElement element) {
        return element;
    }

    public IValueDomain meet(IValueDomain element) {
        return element;
    }

    public int getValueKind() {
        return 2;
    }

    public boolean mayBeNull() {
        return this.value == null;
    }

    public boolean mayBeNonNull() {
        return this.value != null;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean nullSuspicious() {
        return this.value == null;
    }

    public boolean isArrayObject() {
        if (this.value == null) {
            return false;
        }
        return this.value.getClass().isArray();
    }

    public IIntegralDomain arrayLengthDomain() {
        return null;
    }

    public IBooleanDomain doEQ(IObjectDomain domain) {
        if (!domain.isConstant()) {
            return domain.doEQ(this);
        }
        if (this.value == ((ObjectConstant)domain).getValue()) {
            return BooleanConstant.forTrue();
        }
        return BooleanConstant.forFalse();
    }

    public IBooleanDomain doNE(IObjectDomain domain) {
        if (!domain.isConstant()) {
            return domain.doEQ(this);
        }
        if (this.value != ((ObjectConstant)domain).getValue()) {
            return BooleanConstant.forTrue();
        }
        return BooleanConstant.forFalse();
    }

    public boolean isConstant() {
        return true;
    }

    public Object getValue() {
        return this.value;
    }

    public AstTypeReference frontEndType() {
        return this.javaType;
    }

    public Object asObject() {
        return this.value;
    }

    public void setFrontEndTypeReference(AstTypeReference ref) {
        this.javaType = ref;
    }

    public ObjectConstant(Object valInit) {
        this.value = valInit;
        this.javaType = null;
    }

    public void printBrief(PrintStream out) {
        if (this.value instanceof String) {
            out.print("ObjectConst: " + (String)this.value);
        } else {
            out.print("ObjectConst: " + (this.value == null ? "null" : "non null"));
        }
    }

    public static ObjectConstant forNull() {
        return theNull;
    }
}

