/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.ILongConstant;
import com.togethersoft.sca.internal.dataflow.values.AbstractIntegralConstant;
import java.io.PrintStream;

public class LongConstant
extends AbstractIntegralConstant
implements ILongConstant {
    private long value;

    public LongConstant(long value) {
        super(false);
        this.value = value;
    }

    public LongConstant(long value, boolean outOfBounds) {
        super(outOfBounds);
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public Object asObject() {
        return new Long(this.value);
    }

    public long minTypeValue() {
        return Long.MIN_VALUE;
    }

    public long maxTypeValue() {
        return Long.MAX_VALUE;
    }

    public void printBrief(PrintStream out) {
        out.print("LongConst: " + this.value);
    }

    protected long getLongValue() {
        return this.value;
    }

    protected int getType() {
        return 5;
    }

    public int getValueType() {
        return 5;
    }

    protected IIntegralDomain buildSelf(long value, boolean outOfBounds) {
        return new LongConstant(value, outOfBounds);
    }
}

