/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import com.togethersoft.sca.internal.dataflow.values.BooleanDomain;
import com.togethersoft.sca.internal.dataflow.values.ByteConstant;
import com.togethersoft.sca.internal.dataflow.values.CharConstant;
import com.togethersoft.sca.internal.dataflow.values.IntConstant;
import com.togethersoft.sca.internal.dataflow.values.LongConstant;
import com.togethersoft.sca.internal.dataflow.values.ShortConstant;
import com.togethersoft.sca.internal.dataflow.values.ValueDomain;
import java.io.PrintStream;

public class IntegralDomain
extends ValueDomain
implements IIntegralDomain {
    private int type;
    private boolean outOfBounds;
    private long lowValue;
    private long highValue;
    private long zeroBitMask;
    private long onesBitMask;
    private static IIntegralDomain arrayDomain = IntegralDomain.build(4, 0L, 0x3FFFFFFFL, -1073741824L, 0L, false);
    private static IntegralDomain byteEmptyDomain = new IntegralDomain(1, 0L, -1L, 0L, 0L);
    private static IntegralDomain charEmptyDomain = new IntegralDomain(3, 0L, -1L, 0L, 0L);
    private static IntegralDomain shortEmptyDomain = new IntegralDomain(2, 0L, -1L, 0L, 0L);
    private static IntegralDomain intEmptyDomain = new IntegralDomain(4, 0L, -1L, 0L, 0L);
    private static IntegralDomain longEmptyDomain = new IntegralDomain(5, 0L, -1L, 0L, 0L);
    private static IntegralDomain byteDefaultDomain = new IntegralDomain(1);
    private static IntegralDomain charDefaultDomain = new IntegralDomain(3);
    private static IntegralDomain shortDefaultDomain = new IntegralDomain(2);
    private static IntegralDomain intDefaultDomain = new IntegralDomain(4);
    private static IntegralDomain longDefaultDomain = new IntegralDomain(5);

    public long getLowValue() {
        return this.lowValue;
    }

    public long getHighValue() {
        return this.highValue;
    }

    public long getZeroBitMask() {
        return this.zeroBitMask;
    }

    public long getOnesBitMask() {
        return this.onesBitMask;
    }

    public IIntegralDomain combine(IIntegralDomain domain) {
        boolean oob;
        long newLow = this.lowValue <= domain.getLowValue() ? this.lowValue : domain.getLowValue();
        long newHigh = this.highValue >= domain.getHighValue() ? this.highValue : domain.getHighValue();
        long newZero = this.zeroBitMask & domain.getZeroBitMask();
        long newOnes = this.onesBitMask & domain.getOnesBitMask();
        boolean bl = oob = this.isOutOfBounds() || domain.isOutOfBounds();
        if (newLow == this.lowValue && newHigh == this.highValue && newZero == this.zeroBitMask && newOnes == this.onesBitMask && oob == this.isOutOfBounds()) {
            return this;
        }
        if (newLow == domain.getLowValue() && newHigh == domain.getHighValue() && newZero == domain.getZeroBitMask() && newOnes == domain.getOnesBitMask() && oob == domain.isOutOfBounds()) {
            return domain;
        }
        return IntegralDomain.build(this.getValueType(), newLow, newHigh, newZero, newOnes, oob);
    }

    public IIntegralDomain combine(IIntegralDomain domain, long[] values) {
        long newLow = this.lowValue > domain.getLowValue() ? IntegralDomain.max(this.minTypeValue(), IntegralDomain.findLow(values, domain.getLowValue())) : this.lowValue;
        long newHigh = this.highValue < domain.getHighValue() ? IntegralDomain.min(this.maxTypeValue(), IntegralDomain.findHigh(values, domain.getHighValue())) : this.highValue;
        long newZero = this.zeroBitMask & domain.getZeroBitMask();
        long newOnes = this.onesBitMask & domain.getOnesBitMask();
        if (newLow == this.lowValue && newHigh == this.highValue && newZero == this.zeroBitMask && newOnes == this.onesBitMask) {
            return this;
        }
        if (newLow == domain.getLowValue() && newHigh == domain.getHighValue() && newZero == domain.getZeroBitMask() && newOnes == domain.getOnesBitMask()) {
            return domain;
        }
        return IntegralDomain.build(this.getValueType(), newLow, newHigh, newZero, newOnes, false);
    }

    private static long findLow(long[] values, long v) {
        if (values != null) {
            int i = values.length - 1;
            while (i >= 0) {
                if (values[i] < v) {
                    return values[i];
                }
                --i;
            }
        }
        return Long.MIN_VALUE;
    }

    private static long findHigh(long[] values, long v) {
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                if (values[i] > v) {
                    return values[i];
                }
                ++i;
            }
        }
        return Long.MAX_VALUE;
    }

    public boolean equals1(IIntegralDomain element) {
        return this.type == element.getValueType() && this.lowValue == element.getLowValue() && this.highValue == element.getHighValue() && this.onesBitMask == element.getOnesBitMask() && this.zeroBitMask == element.getZeroBitMask() && this.outOfBounds == element.isOutOfBounds();
    }

    public int getValueType() {
        return this.type;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isEmpty() {
        return this.lowValue > this.highValue;
    }

    public boolean isBottom() {
        return this.isEmpty();
    }

    public boolean isTop() {
        return false;
    }

    public IIntegralDomain doMUL(IIntegralDomain domain) {
        long newZeroBitMask;
        if (domain.isConstant()) {
            long constVal = domain.getLowValue();
            if (constVal == 0L) {
                return domain;
            }
            if (constVal == 1L) {
                return this;
            }
        }
        if ((newZeroBitMask = this.makeMask(IntegralDomain.ffc(this.getZeroBitMask()) + IntegralDomain.ffc(domain.getZeroBitMask()))) == this.typeValueMask()) {
            return this.buildZeroConstant();
        }
        boolean oob = false;
        long newLowValue = this.minTypeValue();
        long newHighValue = this.maxTypeValue();
        if (this.getValueType() == 5) {
            long min2;
            long min1;
            long op1High = this.getHighValue();
            long op1Low = this.getLowValue();
            long op2High = domain.getHighValue();
            long op2Low = domain.getLowValue();
            if ((op1High ^ op1Low) >= 0L && (op2High ^ op2Low) >= 0L && !IntegralDomain.canMultiply(min1 = IntegralDomain.min(IntegralDomain.abs(op1Low), IntegralDomain.abs(op1High)), min2 = IntegralDomain.min(IntegralDomain.abs(op2Low), IntegralDomain.abs(op2High)))) {
                oob = true;
            }
            if (op1High >= op1Low && op2High >= op2Low) {
                long rezHigh;
                long rezLow;
                if (op1High < 0L && op2High < 0L) {
                    rezLow = op1High * op2High;
                    rezHigh = op1Low * op2Low;
                    if (rezHigh > 0L && rezHigh / op1Low == op2Low) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1High < 0L && op2Low < 0L && op2High >= 0L) {
                    rezLow = op1Low * op2High;
                    rezHigh = op1Low * op2Low;
                    if (rezHigh > 0L && rezLow / op1Low == op2High && rezHigh / op1Low == op2Low) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1High < 0L && op2Low >= 0L) {
                    rezLow = op1Low * op2High;
                    rezHigh = op1High * op2Low;
                    if (rezLow / op1Low == op2High && rezHigh / op1High == op2Low) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1Low < 0L && op1High >= 0L && op2High < 0L) {
                    rezLow = op1High * op2Low;
                    rezHigh = op1Low * op2Low;
                    if (rezHigh > 0L && rezLow / op2Low == op1High && rezHigh / op2Low == op1Low) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1Low < 0L && op1High >= 0L && op2Low < 0L && op2High >= 0L) {
                    long m1 = op1Low * op2High;
                    long m2 = op1High * op2Low;
                    if (m1 / op1Low == op2High && m2 / op2Low == op1High) {
                        rezLow = IntegralDomain.min(m1, m2);
                        long m01 = op1High * op2High;
                        long m02 = op1Low * op2Low;
                        if (m02 > 0L && (op1High == 0L || m01 / op1Low == op2High) && m02 / op2Low == op1Low) {
                            newLowValue = rezLow;
                            newHighValue = IntegralDomain.max(m01, m02);
                        }
                    }
                } else if (op1Low < 0L && op1High >= 0L && op2Low >= 0L) {
                    rezLow = op1Low * op2High;
                    rezHigh = op1High * op2High;
                    if (rezLow / op1Low == op2High && (op1High == 0L || rezHigh / op1High == op2Low)) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1Low >= 0L && op2High < 0L) {
                    rezLow = op1High * op2Low;
                    rezHigh = op1Low * op2High;
                    if (rezLow / op2Low == op1High && rezHigh / op2High == op1Low) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1Low >= 0L && op2Low < 0L && op2High >= 0L) {
                    rezLow = op1High * op2Low;
                    rezHigh = op1High * op2High;
                    if (rezLow / op2Low == op1High && (op1High == 0L || rezHigh / op1High == op2High)) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else {
                    rezLow = op1Low * op2Low;
                    rezHigh = op1High * op2High;
                    if (op1High == 0L || rezHigh / op1High == op2High) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                }
            }
        } else {
            int min2;
            int min1;
            int op1High = (int)this.getHighValue();
            int op1Low = (int)this.getLowValue();
            int op2High = (int)domain.getHighValue();
            int op2Low = (int)domain.getLowValue();
            if ((op1High ^ op1Low) >= 0 && (op2High ^ op2Low) >= 0 && (min1 = IntegralDomain.min(IntegralDomain.abs(op1Low), IntegralDomain.abs(op1High))) * (min2 = IntegralDomain.min(IntegralDomain.abs(op2Low), IntegralDomain.abs(op2High))) != 0 && min1 * min2 / min2 != min1) {
                oob = true;
            }
            if (op1High >= op1Low && op2High >= op2Low) {
                int rezHigh;
                int rezLow;
                if (op1High < 0 && op2High < 0) {
                    rezLow = op1High * op2High;
                    rezHigh = op1Low * op2Low;
                    if (rezHigh > 0 && rezHigh / op1Low == op2Low) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1High < 0 && op2Low < 0 && op2High >= 0) {
                    rezLow = op1Low * op2High;
                    rezHigh = op1Low * op2Low;
                    if (rezHigh > 0 && rezLow / op1Low == op2High && rezHigh / op1Low == op2Low) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1High < 0 && op2Low >= 0) {
                    rezLow = op1Low * op2High;
                    rezHigh = op1High * op2Low;
                    if (rezLow / op1Low == op2High && rezHigh / op1High == op2Low) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1Low < 0 && op1High >= 0 && op2High < 0) {
                    rezLow = op1High * op2Low;
                    rezHigh = op1Low * op2Low;
                    if (rezHigh > 0 && rezLow / op2Low == op1High && rezHigh / op2Low == op1Low) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1Low < 0 && op1High >= 0 && op2Low < 0 && op2High >= 0) {
                    int m1 = op1Low * op2High;
                    int m2 = op1High * op2Low;
                    if (m1 / op1Low == op2High && m2 / op2Low == op1High) {
                        rezLow = IntegralDomain.min(m1, m2);
                        int m01 = op1High * op2High;
                        int m02 = op1Low * op2Low;
                        if (m02 > 0 && (op1High == 0 || m01 / op1Low == op2High) && m02 / op2Low == op1Low) {
                            newLowValue = rezLow;
                            newHighValue = IntegralDomain.max(m01, m02);
                        }
                    }
                } else if (op1Low < 0 && op1High >= 0 && op2Low >= 0) {
                    rezLow = op1Low * op2High;
                    rezHigh = op1High * op2High;
                    if (rezLow / op1Low == op2High && (op1High == 0 || rezHigh / op1High == op2Low)) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1Low >= 0 && op2High < 0) {
                    rezLow = op1High * op2Low;
                    rezHigh = op1Low * op2High;
                    if (rezLow / op2Low == op1High && rezHigh / op2High == op1Low) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else if (op1Low >= 0 && op2Low < 0 && op2High >= 0) {
                    rezLow = op1High * op2Low;
                    rezHigh = op1High * op2High;
                    if (rezLow / op2Low == op1High && (op1High == 0 || rezHigh / op1High == op2High)) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                } else {
                    rezLow = op1Low * op2Low;
                    rezHigh = op1High * op2High;
                    if (op1High == 0 || rezHigh / op1High == op2High) {
                        newLowValue = rezLow;
                        newHighValue = rezHigh;
                    }
                }
            }
        }
        return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBitMask, 0L, oob);
    }

    public IIntegralDomain doDIV(IIntegralDomain domain) {
        long minAbsDivisor;
        long constVal;
        if (domain.isConstant() && (constVal = domain.getLowValue()) == 1L) {
            return this;
        }
        if (this.getHighValue() < this.getLowValue()) {
            return this;
        }
        if (domain.getHighValue() < domain.getLowValue()) {
            return domain;
        }
        long maxAbsDivident = IntegralDomain.max(IntegralDomain.abs(this.getLowValue()), IntegralDomain.abs(this.getHighValue()));
        if (maxAbsDivident < (minAbsDivisor = IntegralDomain.min(IntegralDomain.abs(domain.getLowValue()), IntegralDomain.abs(domain.getHighValue())))) {
            return this.buildZeroConstant();
        }
        long newZeroMask = this.makeMask(IntegralDomain.ffc(this.getZeroBitMask()) - IntegralDomain.ffc(domain.getZeroBitMask()));
        long newLowValue = this.minTypeValue();
        long newHighValue = this.maxTypeValue();
        long op2Low = domain.getLowValue();
        if (op2Low > 0L) {
            long op1High = this.getHighValue();
            long op1Low = this.getLowValue();
            long op2High = domain.getHighValue();
            if (op1High < 0L) {
                newLowValue = op1Low / op2Low;
                newHighValue = op1High / op2High;
            } else {
                newHighValue = op1High / op2Low;
                newLowValue = op1Low < 0L ? op1Low / op2Low : op1Low / op2High;
            }
        }
        return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroMask, 0L, false);
    }

    public IIntegralDomain doMOD(IIntegralDomain domain) {
        long newLowValue = this.minTypeValue();
        long newHighValue = this.maxTypeValue();
        if (domain.getLowValue() > 0L) {
            newLowValue = this.getLowValue() < 0L ? 1L - domain.getHighValue() : 0L;
            newHighValue = domain.getHighValue() - 1L;
        }
        return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, 0L, 0L, false);
    }

    public IIntegralDomain doADD(IIntegralDomain domain) {
        long newHighValue;
        long newLowValue;
        long constVal;
        if (domain.isConstant() && (constVal = domain.getLowValue()) == 0L) {
            return this;
        }
        boolean oob = false;
        if (this.getValueType() == 5) {
            long min2;
            long min1;
            long op1High = this.getHighValue();
            long op1Low = this.getLowValue();
            long op2High = domain.getHighValue();
            long op2Low = domain.getLowValue();
            if ((op1High ^ op2High) >= 0L && (op1Low ^ op2Low) >= 0L && (op1High ^ op1Low) >= 0L && ((min1 = IntegralDomain.min(IntegralDomain.abs(op1Low), IntegralDomain.abs(op1High))) + (min2 = IntegralDomain.min(IntegralDomain.abs(op2Low), IntegralDomain.abs(op2High))) < min1 || min1 + min2 < min2)) {
                oob = true;
            }
            if (!((op1High ^ op2High) >= 0L && (op1High + op2High ^ op1High) < 0L || (op1Low ^ op2Low) >= 0L && (op1Low + op2Low ^ op2Low) < 0L)) {
                newLowValue = op1Low + op2Low;
                newHighValue = op1High + op2High;
            } else {
                newLowValue = this.minTypeValue();
                newHighValue = this.maxTypeValue();
            }
        } else {
            int min2;
            int min1;
            int op1High = (int)this.getHighValue();
            int op1Low = (int)this.getLowValue();
            int op2High = (int)domain.getHighValue();
            int op2Low = (int)domain.getLowValue();
            if ((op1High ^ op2High) >= 0 && (op1Low ^ op2Low) >= 0 && (op1High ^ op1Low) >= 0 && ((min1 = IntegralDomain.min(IntegralDomain.abs(op1Low), IntegralDomain.abs(op1High))) + (min2 = IntegralDomain.min(IntegralDomain.abs(op2Low), IntegralDomain.abs(op2High))) < min1 || min1 + min2 < min2)) {
                oob = true;
            }
            if (!((op1High ^ op2High) >= 0 && (op1High + op2High ^ op1High) < 0 || (op1Low ^ op2Low) >= 0 && (op1Low + op2Low ^ op2Low) < 0)) {
                newLowValue = op1Low + op2Low;
                newHighValue = op1High + op2High;
            } else {
                newLowValue = this.minTypeValue();
                newHighValue = this.maxTypeValue();
            }
        }
        long newZeroBitMask = this.makeMask(IntegralDomain.max(IntegralDomain.lfc(this.getZeroBitMask()), IntegralDomain.lfc(domain.getZeroBitMask())) + 1, IntegralDomain.min(IntegralDomain.ffc(this.getZeroBitMask()), IntegralDomain.ffc(domain.getZeroBitMask())));
        return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBitMask, 0L, oob);
    }

    public IIntegralDomain doSUB(IIntegralDomain domain) {
        long newHighValue;
        long newLowValue;
        long constVal;
        if (domain.isConstant() && (constVal = domain.getLowValue()) == 0L) {
            return this;
        }
        boolean oob = false;
        if (this.getValueType() == 5) {
            long min2;
            long min1;
            long op1High = this.getHighValue();
            long op1Low = this.getLowValue();
            long op2High = domain.getHighValue();
            long op2Low = domain.getLowValue();
            if ((op1High ^ op2High) < 0L && (op1High ^ op1Low) > 0L && (op2High ^ op2Low) > 0L && ((min1 = IntegralDomain.min(IntegralDomain.abs(op1Low), IntegralDomain.abs(op1High))) + (min2 = IntegralDomain.min(IntegralDomain.abs(op2Low), IntegralDomain.abs(op2High))) < min1 || min1 + min2 < min2)) {
                oob = true;
            }
            if (!((op1High ^ op2Low) < 0L && (op1High - op2Low ^ op1High) < 0L || (op1Low ^ op2High) < 0L && (op1Low - op2High ^ op1Low) < 0L)) {
                newLowValue = op1Low - op2High;
                newHighValue = op1High - op2Low;
            } else {
                newLowValue = this.minTypeValue();
                newHighValue = this.maxTypeValue();
            }
        } else {
            int min2;
            int min1;
            int op1High = (int)this.getHighValue();
            int op1Low = (int)this.getLowValue();
            int op2High = (int)domain.getHighValue();
            int op2Low = (int)domain.getLowValue();
            if ((op1High ^ op2High) < 0 && (op1High ^ op1Low) > 0 && (op2High ^ op2Low) > 0 && ((min1 = IntegralDomain.min(IntegralDomain.abs(op1Low), IntegralDomain.abs(op1High))) + (min2 = IntegralDomain.min(IntegralDomain.abs(op2Low), IntegralDomain.abs(op2High))) < min1 || min1 + min2 < min2)) {
                oob = true;
            }
            if (!((op1High ^ op2Low) < 0 && (op1High - op2Low ^ op1High) < 0 || (op1Low ^ op2High) < 0 && (op1Low - op2High ^ op1Low) < 0)) {
                newLowValue = op1Low - op2High;
                newHighValue = op1High - op2Low;
            } else {
                newLowValue = this.minTypeValue();
                newHighValue = this.maxTypeValue();
            }
        }
        long newZeroBitMask = newLowValue >= 0L ? this.makeMask(IntegralDomain.max(IntegralDomain.lfc(this.getZeroBitMask()), IntegralDomain.lfc(domain.getZeroBitMask())) + 1, IntegralDomain.min(IntegralDomain.ffc(this.getZeroBitMask()), IntegralDomain.ffc(domain.getZeroBitMask()))) : 0L;
        return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBitMask, 0L, oob);
    }

    public IIntegralDomain doShiftLeft(IIntegralDomain domain) {
        if (domain.isConstant()) {
            long constVal = domain.getLowValue();
            if (constVal == 0L) {
                return this;
            }
            long newZeroBits = this.getZeroBitMask() << (int)constVal | (1L << (int)constVal) - 1L;
            if ((newZeroBits & this.typeValueMask()) == this.typeValueMask()) {
                return this.buildZeroConstant();
            }
            long newOnesBits = this.getOnesBitMask() << (int)constVal & this.typeValueMask();
            return IntegralDomain.build(this.getValueType(), this.minTypeValue(), this.maxTypeValue(), newZeroBits, newOnesBits, false);
        }
        return new IntegralDomain(this.getValueType());
    }

    public IIntegralDomain doShiftRight(IIntegralDomain domain) {
        if (domain.isConstant()) {
            long constVal = domain.getLowValue();
            if (constVal == 0L) {
                return this;
            }
            int c = (int)domain.getLowValue() % this.bitSize();
            if (c == 0) {
                return this;
            }
            long newZeroBitMask = ((this.getZeroBitMask() ^ 0xFFFFFFFFFFFFFFFFL) & this.typeValueMask()) >>> c ^ 0xFFFFFFFFFFFFFFFFL;
            long newOnesBitMask = this.getOnesBitMask() >>> c;
            long newLowValue = this.getLowValue() >> c;
            long newHighValue = this.getHighValue() >> c;
            return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBitMask, newOnesBitMask, false);
        }
        if (domain.getLowValue() >= 0L && domain.getHighValue() < (long)this.bitSize()) {
            long newZeroBitMask = -1L;
            newZeroBitMask = this.getLowValue() >= 0L ? (newZeroBitMask -= (1L << this.bitSize()) - 1L >>> (int)domain.getLowValue()) : 0L;
            long newHighValue = this.getHighValue() >= 0L ? this.getHighValue() >> (int)domain.getLowValue() : this.getHighValue() >> (int)domain.getHighValue();
            long newLowValue = this.getLowValue() >= 0L ? this.getLowValue() >> (int)domain.getHighValue() : this.getLowValue() >> (int)domain.getLowValue();
            return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBitMask, 0L, false);
        }
        return new IntegralDomain(this.getValueType());
    }

    public IIntegralDomain doUnsignedShiftRight(IIntegralDomain domain) {
        if (domain.isConstant()) {
            long newHighValue;
            long newLowValue;
            long constVal = domain.getLowValue();
            if (constVal == 0L) {
                return this;
            }
            int c = (int)(constVal % (long)this.bitSize());
            if (c == 0) {
                return this;
            }
            long newZeroBitMask = (this.getZeroBitMask() ^ 0xFFFFFFFFFFFFFFFFL) >>> c ^ 0xFFFFFFFFFFFFFFFFL;
            long newOnesBitMask = this.getOnesBitMask() >>> c;
            if (this.getLowValue() >= 0L || this.getHighValue() < 0L) {
                newLowValue = this.getLowValue() >>> c;
                newHighValue = this.getHighValue() >>> c;
            } else {
                newLowValue = 0L;
                newHighValue = IntegralDomain.max((this.getLowValue() & this.typeValueMask()) >>> c, this.getHighValue() >>> c);
            }
            return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBitMask, newOnesBitMask, false);
        }
        return new IntegralDomain(this.getValueType());
    }

    public IIntegralDomain doBAND(IIntegralDomain domain) {
        long constVal;
        if (domain.isConstant() && (constVal = domain.getLowValue()) == 0L) {
            return domain;
        }
        long newZeroBitMask = this.zeroBitMask | domain.getZeroBitMask();
        long newOnesBitMask = this.onesBitMask & domain.getOnesBitMask();
        long newLowValue = this.signBitSet(newZeroBitMask) ? 0L : this.minTypeValue();
        long newHighValue = (this.getHighValue() & domain.getHighValue()) < 0L ? 0L : this.maxTypeValue() & (newZeroBitMask ^ 0xFFFFFFFFFFFFFFFFL);
        return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBitMask, newOnesBitMask, false);
    }

    public IIntegralDomain doBOR(IIntegralDomain domain) {
        long constVal;
        if (domain.isConstant() && (constVal = domain.getLowValue()) == 0L) {
            return this;
        }
        long newZeroBitMask = this.zeroBitMask & domain.getZeroBitMask();
        long newOnesBitMask = this.onesBitMask | domain.getOnesBitMask();
        long newLowValue = this.signBitSet(newZeroBitMask) ? 0L : this.minTypeValue();
        long newHighValue = this.maxTypeValue() & (newZeroBitMask ^ 0xFFFFFFFFFFFFFFFFL);
        return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBitMask, newOnesBitMask, false);
    }

    public IIntegralDomain doBXOR(IIntegralDomain domain) {
        long newZeroBitMask = this.zeroBitMask & domain.getZeroBitMask() | this.onesBitMask & domain.getOnesBitMask();
        long newOnesBitMask = this.zeroBitMask & domain.getOnesBitMask() | this.onesBitMask & domain.getZeroBitMask();
        long newLowValue = this.signBitSet(newZeroBitMask) ? 0L : this.minTypeValue();
        long newHighValue = this.maxTypeValue() & (newZeroBitMask ^ 0xFFFFFFFFFFFFFFFFL);
        return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBitMask, newOnesBitMask, false);
    }

    public IBooleanDomain doLT(IIntegralDomain domain) {
        if (this.getHighValue() < domain.getLowValue()) {
            return BooleanConstant.forTrue();
        }
        if (this.getLowValue() >= domain.getHighValue()) {
            return BooleanConstant.forFalse();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doGT(IIntegralDomain domain) {
        if (this.getLowValue() > domain.getHighValue()) {
            return BooleanConstant.forTrue();
        }
        if (this.getHighValue() <= domain.getLowValue()) {
            return BooleanConstant.forFalse();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doLE(IIntegralDomain domain) {
        if (this.getHighValue() <= domain.getLowValue()) {
            return BooleanConstant.forTrue();
        }
        if (this.getLowValue() > domain.getHighValue()) {
            return BooleanConstant.forFalse();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doGE(IIntegralDomain domain) {
        if (this.getLowValue() >= domain.getHighValue()) {
            return BooleanConstant.forTrue();
        }
        if (this.getHighValue() < domain.getLowValue()) {
            return BooleanConstant.forFalse();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doEQ(IIntegralDomain domain) {
        if (this.getHighValue() < domain.getLowValue() || this.getLowValue() > domain.getHighValue() || (this.getOnesBitMask() & domain.getZeroBitMask() & this.typeValueMask()) != 0L || (this.getZeroBitMask() & domain.getOnesBitMask() & this.typeValueMask()) != 0L) {
            return BooleanConstant.forFalse();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doNE(IIntegralDomain domain) {
        if (this.getHighValue() < domain.getLowValue() || this.getLowValue() > domain.getHighValue() || (this.getOnesBitMask() & domain.getZeroBitMask() & this.typeValueMask()) != 0L || (this.getZeroBitMask() & domain.getOnesBitMask() & this.typeValueMask()) != 0L) {
            return BooleanConstant.forTrue();
        }
        return BooleanDomain.get();
    }

    public IIntegralDomain doNEG() {
        long newHighValue;
        long newLowValue;
        if (this.getLowValue() == this.minTypeValue()) {
            newLowValue = this.minTypeValue();
            newHighValue = this.maxTypeValue();
        } else {
            newLowValue = -this.getHighValue();
            newHighValue = -this.getLowValue();
        }
        long newZeroBits = this.makeMask(IntegralDomain.ffc(this.getZeroBitMask()) - 1);
        return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBits, 0L, false);
    }

    public IIntegralDomain doCOM() {
        return IntegralDomain.build(this.getValueType(), this.minTypeValue(), this.maxTypeValue(), this.getOnesBitMask(), this.getZeroBitMask(), false);
    }

    public IIntegralDomain doINC() {
        long newZeroBitMask;
        long newHighValue;
        long newLowValue;
        if (this.getHighValue() == this.maxTypeValue()) {
            newLowValue = this.minTypeValue();
            newHighValue = this.getHighValue();
            newZeroBitMask = 0L;
        } else {
            newLowValue = this.getLowValue() + 1L;
            newHighValue = this.getHighValue() + 1L;
            newZeroBitMask = this.makeMask(IntegralDomain.max(IntegralDomain.lfc(this.getZeroBitMask()), 1) + 1, IntegralDomain.min(IntegralDomain.ffc(this.getZeroBitMask()), 0));
        }
        return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBitMask, 0L, false);
    }

    public IIntegralDomain doDEC() {
        long newZeroBitMask;
        long newHighValue;
        long newLowValue;
        if (this.getLowValue() == this.minTypeValue()) {
            newLowValue = this.minTypeValue();
            newHighValue = this.getHighValue();
            newZeroBitMask = 0L;
        } else {
            newLowValue = this.getLowValue() - 1L;
            newHighValue = this.getHighValue() - 1L;
            newZeroBitMask = this.makeMask(IntegralDomain.max(IntegralDomain.lfc(this.getZeroBitMask()), 1) + 1, IntegralDomain.min(IntegralDomain.ffc(this.getZeroBitMask()), 0));
        }
        return IntegralDomain.build(this.getValueType(), newLowValue, newHighValue, newZeroBitMask, 0L, false);
    }

    public IntegralDomain(int type, long low, long high, long zero, long ones) {
        this.type = type;
        this.lowValue = low;
        this.highValue = high;
        this.zeroBitMask = zero;
        this.onesBitMask = ones;
    }

    public IntegralDomain(int type, long low, long high, long zero, long ones, boolean isOutOfBounds) {
        this.type = type;
        this.lowValue = low;
        this.highValue = high;
        this.zeroBitMask = zero;
        this.onesBitMask = ones;
        this.outOfBounds = isOutOfBounds;
    }

    public IntegralDomain(int type) {
        this.type = type;
        this.zeroBitMask = 0L;
        this.onesBitMask = 0L;
        switch (type) {
            case 1: {
                this.lowValue = -128L;
                this.highValue = 127L;
                break;
            }
            case 2: {
                this.lowValue = -32768L;
                this.highValue = 32767L;
                this.zeroBitMask = -65536L;
                break;
            }
            case 3: {
                this.lowValue = 0L;
                this.highValue = 65535L;
                break;
            }
            case 4: {
                this.lowValue = Integer.MIN_VALUE;
                this.highValue = Integer.MAX_VALUE;
                break;
            }
            case 5: {
                this.lowValue = Long.MIN_VALUE;
                this.highValue = Long.MAX_VALUE;
                break;
            }
        }
    }

    public static IIntegralDomain build(int type, long low, long high, long zero, long ones, boolean isOutOfBounds) {
        long mask;
        switch (type) {
            case 1: {
                if (low == high) {
                    return new ByteConstant((byte)low);
                }
                mask = 255L;
                if (low >= 0L) {
                    zero |= 0xFFFFFFFFFFFFFF80L;
                }
                if (((zero | ones) & mask) != mask) break;
                return new ByteConstant((byte)ones);
            }
            case 3: {
                if (low == high) {
                    return new CharConstant((char)low);
                }
                mask = 65535L;
                if ((((zero |= 0xFFFFFFFFFFFF0000L) | ones) & mask) != mask) break;
                return new CharConstant((char)ones);
            }
            case 2: {
                if (low == high) {
                    return new ShortConstant((short)low);
                }
                mask = 65535L;
                if (low >= 0L) {
                    zero |= 0xFFFFFFFFFFFF8000L;
                }
                if (((zero | ones) & mask) != mask) break;
                return new ShortConstant((short)ones);
            }
            case 4: {
                if (low == high) {
                    return new IntConstant((int)low);
                }
                mask = 0xFFFFFFFFL;
                if (low >= 0L) {
                    zero |= Integer.MIN_VALUE;
                }
                if (((zero | ones) & mask) != mask) break;
                return new IntConstant((int)ones);
            }
            case 5: {
                if (low == high) {
                    return new LongConstant(low);
                }
                if (low >= 0L) {
                    zero |= Long.MIN_VALUE;
                }
                if ((zero | ones) != -1L) break;
                return new LongConstant(ones);
            }
        }
        if (low >= 0L) {
            mask = Long.MIN_VALUE;
            long maskZ = 0L;
            while (mask != 0L && (mask & high) != 0L) {
                maskZ |= mask;
                mask >>>= 1;
            }
            zero |= maskZ;
        }
        return new IntegralDomain(type, low, high, zero, ones, isOutOfBounds);
    }

    public long minTypeValue() {
        switch (this.getValueType()) {
            case 1: {
                return -128L;
            }
            case 3: {
                return 0L;
            }
            case 2: {
                return -32768L;
            }
            case 4: {
                return Integer.MIN_VALUE;
            }
            case 5: {
                return Long.MIN_VALUE;
            }
        }
        return 0L;
    }

    public long maxTypeValue() {
        switch (this.getValueType()) {
            case 1: {
                return 127L;
            }
            case 3: {
                return 65535L;
            }
            case 2: {
                return 32767L;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
            case 5: {
                return Long.MAX_VALUE;
            }
        }
        return 0L;
    }

    public static IIntegralDomain intersect(IIntegralDomain domain, long lowValueArg, long highValueArg) {
        long newLowValue = IntegralDomain.max(lowValueArg, domain.getLowValue());
        long newHighValue = IntegralDomain.min(highValueArg, domain.getHighValue());
        if (newLowValue == domain.getLowValue() && newHighValue == domain.getHighValue()) {
            return domain;
        }
        long newZeroBitMask = 0L;
        long newOnesBitMask = 0L;
        return IntegralDomain.build(domain.getValueType(), newLowValue, newHighValue, newZeroBitMask, newOnesBitMask, false);
    }

    public static IIntegralDomain intersect(IIntegralDomain d1, IIntegralDomain d2) {
        boolean oob;
        long newLowValue = IntegralDomain.max(d1.getLowValue(), d2.getLowValue());
        long newHighValue = IntegralDomain.min(d1.getHighValue(), d2.getHighValue());
        long newZeroBitMask = d1.getZeroBitMask() | d2.getZeroBitMask();
        long newOnesBitMask = d1.getOnesBitMask() | d2.getOnesBitMask();
        boolean bl = oob = d1.isOutOfBounds() || d2.isOutOfBounds();
        if (d1.getValueType() == d2.getValueType()) {
            if (newLowValue == d1.getLowValue() && newHighValue == d1.getHighValue() && newZeroBitMask == d1.getZeroBitMask() && newOnesBitMask == d1.getOnesBitMask() && oob == d1.isOutOfBounds()) {
                return d1;
            }
            if (newLowValue == d2.getLowValue() && newHighValue == d2.getHighValue() && newZeroBitMask == d2.getZeroBitMask() && newOnesBitMask == d2.getOnesBitMask() && oob == d2.isOutOfBounds()) {
                return d2;
            }
        }
        return IntegralDomain.build(d1.getValueType(), newLowValue, newHighValue, newZeroBitMask, newOnesBitMask, oob);
    }

    private IIntegralDomain buildZeroConstant() {
        switch (this.getValueType()) {
            case 1: {
                return new ByteConstant(0);
            }
            case 3: {
                return new CharConstant(0);
            }
            case 2: {
                return new ShortConstant(0);
            }
            case 4: {
                return new IntConstant(0);
            }
            case 5: {
                return new LongConstant(0L);
            }
        }
        return null;
    }

    public void printBrief(PrintStream out) {
        out.print("Integral Domain: type =" + this.getValueType() + " [" + this.lowValue + ", " + this.highValue + "] Zero bits = " + Long.toHexString(this.zeroBitMask) + " One bits " + Long.toHexString(this.onesBitMask) + " outOfBounds = " + this.isOutOfBounds());
    }

    private static int ffc(long i1) {
        int idx = -1;
        long i = i1;
        if (i != -1L) {
            idx = 0;
            while ((i & 1L) != 0L) {
                i >>>= 1;
                ++idx;
            }
        }
        return idx;
    }

    /*
     * Unable to fully structure code
     */
    private static int lfc(long i1) {
        n = 0;
        i = i1 ^ -1L;
        if (i != 0L) ** GOTO lbl6
        return -1;
lbl-1000:
        // 1 sources

        {
            ++n;
lbl6:
            // 2 sources

            ** while ((i >>>= 1) != 0L)
        }
lbl7:
        // 1 sources

        return n;
    }

    private boolean signBitSet(long value) {
        return (1L << this.bitSize() - 1 & value) != 0L;
    }

    private long makeMask(int nBits) {
        if (nBits < 0) {
            return 0L;
        }
        if (nBits >= this.bitSize()) {
            return this.typeValueMask();
        }
        return (1L << nBits) - 1L;
    }

    private long makeMask(int first, int last) {
        long val = last < 0 ? 0L : (last >= this.bitSize() ? this.typeValueMask() : (1L << last) - 1L);
        if (first >= 0 && first + 1 < this.bitSize()) {
            val |= -1L - ((1L << first + 1) - 1L);
        }
        return val;
    }

    private static long max(long v1, long v2) {
        return v1 > v2 ? v1 : v2;
    }

    private static long min(long v1, long v2) {
        return v1 < v2 ? v1 : v2;
    }

    private static long abs(long v) {
        if (v == Long.MIN_VALUE) {
            return Long.MAX_VALUE;
        }
        return v < 0L ? -v : v;
    }

    private static int max(int v1, int v2) {
        return v1 > v2 ? v1 : v2;
    }

    private static int min(int v1, int v2) {
        return v1 < v2 ? v1 : v2;
    }

    private static int abs(int v) {
        if (v == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return v < 0 ? -v : v;
    }

    static boolean canMultiply(long a, long b) {
        if (a == 0L || b == 0L) {
            return true;
        }
        if (a == -1L) {
            return b != Long.MIN_VALUE;
        }
        if (b == -1L) {
            return a != Long.MIN_VALUE;
        }
        if (a > 0L) {
            if (b > 0L) {
                return a <= Long.MAX_VALUE / b;
            }
            return a <= Long.MIN_VALUE / b;
        }
        if (b > 0L) {
            return a >= Long.MIN_VALUE / b;
        }
        return a >= Long.MAX_VALUE / b;
    }

    public static IIntegralDomain forArray() {
        return arrayDomain;
    }

    public static IntegralDomain forByte() {
        return byteDefaultDomain;
    }

    public static IntegralDomain forChar() {
        return charDefaultDomain;
    }

    public static IntegralDomain forShort() {
        return shortDefaultDomain;
    }

    public static IntegralDomain forInt() {
        return intDefaultDomain;
    }

    public static IntegralDomain forLong() {
        return longDefaultDomain;
    }

    public static IntegralDomain forEmptyByte() {
        return byteEmptyDomain;
    }

    public static IntegralDomain forEmptyChar() {
        return charEmptyDomain;
    }

    public static IntegralDomain forEmptyShort() {
        return shortEmptyDomain;
    }

    public static IntegralDomain forEmptyInt() {
        return intEmptyDomain;
    }

    public static IntegralDomain forEmptyLong() {
        return longEmptyDomain;
    }

    public int bitSize() {
        switch (this.getValueType()) {
            case 1: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 2: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
        }
        return 0;
    }

    public boolean isOutOfBounds() {
        return this.outOfBounds;
    }

    public long typeValueMask() {
        switch (this.getValueType()) {
            case 1: {
                return 255L;
            }
            case 3: {
                return 65535L;
            }
            case 2: {
                return 65535L;
            }
            case 4: {
                return 0xFFFFFFFFL;
            }
            case 5: {
                return -1L;
            }
        }
        return 0L;
    }
}

