/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IIntConstant;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.internal.dataflow.values.AbstractIntegralConstant;
import java.io.PrintStream;

public class IntConstant
extends AbstractIntegralConstant
implements IIntConstant {
    private int value;

    public IntConstant(int value) {
        super(false);
        this.value = value;
    }

    public IntConstant(int value, boolean outOfBounds) {
        super(outOfBounds);
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public Object asObject() {
        return new Integer(this.value);
    }

    public long minTypeValue() {
        return Integer.MIN_VALUE;
    }

    public long maxTypeValue() {
        return Integer.MAX_VALUE;
    }

    public void printBrief(PrintStream out) {
        out.print("IntConst: " + this.value);
    }

    protected long getLongValue() {
        return this.value;
    }

    protected int getType() {
        return 4;
    }

    public int getValueType() {
        return 4;
    }

    protected IIntegralDomain buildSelf(long value, boolean outOfBounds) {
        return new IntConstant((int)value, outOfBounds);
    }
}

