/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.values.FloatConstant;
import com.togethersoft.sca.internal.dataflow.values.RealDomain;

public class FloatDomain
extends RealDomain {
    private float lowValue;
    private float highValue;
    private static final FloatDomain theDefault = new FloatDomain();

    protected FloatDomain(int mask, float lowValueVal, float highValueVal) {
        super(mask);
        this.lowValue = lowValueVal;
        this.highValue = highValueVal;
    }

    private FloatDomain() {
        super(7);
        this.lowValue = -3.4028235E38f;
        this.highValue = Float.MAX_VALUE;
    }

    public double getLowValue() {
        return this.lowValue;
    }

    public double getHighValue() {
        return this.highValue;
    }

    public boolean isTop() {
        return this.lowValue == -3.4028235E38f && this.highValue == Float.MAX_VALUE && this.stateMask == 7;
    }

    public boolean isEmpty() {
        return false;
    }

    public int getValueType() {
        return 6;
    }

    public double minTypeValue() {
        return -3.4028234663852886E38;
    }

    public double maxTypeValue() {
        return 3.4028234663852886E38;
    }

    public boolean equals1(IRealDomain domain) {
        return ((double)this.lowValue == domain.getLowValue() || Float.isNaN(this.lowValue) && Double.isNaN(domain.getLowValue())) && ((double)this.highValue == domain.getHighValue() || Float.isNaN(this.highValue) && Double.isNaN(domain.getHighValue())) && domain.getValueType() == this.getValueType() && this.stateMask == domain.getStateMask();
    }

    public IValueDomain combine(IRealDomain domain) {
        int newMask = this.stateMask | domain.getStateMask();
        float newLowValue = FloatDomain.min(this.lowValue, (float)domain.getLowValue());
        float newHighValue = FloatDomain.max(this.highValue, (float)domain.getHighValue());
        if (newMask == this.stateMask && newLowValue == this.lowValue && newHighValue == this.highValue) {
            return this;
        }
        if (newMask == domain.getStateMask() && (double)newLowValue == domain.getLowValue() && (double)newHighValue == domain.getHighValue()) {
            return domain;
        }
        return FloatDomain.build(newMask, newLowValue, newHighValue);
    }

    public IValueDomain intersect(IRealDomain domain) {
        int newMask = this.stateMask | domain.getStateMask();
        float newLowValue = FloatDomain.min(this.lowValue, (float)domain.getLowValue());
        float newHighValue = FloatDomain.max(this.highValue, (float)domain.getHighValue());
        if (newMask == this.stateMask && newLowValue == this.lowValue && newHighValue == this.highValue) {
            return this;
        }
        if (newMask == domain.getStateMask() && (double)newLowValue == domain.getLowValue() && (double)newHighValue == domain.getHighValue()) {
            return domain;
        }
        return FloatDomain.build(newMask, newLowValue, newHighValue);
    }

    public IValueDomain intersect(double theLowValue, double theHighValue) {
        int newMask = this.stateMask;
        float newLowValue = FloatDomain.min(this.lowValue, (float)theLowValue);
        float newHighValue = FloatDomain.max(this.highValue, (float)theHighValue);
        if (newLowValue == this.lowValue && newHighValue == this.highValue) {
            return this;
        }
        return FloatDomain.build(newMask, newLowValue, newHighValue);
    }

    public IRealDomain doMUL(IRealDomain domain) {
        float rezLow;
        if (domain.isConstant()) {
            if (domain.getLowValue() == 0.0 || domain.mayBeNaN() || domain.mayBePositiveInfinity() || domain.mayBeNegativeInfinity()) {
                return domain;
            }
            if (domain.getLowValue() == 1.0) {
                return this;
            }
        }
        boolean newMayBePositiveInfinity = this.mayBePositiveInfinity();
        boolean newMayBeNegativeInfinity = this.mayBeNegativeInfinity();
        float newLowValue = (float)this.minTypeValue();
        float newHighValue = (float)this.maxTypeValue();
        float op1High = (float)this.getHighValue();
        float op1Low = (float)this.getLowValue();
        float op2High = (float)domain.getHighValue();
        float op2Low = (float)domain.getLowValue();
        if (op1High < 0.0f && op2High < 0.0f) {
            rezLow = op1High * op2High;
            float rezHigh = op1Low * op2Low;
            if (rezHigh > 0.0f && rezHigh / op1Low == op2Low) {
                newLowValue = rezLow;
                newHighValue = rezHigh;
            } else if (rezHigh < 0.0f) {
                newMayBePositiveInfinity = true;
            } else {
                newMayBeNegativeInfinity = true;
            }
        } else if (op1High < 0.0f && op2Low < 0.0f && op2High >= 0.0f) {
            rezLow = op1Low * op2High;
            float rezHigh = op1Low * op2Low;
            if (rezLow / op1Low == op2High) {
                newLowValue = rezLow;
            } else {
                newMayBePositiveInfinity = true;
            }
            if (rezHigh > 0.0f && rezHigh / op1Low == op2Low) {
                newHighValue = rezHigh;
            } else {
                newMayBeNegativeInfinity = true;
            }
        } else if (op1High < 0.0f && op2Low >= 0.0f) {
            rezLow = op1Low * op2High;
            float rezHigh = op1High * op2Low;
            if (rezLow / op1Low == op2High) {
                newLowValue = rezLow;
            } else {
                newMayBeNegativeInfinity = true;
            }
            if (rezHigh / op1High == op2Low) {
                newHighValue = rezHigh;
            } else {
                newMayBePositiveInfinity = true;
            }
        } else if (op1Low < 0.0f && op1High >= 0.0f && op2High < 0.0f) {
            rezLow = op1High * op2Low;
            float rezHigh = op1Low * op2Low;
            if (rezLow / op2Low == op1High) {
                newLowValue = rezLow;
            } else {
                newMayBeNegativeInfinity = true;
            }
            if (rezHigh > 0.0f && rezHigh / op2Low == op1Low) {
                newHighValue = rezHigh;
            } else {
                newMayBePositiveInfinity = true;
            }
        } else if (op1Low < 0.0f && op1High >= 0.0f && op2Low < 0.0f && op2High >= 0.0f) {
            float m1 = op1Low * op2High;
            float m2 = op1High * op2Low;
            if (m1 / op1Low == op2High && m2 / op2Low == op1High) {
                rezLow = FloatDomain.min(m1, m2);
                float m01 = op1High * op2High;
                float m02 = op1Low * op2Low;
                if (m02 > 0.0f && (op1High == 0.0f || m01 / op1Low == op2High) && m02 / op2Low == op1Low) {
                    newLowValue = rezLow;
                    newHighValue = FloatDomain.max(m01, m02);
                } else {
                    if (m01 < 0.0f) {
                        newMayBePositiveInfinity = true;
                    }
                    if (m02 < 0.0f) {
                        newMayBeNegativeInfinity = true;
                    }
                }
            } else {
                newMayBeNegativeInfinity = true;
            }
        } else if (op1Low < 0.0f && op1High >= 0.0f && op2Low >= 0.0f) {
            rezLow = op1Low * op2High;
            float rezHigh = op1High * op2High;
            if (rezLow / op1Low == op2High) {
                newLowValue = rezLow;
            } else if (op2High > 0.0f && rezLow > 0.0f) {
                newMayBeNegativeInfinity = true;
            } else {
                newMayBePositiveInfinity = true;
            }
            if (op1High == 0.0f || rezHigh / op1High == op2Low) {
                newHighValue = rezHigh;
            } else if (op2High > 0.0f && rezHigh < 0.0f) {
                newMayBePositiveInfinity = true;
            } else {
                newMayBeNegativeInfinity = true;
            }
        } else if (op1Low >= 0.0f && op2High < 0.0f) {
            rezLow = op1High * op2Low;
            float rezHigh = op1Low * op2High;
            if (rezLow / op2Low == op1High) {
                newLowValue = rezLow;
            } else if (op1High > 0.0f) {
                if (op2Low > 0.0f) {
                    newMayBePositiveInfinity = true;
                } else {
                    newMayBeNegativeInfinity = true;
                }
            } else if (op2Low < 0.0f) {
                newMayBePositiveInfinity = true;
            } else {
                newMayBeNegativeInfinity = true;
            }
            if (rezHigh / op2High == op1Low) {
                newHighValue = rezHigh;
            } else {
                newMayBeNegativeInfinity = true;
            }
        } else if (op1Low >= 0.0f && op2Low < 0.0f && op2High >= 0.0f) {
            rezLow = op1High * op2Low;
            float rezHigh = op1High * op2High;
            if (rezLow / op2Low == op1High) {
                newLowValue = rezLow;
            } else if (op1High > 0.0f) {
                newMayBeNegativeInfinity = true;
            } else {
                newMayBePositiveInfinity = true;
            }
            if (op1High == 0.0f || rezHigh / op1High == op2High) {
                newHighValue = rezHigh;
            } else if (op1High < 0.0f) {
                newMayBeNegativeInfinity = true;
            } else {
                newMayBePositiveInfinity = true;
            }
        } else {
            rezLow = op1Low * op2Low;
            float rezHigh = op1High * op2High;
            if (op1High == 0.0f || rezHigh / op1High == op2High) {
                newLowValue = rezLow;
                newHighValue = rezHigh;
            } else if (op1High > 0.0f) {
                if (op2High > 0.0f) {
                    newMayBePositiveInfinity = true;
                } else {
                    newMayBeNegativeInfinity = true;
                }
            } else if (op2High < 0.0f) {
                newMayBePositiveInfinity = true;
            } else {
                newMayBeNegativeInfinity = true;
            }
        }
        int mask = this.stateMask & 4;
        if (newMayBePositiveInfinity) {
            mask |= 1;
        }
        if (newMayBeNegativeInfinity) {
            mask |= 2;
        }
        return FloatDomain.build(mask, newLowValue, newHighValue);
    }

    public IRealDomain doDIV(IRealDomain domain) {
        if (domain.isConstant()) {
            if (domain.getLowValue() == 1.0) {
                return this;
            }
            if (domain.mayBeNaN()) {
                return domain;
            }
            if (domain.mayBePositiveInfinity() || domain.mayBeNegativeInfinity()) {
                return this.buildConstant(false, 0.0f);
            }
        }
        boolean newMayBePositiveInfinity = this.mayBePositiveInfinity();
        boolean newMayBeNegativeInfinity = this.mayBeNegativeInfinity();
        double newLowValue = this.minTypeValue();
        double newHighValue = this.maxTypeValue();
        double op2Low = domain.getLowValue();
        if (op2Low > 0.0) {
            double op1High = this.getHighValue();
            double op1Low = this.getLowValue();
            double op2High = domain.getHighValue();
            if (op1High < 0.0) {
                newLowValue = op1Low / op2Low;
                newHighValue = op1High / op2High;
            } else {
                newLowValue = op1Low < 0.0 ? op1Low / op2Low : op1Low / op2High;
                newHighValue = op1High / op2Low;
            }
        }
        int mask = this.stateMask & 4;
        if (newMayBePositiveInfinity) {
            mask |= 1;
        }
        if (newMayBeNegativeInfinity) {
            mask |= 2;
        }
        return FloatDomain.build(mask, (float)newLowValue, (float)newHighValue);
    }

    public IRealDomain doMOD(IRealDomain domain) {
        double scale = 2.0E15;
        double newLowValue = this.minTypeValue();
        double newHighValue = this.maxTypeValue();
        double delta = domain.getHighValue() / 2.0E15;
        if (domain.getLowValue() > 0.0) {
            newLowValue = this.getLowValue() < 0.0 ? delta - domain.getHighValue() : 0.0;
            newHighValue = domain.getHighValue() - delta;
        }
        return FloatDomain.build(this.stateMask & 4, (float)newLowValue, (float)newHighValue);
    }

    public IRealDomain doADD(IRealDomain domain) {
        if (domain.isConstant()) {
            if (domain.getLowValue() == 0.0) {
                return this;
            }
            if (domain.mayBeNaN() || domain.mayBePositiveInfinity() || domain.mayBeNegativeInfinity()) {
                return domain;
            }
        }
        boolean newMayBePositiveInfinity = this.mayBePositiveInfinity();
        boolean newMayBeNegativeInfinity = this.mayBeNegativeInfinity();
        double newLowValue = this.minTypeValue();
        double newHighValue = this.maxTypeValue();
        int op1High = Float.floatToIntBits((float)this.getHighValue());
        int op1Low = Float.floatToIntBits((float)this.getLowValue());
        int op2High = Float.floatToIntBits((float)domain.getHighValue());
        int op2Low = Float.floatToIntBits((float)domain.getLowValue());
        if ((op1High ^ op2High) < 0 || (op1High + op2High ^ op1High) >= 0) {
            newHighValue = Float.intBitsToFloat(op1High) + Float.intBitsToFloat(op2High);
        } else if (op1High > 0) {
            newMayBePositiveInfinity = true;
        } else {
            newMayBeNegativeInfinity = true;
        }
        if ((op1Low ^ op2Low) < 0 || (op1Low + op2Low ^ op2Low) >= 0) {
            newLowValue = Float.intBitsToFloat(op1Low) + Float.intBitsToFloat(op2Low);
        } else if (op2Low > 0) {
            newMayBePositiveInfinity = true;
        } else {
            newMayBeNegativeInfinity = true;
        }
        int mask = this.stateMask & 4;
        if (newMayBePositiveInfinity) {
            mask |= 1;
        }
        if (newMayBeNegativeInfinity) {
            mask |= 2;
        }
        return FloatDomain.build(mask, (float)newLowValue, (float)newHighValue);
    }

    public IRealDomain doSUB(IRealDomain domain) {
        if (domain.isConstant()) {
            if (domain.getLowValue() == 0.0) {
                return this;
            }
            if (domain.mayBeNaN()) {
                return domain;
            }
            if (domain.mayBePositiveInfinity() || domain.mayBeNegativeInfinity()) {
                return this.buildConstant(domain.mayBePositiveInfinity(), (float)domain.getLowValue());
            }
        }
        boolean newMayBePositiveInfinity = this.mayBePositiveInfinity();
        boolean newMayBeNegativeInfinity = this.mayBeNegativeInfinity();
        double newLowValue = this.minTypeValue();
        double newHighValue = this.maxTypeValue();
        int op1High = Float.floatToIntBits((float)this.getHighValue());
        int op1Low = Float.floatToIntBits((float)this.getLowValue());
        int op2High = Float.floatToIntBits((float)domain.getHighValue());
        int op2Low = Float.floatToIntBits((float)domain.getLowValue());
        if ((op1High ^ op2Low) >= 0 || (op1High - op2Low ^ op1High) >= 0) {
            newHighValue = Float.intBitsToFloat(op1High) - Float.intBitsToFloat(op2Low);
        } else if (op1High > 0) {
            newMayBePositiveInfinity = true;
        } else {
            newMayBeNegativeInfinity = true;
        }
        if ((op1Low ^ op2High) >= 0 || (op1Low - op2High ^ op1Low) >= 0) {
            newLowValue = Float.intBitsToFloat(op1Low) - Float.intBitsToFloat(op2High);
        } else if (op1Low > 0) {
            newMayBePositiveInfinity = true;
        } else {
            newMayBeNegativeInfinity = true;
        }
        int mask = this.stateMask & 4;
        if (newMayBePositiveInfinity) {
            mask |= 1;
        }
        if (newMayBeNegativeInfinity) {
            mask |= 2;
        }
        return FloatDomain.build(mask, (float)newLowValue, (float)newHighValue);
    }

    public IRealDomain doNEG() {
        int newMask = this.stateMask & 4;
        if ((this.stateMask & 2) != 0) {
            newMask |= 1;
        }
        if ((this.stateMask & 1) != 0) {
            newMask |= 2;
        }
        return FloatDomain.build(newMask, -this.highValue, -this.lowValue);
    }

    public IRealDomain doINC() {
        float newLowValue = this.lowValue;
        float newHighValue = this.highValue;
        int newMask = this.stateMask;
        if ((double)newLowValue != this.maxTypeValue()) {
            newLowValue += 1.0f;
        }
        if ((double)newHighValue != this.maxTypeValue()) {
            newHighValue += 1.0f;
        }
        return FloatDomain.build(newMask, newLowValue, newHighValue);
    }

    public IRealDomain doDEC() {
        float newLowValue = this.lowValue;
        float newHighValue = this.highValue;
        int newMask = this.stateMask;
        if ((double)newLowValue != this.minTypeValue()) {
            newLowValue -= 1.0f;
        }
        if ((double)newHighValue != this.minTypeValue()) {
            newHighValue -= 1.0f;
        }
        return FloatDomain.build(newMask, newLowValue, newHighValue);
    }

    public static FloatDomain getDefault() {
        return theDefault;
    }

    public static IRealDomain build(int mask, float low, float high) {
        if (low == high) {
            return new FloatConstant(low);
        }
        return new FloatDomain(mask, low, high);
    }

    private IRealDomain buildConstant(boolean sign, float value) {
        return sign ? new FloatConstant(-value) : new FloatConstant(value);
    }

    private static float min(float v1, float v2) {
        return v1 < v2 ? v1 : v2;
    }

    private static float max(float v1, float v2) {
        return v1 > v2 ? v1 : v2;
    }
}

