/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.IFloatConstant;
import com.togethersoft.sca.dataflow.values.ILatticeElement;
import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import com.togethersoft.sca.internal.dataflow.values.BooleanDomain;
import com.togethersoft.sca.internal.dataflow.values.ConstantVal;
import com.togethersoft.sca.internal.dataflow.values.FloatDomain;
import java.io.PrintStream;

public class FloatConstant
extends ConstantVal
implements IFloatConstant {
    private float value;

    public int getValueKind() {
        return 2;
    }

    public boolean isConstant() {
        return true;
    }

    public float getValue() {
        return this.value;
    }

    public double getLowValue() {
        return this.value;
    }

    public Object asObject() {
        return new Float(this.value);
    }

    public boolean mayBePositiveInfinity() {
        return this.value == Float.POSITIVE_INFINITY;
    }

    public boolean mayBeNegativeInfinity() {
        return this.value == Float.NEGATIVE_INFINITY;
    }

    public boolean mayBeNaN() {
        return new Float(this.value).compareTo(new Float(Float.NaN)) == 0;
    }

    public double minTypeValue() {
        return -3.4028234663852886E38;
    }

    public double maxTypeValue() {
        return 3.4028234663852886E38;
    }

    public double getHighValue() {
        return this.value;
    }

    public int getStateMask() {
        return 0;
    }

    public int getValueType() {
        return 6;
    }

    public boolean isEmpty() {
        return false;
    }

    public IValueDomain join(IValueDomain element) {
        if (element.getValueType() == 0) {
            return element;
        }
        if (element.isEmpty()) {
            return this;
        }
        IRealDomain domain = (IRealDomain)element;
        if (!domain.isConstant()) {
            return domain.join(this);
        }
        if ((double)this.value == domain.getLowValue()) {
            return this;
        }
        if ((double)this.value <= domain.getLowValue()) {
            return FloatDomain.build(this.getStateMask(), this.value, (float)domain.getLowValue());
        }
        return FloatDomain.build(this.getStateMask(), (float)domain.getLowValue(), this.value);
    }

    public IValueDomain meet(IValueDomain element) {
        if (this.equals(element)) {
            return this;
        }
        return FloatDomain.getDefault();
    }

    public boolean equals(IValueDomain element) {
        if (this == element) {
            return true;
        }
        IRealDomain domain = (IRealDomain)element;
        return domain.getValueType() == 6 && domain.isConstant() && (float)domain.getLowValue() == this.value;
    }

    public boolean equals(ILatticeElement element) {
        if (this == element) {
            return true;
        }
        IRealDomain domain = (IRealDomain)element;
        return domain.getValueType() == 6 && domain.isConstant() && (float)domain.getLowValue() == this.value;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public ILatticeElement join(ILatticeElement element) {
        return this.join((IValueDomain)element);
    }

    public ILatticeElement meet(ILatticeElement element) {
        return this.meet((IValueDomain)element);
    }

    public IRealDomain doMUL(IRealDomain domain) {
        if (domain.isConstant()) {
            return new FloatConstant((float)((double)this.value * domain.getLowValue()));
        }
        return domain.doMUL(this);
    }

    public IRealDomain doDIV(IRealDomain domain) {
        if (domain.isConstant()) {
            return new FloatConstant((float)((double)this.value / domain.getLowValue()));
        }
        return FloatDomain.getDefault();
    }

    public IRealDomain doMOD(IRealDomain domain) {
        if (domain.isConstant()) {
            return new FloatConstant((float)((double)this.value % domain.getLowValue()));
        }
        return FloatDomain.getDefault();
    }

    public IRealDomain doADD(IRealDomain domain) {
        if (domain.isConstant()) {
            return new FloatConstant((float)((double)this.value + domain.getLowValue()));
        }
        return domain.doADD(this);
    }

    public IRealDomain doSUB(IRealDomain domain) {
        if (domain.isConstant()) {
            return new FloatConstant((float)((double)this.value - domain.getLowValue()));
        }
        return FloatDomain.getDefault();
    }

    public IBooleanDomain doLT(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make((double)this.value < domain.getLowValue());
        }
        return domain.doGE(this);
    }

    public IBooleanDomain doGT(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make((double)this.value > domain.getLowValue());
        }
        return domain.doLE(this);
    }

    public IBooleanDomain doLE(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make((double)this.value <= domain.getLowValue());
        }
        return domain.doGT(this);
    }

    public IBooleanDomain doGE(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make((double)this.value >= domain.getLowValue());
        }
        return domain.doLT(this);
    }

    public IBooleanDomain doEQ(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make((double)this.value == domain.getLowValue());
        }
        if ((double)this.value < domain.getLowValue() || (double)this.value > domain.getHighValue()) {
            return BooleanConstant.forFalse();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doNE(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make((double)this.value != domain.getLowValue());
        }
        if ((double)this.value < domain.getLowValue() || (double)this.value > domain.getHighValue()) {
            return BooleanConstant.forTrue();
        }
        return BooleanDomain.get();
    }

    public IRealDomain doNEG() {
        if ((double)this.value == 0.0) {
            return this;
        }
        return new FloatConstant(-this.value);
    }

    public IValueDomain intersect(double theLowValue, double theHighValue) {
        if (theLowValue == (double)this.value && theHighValue == (double)this.value) {
            return this;
        }
        return FloatDomain.build(0, theLowValue < (double)this.value ? (float)theLowValue : this.value, theHighValue > (double)this.value ? (float)theHighValue : this.value);
    }

    public IRealDomain doINC() {
        return new FloatConstant(this.value + 1.0f);
    }

    public IRealDomain doDEC() {
        return new FloatConstant(this.value + 1.0f);
    }

    public FloatConstant(float valInit) {
        this.value = valInit;
    }

    public void printBrief(PrintStream out) {
        out.print("FloatConst: " + this.value);
    }
}

