/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.values.DoubleConstant;
import com.togethersoft.sca.internal.dataflow.values.RealDomain;

public class DoubleDomain
extends RealDomain {
    private double lowValue;
    private double highValue;
    private static DoubleDomain theDefault = new DoubleDomain();

    protected DoubleDomain(int mask, double lowValueVal, double highValueVal) {
        super(mask);
        this.lowValue = lowValueVal;
        this.highValue = highValueVal;
    }

    private DoubleDomain() {
        super(7);
        this.lowValue = -1.7976931348623157E308;
        this.highValue = Double.MAX_VALUE;
    }

    public double getLowValue() {
        return this.lowValue;
    }

    public double getHighValue() {
        return this.highValue;
    }

    public boolean isTop() {
        return this.lowValue == -1.7976931348623157E308 && this.highValue == Double.MAX_VALUE && this.stateMask == 7;
    }

    public int getValueType() {
        return 7;
    }

    public double minTypeValue() {
        return -1.7976931348623157E308;
    }

    public double maxTypeValue() {
        return Double.MAX_VALUE;
    }

    public boolean equals1(IRealDomain domain) {
        return (this.lowValue == domain.getLowValue() || Double.isNaN(this.lowValue) && Double.isNaN(domain.getLowValue())) && (this.highValue == domain.getHighValue() || Double.isNaN(this.highValue) && Double.isNaN(domain.getHighValue())) && domain.getValueType() == this.getValueType() && this.stateMask == domain.getStateMask();
    }

    public IValueDomain combine(IRealDomain domain) {
        int newMask = this.stateMask | domain.getStateMask();
        double newLowValue = DoubleDomain.min(this.lowValue, domain.getLowValue());
        double newHighValue = DoubleDomain.max(this.highValue, domain.getHighValue());
        if (newMask == this.stateMask && newLowValue == this.lowValue && newHighValue == this.highValue) {
            return this;
        }
        if (newMask == domain.getStateMask() && newLowValue == domain.getLowValue() && newHighValue == domain.getHighValue()) {
            return domain;
        }
        return DoubleDomain.build(newMask, newLowValue, newHighValue);
    }

    public IValueDomain intersect(IRealDomain domain) {
        int newMask = this.stateMask | domain.getStateMask();
        double newLowValue = DoubleDomain.min(this.lowValue, domain.getLowValue());
        double newHighValue = DoubleDomain.max(this.highValue, domain.getHighValue());
        if (newMask == this.stateMask && newLowValue == this.lowValue && newHighValue == this.highValue) {
            return this;
        }
        if (newMask == domain.getStateMask() && newLowValue == domain.getLowValue() && newHighValue == domain.getHighValue()) {
            return domain;
        }
        return DoubleDomain.build(newMask, newLowValue, newHighValue);
    }

    public IValueDomain intersect(double theLowValue, double theHighValue) {
        int newMask = this.stateMask;
        double newLowValue = DoubleDomain.min(this.lowValue, theLowValue);
        double newHighValue = DoubleDomain.max(this.highValue, theHighValue);
        if (newLowValue == this.lowValue && newHighValue == this.highValue) {
            return this;
        }
        return DoubleDomain.build(newMask, newLowValue, newHighValue);
    }

    public IRealDomain doMUL(IRealDomain domain) {
        double rezHigh;
        if (domain.isConstant()) {
            if (domain.getLowValue() == 0.0 || domain.mayBeNaN() || domain.mayBePositiveInfinity() || domain.mayBeNegativeInfinity()) {
                return domain;
            }
            if (domain.getLowValue() == 1.0) {
                return this;
            }
        }
        boolean newMayBePositiveInfinity = this.mayBePositiveInfinity();
        boolean newMayBeNegativeInfinity = this.mayBeNegativeInfinity();
        double newLowValue = this.minTypeValue();
        double newHighValue = this.maxTypeValue();
        double op1High = this.getHighValue();
        double op1Low = this.getLowValue();
        double op2High = domain.getHighValue();
        double op2Low = domain.getLowValue();
        if (op1High < 0.0 && op2High < 0.0) {
            double rezLow = op1High * op2High;
            rezHigh = op1Low * op2Low;
            if (rezHigh > 0.0 && rezHigh / op1Low == op2Low) {
                newLowValue = rezLow;
                newHighValue = rezHigh;
            } else if (rezHigh < 0.0) {
                newMayBePositiveInfinity = true;
            } else {
                newMayBeNegativeInfinity = true;
            }
        } else if (op1High < 0.0 && op2Low < 0.0 && op2High >= 0.0) {
            double rezLow = op1Low * op2High;
            rezHigh = op1Low * op2Low;
            if (rezLow / op1Low == op2High) {
                newLowValue = rezLow;
            } else {
                newMayBePositiveInfinity = true;
            }
            if (rezHigh > 0.0 && rezHigh / op1Low == op2Low) {
                newHighValue = rezHigh;
            } else {
                newMayBeNegativeInfinity = true;
            }
        } else if (op1High < 0.0 && op2Low >= 0.0) {
            double rezLow = op1Low * op2High;
            rezHigh = op1High * op2Low;
            if (rezLow / op1Low == op2High) {
                newLowValue = rezLow;
            } else {
                newMayBeNegativeInfinity = true;
            }
            if (rezHigh / op1High == op2Low) {
                newHighValue = rezHigh;
            } else {
                newMayBePositiveInfinity = true;
            }
        } else if (op1Low < 0.0 && op1High >= 0.0 && op2High < 0.0) {
            double rezLow = op1High * op2Low;
            rezHigh = op1Low * op2Low;
            if (rezLow / op2Low == op1High) {
                newLowValue = rezLow;
            } else {
                newMayBeNegativeInfinity = true;
            }
            if (rezHigh > 0.0 && rezHigh / op2Low == op1Low) {
                newHighValue = rezHigh;
            } else {
                newMayBePositiveInfinity = true;
            }
        } else if (op1Low < 0.0 && op1High >= 0.0 && op2Low < 0.0 && op2High >= 0.0) {
            double m1 = op1Low * op2High;
            double m2 = op1High * op2Low;
            if (m1 / op1Low == op2High && m2 / op2Low == op1High) {
                double rezLow = DoubleDomain.min(m1, m2);
                double m01 = op1High * op2High;
                double m02 = op1Low * op2Low;
                if (m02 > 0.0 && (op1High == 0.0 || m01 / op1Low == op2High) && m02 / op2Low == op1Low) {
                    newLowValue = rezLow;
                    newHighValue = DoubleDomain.max(m01, m02);
                } else {
                    if (m01 < 0.0) {
                        newMayBePositiveInfinity = true;
                    }
                    if (m02 < 0.0) {
                        newMayBeNegativeInfinity = true;
                    }
                }
            } else {
                newMayBeNegativeInfinity = true;
            }
        } else if (op1Low < 0.0 && op1High >= 0.0 && op2Low >= 0.0) {
            double rezLow = op1Low * op2High;
            rezHigh = op1High * op2High;
            if (rezLow / op1Low == op2High) {
                newLowValue = rezLow;
            } else if (op2High > 0.0 && rezLow > 0.0) {
                newMayBeNegativeInfinity = true;
            } else {
                newMayBePositiveInfinity = true;
            }
            if (op1High == 0.0 || rezHigh / op1High == op2Low) {
                newHighValue = rezHigh;
            } else if (op2High > 0.0 && rezHigh < 0.0) {
                newMayBePositiveInfinity = true;
            } else {
                newMayBeNegativeInfinity = true;
            }
        } else if (op1Low >= 0.0 && op2High < 0.0) {
            double rezLow = op1High * op2Low;
            rezHigh = op1Low * op2High;
            if (rezLow / op2Low == op1High) {
                newLowValue = rezLow;
            } else if (op1High > 0.0) {
                if (op2Low > 0.0) {
                    newMayBePositiveInfinity = true;
                } else {
                    newMayBeNegativeInfinity = true;
                }
            } else if (op2Low < 0.0) {
                newMayBePositiveInfinity = true;
            } else {
                newMayBeNegativeInfinity = true;
            }
            if (rezHigh / op2High == op1Low) {
                newHighValue = rezHigh;
            } else {
                newMayBeNegativeInfinity = true;
            }
        } else if (op1Low >= 0.0 && op2Low < 0.0 && op2High >= 0.0) {
            double rezLow = op1High * op2Low;
            rezHigh = op1High * op2High;
            if (rezLow / op2Low == op1High) {
                newLowValue = rezLow;
            } else if (op1High > 0.0) {
                newMayBeNegativeInfinity = true;
            } else {
                newMayBePositiveInfinity = true;
            }
            if (op1High == 0.0 || rezHigh / op1High == op2High) {
                newHighValue = rezHigh;
            } else if (op1High < 0.0) {
                newMayBeNegativeInfinity = true;
            } else {
                newMayBePositiveInfinity = true;
            }
        } else {
            double rezLow = op1Low * op2Low;
            rezHigh = op1High * op2High;
            if (op1High == 0.0 || rezHigh / op1High == op2High) {
                newLowValue = rezLow;
                newHighValue = rezHigh;
            } else if (op1High > 0.0) {
                if (op2High > 0.0) {
                    newMayBePositiveInfinity = true;
                } else {
                    newMayBeNegativeInfinity = true;
                }
            } else if (op2High < 0.0) {
                newMayBePositiveInfinity = true;
            } else {
                newMayBeNegativeInfinity = true;
            }
        }
        int mask = this.stateMask & 4;
        if (newMayBePositiveInfinity) {
            mask |= 1;
        }
        if (newMayBeNegativeInfinity) {
            mask |= 2;
        }
        return DoubleDomain.build(mask, newLowValue, newHighValue);
    }

    public IRealDomain doDIV(IRealDomain domain) {
        if (domain.isConstant()) {
            if (domain.getLowValue() == 1.0) {
                return this;
            }
            if (domain.mayBeNaN()) {
                return domain;
            }
            if (domain.mayBePositiveInfinity() || domain.mayBeNegativeInfinity()) {
                return this.buildConstant(false, 0.0);
            }
        }
        boolean newMayBePositiveInfinity = this.mayBePositiveInfinity();
        boolean newMayBeNegativeInfinity = this.mayBeNegativeInfinity();
        double newLowValue = this.minTypeValue();
        double newHighValue = this.maxTypeValue();
        double op2Low = domain.getLowValue();
        if (op2Low > 0.0) {
            double op1High = this.getHighValue();
            double op1Low = this.getLowValue();
            double op2High = domain.getHighValue();
            if (op1High < 0.0) {
                newLowValue = op1Low / op2Low;
                newHighValue = op1High / op2High;
            } else {
                newLowValue = op1Low < 0.0 ? op1Low / op2Low : op1Low / op2High;
                newHighValue = op1High / op2Low;
            }
        }
        int mask = this.stateMask & 4;
        if (newMayBePositiveInfinity) {
            mask |= 1;
        }
        if (newMayBeNegativeInfinity) {
            mask |= 2;
        }
        return DoubleDomain.build(mask, newLowValue, newHighValue);
    }

    public IRealDomain doMOD(IRealDomain domain) {
        double scale = 2.0E15;
        double newLowValue = this.minTypeValue();
        double newHighValue = this.maxTypeValue();
        double delta = domain.getHighValue() / 2.0E15;
        if (domain.getLowValue() > 0.0) {
            newLowValue = this.getLowValue() < 0.0 ? delta - domain.getHighValue() : 0.0;
            newHighValue = domain.getHighValue() - delta;
        }
        return DoubleDomain.build(this.stateMask & 4, newLowValue, newHighValue);
    }

    public IRealDomain doADD(IRealDomain domain) {
        if (domain.isConstant()) {
            if (domain.getLowValue() == 0.0) {
                return this;
            }
            if (domain.mayBeNaN() || domain.mayBePositiveInfinity() || domain.mayBeNegativeInfinity()) {
                return domain;
            }
        }
        boolean newMayBePositiveInfinity = this.mayBePositiveInfinity();
        boolean newMayBeNegativeInfinity = this.mayBeNegativeInfinity();
        double newLowValue = this.minTypeValue();
        double newHighValue = this.maxTypeValue();
        long op1High = Double.doubleToLongBits(this.getHighValue());
        long op1Low = Double.doubleToLongBits(this.getLowValue());
        long op2High = Double.doubleToLongBits(domain.getHighValue());
        long op2Low = Double.doubleToLongBits(domain.getLowValue());
        if ((op1High ^ op2High) < 0L || (op1High + op2High ^ op1High) >= 0L) {
            newHighValue = Double.longBitsToDouble(op1High) + Double.longBitsToDouble(op2High);
        } else if (op1High > 0L) {
            newMayBePositiveInfinity = true;
        } else {
            newMayBeNegativeInfinity = true;
        }
        if ((op1Low ^ op2Low) < 0L || (op1Low + op2Low ^ op2Low) >= 0L) {
            newLowValue = Double.longBitsToDouble(op1Low) + Double.longBitsToDouble(op2Low);
        } else if (op2Low > 0L) {
            newMayBePositiveInfinity = true;
        } else {
            newMayBeNegativeInfinity = true;
        }
        int mask = this.stateMask & 4;
        if (newMayBePositiveInfinity) {
            mask |= 1;
        }
        if (newMayBeNegativeInfinity) {
            mask |= 2;
        }
        return DoubleDomain.build(mask, newLowValue, newHighValue);
    }

    public IRealDomain doSUB(IRealDomain domain) {
        if (domain.isConstant()) {
            if (domain.getLowValue() == 0.0) {
                return this;
            }
            if (domain.mayBeNaN()) {
                return domain;
            }
            if (domain.mayBePositiveInfinity() || domain.mayBeNegativeInfinity()) {
                return this.buildConstant(domain.mayBePositiveInfinity(), domain.getLowValue());
            }
        }
        boolean newMayBePositiveInfinity = this.mayBePositiveInfinity();
        boolean newMayBeNegativeInfinity = this.mayBeNegativeInfinity();
        double newLowValue = this.minTypeValue();
        double newHighValue = this.maxTypeValue();
        long op1High = Double.doubleToLongBits(this.getHighValue());
        long op1Low = Double.doubleToLongBits(this.getLowValue());
        long op2High = Double.doubleToLongBits(domain.getHighValue());
        long op2Low = Double.doubleToLongBits(domain.getLowValue());
        if ((op1High ^ op2Low) >= 0L || (op1High - op2Low ^ op1High) >= 0L) {
            newHighValue = Double.longBitsToDouble(op1High) - Double.longBitsToDouble(op2Low);
        } else if (op1High > 0L) {
            newMayBePositiveInfinity = true;
        } else {
            newMayBeNegativeInfinity = true;
        }
        if ((op1Low ^ op2High) >= 0L || (op1Low - op2High ^ op1Low) >= 0L) {
            newLowValue = Double.longBitsToDouble(op1Low) - Double.longBitsToDouble(op2High);
        } else if (op1Low > 0L) {
            newMayBePositiveInfinity = true;
        } else {
            newMayBeNegativeInfinity = true;
        }
        int mask = this.stateMask & 4;
        if (newMayBePositiveInfinity) {
            mask |= 1;
        }
        if (newMayBeNegativeInfinity) {
            mask |= 2;
        }
        return DoubleDomain.build(mask, newLowValue, newHighValue);
    }

    public IRealDomain doNEG() {
        int newMask = this.stateMask & 4;
        if ((this.stateMask & 2) != 0) {
            newMask |= 1;
        }
        if ((this.stateMask & 1) != 0) {
            newMask |= 2;
        }
        return DoubleDomain.build(newMask, -this.highValue, -this.lowValue);
    }

    public IRealDomain doINC() {
        double newLowValue = this.lowValue;
        double newHighValue = this.highValue;
        int newMask = this.stateMask;
        if (newLowValue != this.maxTypeValue()) {
            newLowValue += 1.0;
        }
        if (newHighValue != this.maxTypeValue()) {
            newHighValue += 1.0;
        }
        return DoubleDomain.build(newMask, newLowValue, newHighValue);
    }

    public IRealDomain doDEC() {
        double newLowValue = this.lowValue;
        double newHighValue = this.highValue;
        int newMask = this.stateMask;
        if (newLowValue != this.minTypeValue()) {
            newLowValue -= 1.0;
        }
        if (newHighValue != this.minTypeValue()) {
            newHighValue -= 1.0;
        }
        return DoubleDomain.build(newMask, newLowValue, newHighValue);
    }

    public static DoubleDomain getDefault() {
        return theDefault;
    }

    public static IRealDomain build(int mask, double low, double high) {
        if (low == high) {
            return new DoubleConstant(low);
        }
        return new DoubleDomain(mask, low, high);
    }

    private IRealDomain buildConstant(boolean sign, double value) {
        return sign ? new DoubleConstant(-value) : new DoubleConstant(value);
    }

    private static double min(double v1, double v2) {
        return v1 < v2 ? v1 : v2;
    }

    private static double max(double v1, double v2) {
        return v1 > v2 ? v1 : v2;
    }
}

