/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.IDoubleConstant;
import com.togethersoft.sca.dataflow.values.ILatticeElement;
import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import com.togethersoft.sca.internal.dataflow.values.BooleanDomain;
import com.togethersoft.sca.internal.dataflow.values.ConstantVal;
import com.togethersoft.sca.internal.dataflow.values.DoubleDomain;
import java.io.PrintStream;

public class DoubleConstant
extends ConstantVal
implements IDoubleConstant {
    private double value;

    public int getValueKind() {
        return 2;
    }

    public boolean isConstant() {
        return true;
    }

    public double getValue() {
        return this.value;
    }

    public Object asObject() {
        return new Double(this.value);
    }

    public boolean mayBePositiveInfinity() {
        return this.value == Double.POSITIVE_INFINITY;
    }

    public boolean mayBeNegativeInfinity() {
        return this.value == Double.NEGATIVE_INFINITY;
    }

    public boolean mayBeNaN() {
        return new Double(this.value).compareTo(new Double(Double.NaN)) == 0;
    }

    public double minTypeValue() {
        return -1.7976931348623157E308;
    }

    public double maxTypeValue() {
        return Double.MAX_VALUE;
    }

    public double getHighValue() {
        return this.value;
    }

    public double getLowValue() {
        return this.value;
    }

    public int getStateMask() {
        return 0;
    }

    public int getValueType() {
        return 7;
    }

    public boolean isEmpty() {
        return false;
    }

    public IValueDomain join(IValueDomain element) {
        if (element.getValueType() == 0) {
            return element;
        }
        if (element.isEmpty()) {
            return this;
        }
        IRealDomain domain = (IRealDomain)element;
        if (!domain.isConstant()) {
            return domain.join(this);
        }
        if (this.value == domain.getLowValue()) {
            return this;
        }
        if (this.value <= domain.getLowValue()) {
            return DoubleDomain.build(this.getStateMask(), this.value, domain.getHighValue());
        }
        return DoubleDomain.build(this.getStateMask(), domain.getLowValue(), this.value);
    }

    public IValueDomain intersect(double theLowValue, double theHighValue) {
        if (theLowValue == this.value && theHighValue == this.value) {
            return this;
        }
        return DoubleDomain.build(0, theLowValue < this.value ? theLowValue : this.value, theHighValue > this.value ? theHighValue : this.value);
    }

    public IValueDomain meet(IValueDomain element) {
        if (this.equals(element)) {
            return this;
        }
        return DoubleDomain.getDefault();
    }

    public boolean equals(IValueDomain element) {
        if (this == element) {
            return true;
        }
        IRealDomain domain = (IRealDomain)element;
        return domain.getValueType() == 7 && domain.isConstant() && (domain.getLowValue() == this.value || domain.getLowValue() / 10000.0 == this.value / 10000.0);
    }

    public boolean equals(ILatticeElement element) {
        if (this == element) {
            return true;
        }
        IRealDomain domain = (IRealDomain)element;
        return domain.getValueType() == 7 && domain.isConstant() && domain.getLowValue() == this.value;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public ILatticeElement join(ILatticeElement element) {
        return this.join((IValueDomain)element);
    }

    public ILatticeElement meet(ILatticeElement element) {
        return this.meet((IValueDomain)element);
    }

    public IRealDomain doMUL(IRealDomain domain) {
        if (domain.isConstant()) {
            return new DoubleConstant(this.value * domain.getLowValue());
        }
        return domain.doMUL(this);
    }

    public IRealDomain doDIV(IRealDomain domain) {
        if (domain.isConstant()) {
            return new DoubleConstant(this.value / domain.getLowValue());
        }
        return DoubleDomain.getDefault();
    }

    public IRealDomain doMOD(IRealDomain domain) {
        if (domain.isConstant()) {
            return new DoubleConstant(this.value % domain.getLowValue());
        }
        return DoubleDomain.getDefault();
    }

    public IRealDomain doADD(IRealDomain domain) {
        if (domain.isConstant()) {
            return new DoubleConstant(this.value + domain.getLowValue());
        }
        return domain.doADD(this);
    }

    public IRealDomain doSUB(IRealDomain domain) {
        if (domain.isConstant()) {
            return new DoubleConstant(this.value - domain.getLowValue());
        }
        return DoubleDomain.getDefault();
    }

    public IBooleanDomain doLT(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make(this.value < domain.getLowValue());
        }
        return domain.doGE(this);
    }

    public IBooleanDomain doGT(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make(this.value > domain.getLowValue());
        }
        return domain.doLE(this);
    }

    public IBooleanDomain doLE(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make(this.value <= domain.getLowValue());
        }
        return domain.doGT(this);
    }

    public IBooleanDomain doGE(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make(this.value >= domain.getLowValue());
        }
        return domain.doLT(this);
    }

    public IBooleanDomain doEQ(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make(this.value == domain.getLowValue());
        }
        if (this.value < domain.getLowValue() || this.value > domain.getHighValue()) {
            return BooleanConstant.forFalse();
        }
        return BooleanDomain.get();
    }

    public IBooleanDomain doNE(IRealDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make(this.value != domain.getLowValue());
        }
        if (this.value < domain.getLowValue() || this.value > domain.getHighValue()) {
            return BooleanConstant.forTrue();
        }
        return BooleanDomain.get();
    }

    public IRealDomain doNEG() {
        if (this.value == 0.0) {
            return this;
        }
        return new DoubleConstant(-this.value);
    }

    public IRealDomain doINC() {
        return new DoubleConstant(this.value + 1.0);
    }

    public IRealDomain doDEC() {
        return new DoubleConstant(this.value + 1.0);
    }

    public DoubleConstant(double valInit) {
        this.value = valInit;
    }

    public void printBrief(PrintStream out) {
        if (this.mayBeNegativeInfinity()) {
            out.print("DoubleConst: We found mayBeNegativeInfinity " + this.value);
        } else if (this.mayBePositiveInfinity()) {
            out.print("DoubleConst: We found mayBePositiveInfinity " + this.value);
        } else {
            out.print("DoubleConst:" + this.value);
        }
    }
}

