/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IByteConstant;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.internal.dataflow.values.AbstractIntegralConstant;
import java.io.PrintStream;

public class ByteConstant
extends AbstractIntegralConstant
implements IByteConstant {
    private byte value;

    public ByteConstant(int value) {
        this((byte)value, false);
    }

    public ByteConstant(byte value, boolean outOfBounds) {
        super(outOfBounds);
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public long minTypeValue() {
        return -128L;
    }

    public long maxTypeValue() {
        return 127L;
    }

    public Object asObject() {
        return new Byte(this.value);
    }

    public void printBrief(PrintStream out) {
        out.print("ByteConst: " + this.value);
    }

    protected int getType() {
        return 1;
    }

    protected IIntegralDomain buildSelf(long value, boolean outOfBounds) {
        return new ByteConstant((byte)value, outOfBounds);
    }

    protected long getLongValue() {
        return this.value;
    }

    public int getValueType() {
        return 1;
    }
}

