/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.values.EmptyBooleanDomain;
import com.togethersoft.sca.internal.dataflow.values.ValueDomain;
import java.io.PrintStream;

public class BooleanDomain
extends ValueDomain
implements IBooleanDomain {
    private static final BooleanDomain theInstance = new BooleanDomain();
    private static final BooleanDomain theEmpty = new EmptyBooleanDomain();

    public int getValueType() {
        return 8;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isTop() {
        return true;
    }

    public IValueDomain meet(IValueDomain element) {
        return element;
    }

    public boolean mayBeTrue() {
        return true;
    }

    public boolean mayBeFalse() {
        return true;
    }

    public IBooleanDomain doEQ(IBooleanDomain domain) {
        return this;
    }

    public IBooleanDomain doNE(IBooleanDomain domain) {
        return domain;
    }

    public IBooleanDomain doAND(IBooleanDomain domain) {
        if (domain.isConstant()) {
            return domain.doAND(this);
        }
        return this;
    }

    public IBooleanDomain doOR(IBooleanDomain domain) {
        if (domain.isConstant()) {
            return domain.doOR(this);
        }
        return this;
    }

    public IBooleanDomain doBOR(IBooleanDomain domain) {
        if (domain.isConstant()) {
            return domain.doBOR(this);
        }
        return this;
    }

    public IBooleanDomain doBAND(IBooleanDomain domain) {
        if (domain.isConstant()) {
            return domain.doBAND(this);
        }
        return this;
    }

    public IBooleanDomain doBXOR(IBooleanDomain domain) {
        if (domain.isConstant()) {
            return domain.doBXOR(this);
        }
        return this;
    }

    public IBooleanDomain doNOT() {
        return this;
    }

    protected BooleanDomain() {
    }

    public void printBrief(PrintStream out) {
        out.print("BoolDomain: {true,false}");
    }

    public static BooleanDomain get() {
        return theInstance;
    }

    public static BooleanDomain getEmpty() {
        return theEmpty;
    }
}

