/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IBooleanConstant;
import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.ILatticeElement;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.values.BooleanDomain;
import com.togethersoft.sca.internal.dataflow.values.ConstantVal;
import java.io.PrintStream;

public class BooleanConstant
extends ConstantVal
implements IBooleanConstant {
    private boolean value;
    private static BooleanConstant trueObject = new BooleanConstant(true);
    private static BooleanConstant falseObject = new BooleanConstant(false);

    public int getValueType() {
        return 8;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean equals(ILatticeElement element) {
        return element == this;
    }

    public boolean equals(IValueDomain element) {
        return element == this;
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public ILatticeElement meet(ILatticeElement element) {
        return this.meet((IValueDomain)element);
    }

    public IValueDomain meet(IValueDomain element) {
        if (element.getValueType() == 0) {
            return element;
        }
        if (element.isEmpty()) {
            return element;
        }
        if (element == this) {
            return this;
        }
        IBooleanDomain bd = (IBooleanDomain)element;
        if (bd.isConstant()) {
            return BooleanDomain.getEmpty();
        }
        if (bd.isBottom()) {
            return bd;
        }
        return this;
    }

    public ILatticeElement join(ILatticeElement element) {
        return this.join((IValueDomain)element);
    }

    public IValueDomain join(IValueDomain element) {
        if (element.getValueType() == 0) {
            return element;
        }
        if (element.isEmpty() || element == this) {
            return this;
        }
        IBooleanDomain bd = (IBooleanDomain)element;
        if (bd.isConstant()) {
            return BooleanDomain.get();
        }
        if (bd.isTop()) {
            return bd;
        }
        return this;
    }

    public int getValueKind() {
        return 2;
    }

    public boolean mayBeTrue() {
        return this.value;
    }

    public boolean mayBeFalse() {
        return !this.value;
    }

    public Object asObject() {
        return new Boolean(this.value);
    }

    public boolean isConstant() {
        return true;
    }

    public boolean getValue() {
        return this.value;
    }

    public IBooleanDomain doEQ(IBooleanDomain domain) {
        if (domain.isConstant()) {
            if (this == domain) {
                return trueObject;
            }
            return falseObject;
        }
        return domain;
    }

    public IBooleanDomain doNE(IBooleanDomain domain) {
        if (domain.isConstant()) {
            if (this != domain) {
                return trueObject;
            }
            return falseObject;
        }
        return domain;
    }

    public IBooleanDomain doAND(IBooleanDomain domain) {
        if (domain == BooleanDomain.getEmpty()) {
            return domain;
        }
        return this.value ? domain : this;
    }

    public IBooleanDomain doOR(IBooleanDomain domain) {
        if (domain == BooleanDomain.getEmpty()) {
            return domain;
        }
        return this.value ? this : domain;
    }

    public IBooleanDomain doBOR(IBooleanDomain domain) {
        if (domain == BooleanDomain.getEmpty()) {
            return domain;
        }
        return this.value ? this : domain;
    }

    public IBooleanDomain doBAND(IBooleanDomain domain) {
        if (domain == BooleanDomain.getEmpty()) {
            return domain;
        }
        return this.value ? domain : this;
    }

    public IBooleanDomain doBXOR(IBooleanDomain domain) {
        if (domain.isConstant()) {
            return BooleanConstant.make(this == domain);
        }
        return domain;
    }

    public IBooleanDomain doNOT() {
        return BooleanConstant.make(!this.value);
    }

    private BooleanConstant(boolean valInit) {
        this.value = valInit;
    }

    public void printBrief(PrintStream out) {
        out.print("BoolConst: " + this.value);
    }

    public static final BooleanConstant forTrue() {
        return trueObject;
    }

    public static final BooleanConstant forFalse() {
        return falseObject;
    }

    public static final BooleanConstant make(boolean what) {
        return what ? trueObject : falseObject;
    }
}

