/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IObjectDomain;
import com.togethersoft.sca.internal.dataflow.values.ObjectDomain;
import java.io.PrintStream;

public class ArrayObjectDomain
extends ObjectDomain {
    private IIntegralDomain lengthDomain;

    public ArrayObjectDomain(int mask, AstTypeReference javaType, IIntegralDomain lengthDomain) {
        super(mask, javaType);
        this.lengthDomain = lengthDomain;
    }

    public int getValueType() {
        return 10;
    }

    public boolean isArrayObject() {
        return true;
    }

    public boolean equals1(IObjectDomain element) {
        if (element instanceof ArrayObjectDomain) {
            ArrayObjectDomain domain = (ArrayObjectDomain)element;
            return domain.isArrayObject() && this.getMask() == domain.getMask() && this.frontEndType() == domain.frontEndType() && this.arrayLengthDomain().equals(domain.arrayLengthDomain());
        }
        return false;
    }

    public IIntegralDomain arrayLengthDomain() {
        return this.lengthDomain;
    }

    public void printBrief(PrintStream out) {
        out.print("   Is array domain range = ");
        if (this.lengthDomain == null) {
            out.println("NULL");
        } else {
            this.lengthDomain.printBrief(out);
            out.println();
        }
    }
}

