/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.values;

import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.ILatticeElement;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import com.togethersoft.sca.internal.dataflow.values.ConstantVal;
import com.togethersoft.sca.internal.dataflow.values.IntegralDomain;

public abstract class AbstractIntegralConstant
extends ConstantVal
implements IIntegralDomain {
    private boolean outOfBounds;

    protected AbstractIntegralConstant(boolean outOfBounds) {
        this.outOfBounds = outOfBounds;
    }

    public int getValueKind() {
        return 2;
    }

    public boolean isConstant() {
        return true;
    }

    protected abstract long getLongValue();

    public long getLowValue() {
        return this.getLongValue();
    }

    public long getHighValue() {
        return this.getLongValue();
    }

    public long getZeroBitMask() {
        return this.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public long getOnesBitMask() {
        return this.getLongValue();
    }

    public IValueDomain join(IValueDomain domain) {
        if (domain.getValueType() == 0) {
            return domain;
        }
        if (domain.isEmpty()) {
            return this;
        }
        if (domain.isConstant()) {
            long newMax;
            long newMin;
            AbstractIntegralConstant ac = (AbstractIntegralConstant)domain;
            if (this.getLongValue() == ac.getLongValue()) {
                return this;
            }
            if (this.getLongValue() < ac.getLongValue()) {
                newMin = this.getLongValue();
                newMax = ac.getLongValue();
            } else {
                newMin = ac.getLongValue();
                newMax = this.getLongValue();
            }
            return IntegralDomain.build(this.getType(), newMin, newMax, (newMin ^ 0xFFFFFFFFFFFFFFFFL) & (newMax ^ 0xFFFFFFFFFFFFFFFFL), newMin & newMax, false);
        }
        return domain.join(this);
    }

    public ILatticeElement join(ILatticeElement element) {
        return this.join((IValueDomain)element);
    }

    public int bitSize() {
        switch (this.getValueType()) {
            case 1: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 2: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
        }
        return 0;
    }

    public boolean isOutOfBounds() {
        return this.outOfBounds;
    }

    public long typeValueMask() {
        switch (this.getValueType()) {
            case 1: {
                return 255L;
            }
            case 3: {
                return 65535L;
            }
            case 2: {
                return 65535L;
            }
            case 4: {
                return 0xFFFFFFFFL;
            }
            case 5: {
                return -1L;
            }
        }
        return 0L;
    }

    public boolean equals(IValueDomain element) {
        AbstractIntegralConstant aic;
        if (this == element) {
            return true;
        }
        return element.isConstant() && this.getValueType() == element.getValueType() && (aic = (AbstractIntegralConstant)element).getValueType() == this.getValueType() && aic.getLongValue() == this.getLongValue();
    }

    public boolean equals(ILatticeElement element) {
        if (this == element) {
            return true;
        }
        return this.equals((IValueDomain)element);
    }

    public boolean isEmpty() {
        return false;
    }

    public ILatticeElement meet(ILatticeElement element) {
        return this.meet((IValueDomain)element);
    }

    public IValueDomain meet(IValueDomain element) {
        if (element == this || this.equals(element)) {
            return this;
        }
        return IntegralDomain.build(this.getValueType(), 0L, -1L, 0L, 0L, false);
    }

    public boolean isBottom() {
        return false;
    }

    public boolean isTop() {
        return false;
    }

    public IIntegralDomain doADD(IIntegralDomain domain) {
        long opnd2;
        if (!domain.isConstant()) {
            return domain.doADD(this);
        }
        long opnd1 = this.getLongValue();
        long result = opnd1 + (opnd2 = domain.getLowValue());
        boolean overflow = result > this.maxTypeValue() || result < this.minTypeValue() || ((opnd1 ^ 0xFFFFFFFFFFFFFFFFL ^ opnd2) & (opnd1 ^ result)) < 0L;
        return this.buildSelf(result, overflow);
    }

    public IIntegralDomain doSUB(IIntegralDomain domain) {
        long opnd2;
        if (!domain.isConstant()) {
            return this.buildSelfDomain().doSUB(domain);
        }
        long opnd1 = this.getLongValue();
        long result = opnd1 - (opnd2 = domain.getLowValue());
        boolean overflow = result > this.maxTypeValue() || result < this.minTypeValue() || ((opnd1 ^ opnd2) & (opnd2 ^ 0xFFFFFFFFFFFFFFFFL ^ result)) < 0L;
        return this.buildSelf(result, overflow);
    }

    public IIntegralDomain doMUL(IIntegralDomain domain) {
        long opnd1 = this.getLongValue();
        if (opnd1 == 0L) {
            return this;
        }
        if (opnd1 == 1L) {
            return domain;
        }
        if (!domain.isConstant()) {
            return domain.doMUL(this);
        }
        long opnd2 = domain.getLowValue();
        if (opnd2 == 0L) {
            return domain;
        }
        long result = opnd1 * opnd2;
        boolean overflow = !IntegralDomain.canMultiply(opnd1, opnd2) || result > this.maxTypeValue() || result < this.minTypeValue();
        return this.buildSelf(result, overflow);
    }

    public IIntegralDomain doDIV(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return this.buildSelfDomain().doDIV(domain);
        }
        long opnd1 = this.getLongValue();
        long opnd2 = domain.getLowValue();
        if (opnd2 == 0L) {
            return this.buildSelfEmptyDomain();
        }
        return this.buildSelf(opnd1 / opnd2, opnd1 == this.minTypeValue() && opnd2 == -1L);
    }

    public IIntegralDomain doMOD(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return this.buildSelfDomain().doMOD(domain);
        }
        long value2 = domain.getLowValue();
        if (value2 == 0L) {
            return this.buildSelfEmptyDomain();
        }
        return this.buildSelf(this.getLongValue() % value2, false);
    }

    public IIntegralDomain doShiftLeft(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return this.buildSelfDomain().doShiftLeft(domain);
        }
        return this.buildSelf(this.getLongValue() << (int)domain.getLowValue(), false);
    }

    public IIntegralDomain doShiftRight(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return this.buildSelfDomain().doShiftRight(domain);
        }
        return this.buildSelf(this.getLongValue() >> (int)domain.getLowValue(), false);
    }

    public IIntegralDomain doUnsignedShiftRight(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return this.buildSelfDomain().doUnsignedShiftRight(domain);
        }
        return this.buildSelf(this.getLongValue() >>> (int)domain.getLowValue(), false);
    }

    public IIntegralDomain doBAND(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return domain.doBAND(this);
        }
        return this.buildSelf(this.getLongValue() & domain.getLowValue(), false);
    }

    public IIntegralDomain doBOR(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return domain.doBOR(this);
        }
        return this.buildSelf(this.getLongValue() | domain.getLowValue(), false);
    }

    public IIntegralDomain doBXOR(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return domain.doBXOR(this);
        }
        return this.buildSelf(this.getLongValue() ^ domain.getLowValue(), false);
    }

    public IBooleanDomain doLT(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return domain.doGE(this);
        }
        return BooleanConstant.make(this.getLongValue() < domain.getLowValue());
    }

    public IBooleanDomain doGT(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return domain.doLE(this);
        }
        return BooleanConstant.make(this.getLongValue() > domain.getLowValue());
    }

    public IBooleanDomain doLE(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return domain.doGT(this);
        }
        return BooleanConstant.make(this.getLongValue() <= domain.getLowValue());
    }

    public IBooleanDomain doGE(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return domain.doLT(this);
        }
        return BooleanConstant.make(this.getLongValue() >= domain.getLowValue());
    }

    public IBooleanDomain doEQ(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return domain.doEQ(this);
        }
        return BooleanConstant.make(this.getLongValue() == domain.getLowValue());
    }

    public IBooleanDomain doNE(IIntegralDomain domain) {
        if (!domain.isConstant()) {
            return domain.doNE(this);
        }
        return BooleanConstant.make(this.getLongValue() != domain.getLowValue());
    }

    public IIntegralDomain doNEG() {
        return this.buildSelf(-this.getLongValue(), this.getLongValue() == this.minTypeValue());
    }

    public IIntegralDomain doCOM() {
        return this.buildSelf(this.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL, false);
    }

    public IIntegralDomain doINC() {
        return this.buildSelf(this.getLongValue() + 1L, this.getLongValue() == this.maxTypeValue());
    }

    public IIntegralDomain doDEC() {
        return this.buildSelf(this.getLongValue() - 1L, this.getLongValue() == this.minTypeValue());
    }

    protected abstract IIntegralDomain buildSelf(long var1, boolean var3);

    protected abstract int getType();

    private IIntegralDomain buildSelfDomain() {
        return new IntegralDomain(this.getType(), this.getLongValue(), this.getLongValue(), this.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL, this.getLongValue());
    }

    private IIntegralDomain buildSelfEmptyDomain() {
        return new IntegralDomain(this.getType());
    }

    public abstract long maxTypeValue();

    public abstract long minTypeValue();
}

