/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.patterns;

import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.dataflow.INamedUnit;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.internal.dataflow.AttributesProvider;
import com.togethersoft.sca.internal.dataflow.ClassUnit;
import com.togethersoft.sca.internal.dataflow.Field;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.NamedUnit;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.flowgraph.DataFlowGraph;
import com.togethersoft.sca.internal.dataflow.flowgraph.MemberVariable;
import com.togethersoft.sca.internal.dataflow.patterns.SingletonPatternInstance;

public class SingletonDetector
extends AttributesProvider {
    private Method instanceMethod;
    private Method initMethod;
    private static boolean[] attributeMap;

    public String name() {
        return "Singleton";
    }

    public SingletonPatternInstance[] getPatternInstances(Project prj) {
        int cnt = 0;
        ClassUnit cu = prj.classList();
        while (cu != null) {
            if (this.getSlotValue(cu) != null) {
                ++cnt;
            }
            cu = cu.getNextClass();
        }
        SingletonPatternInstance[] res = new SingletonPatternInstance[cnt];
        int idx = 0;
        ClassUnit cu2 = prj.classList();
        while (cu2 != null) {
            SingletonPatternInstance pi = (SingletonPatternInstance)this.getSlotValue(cu2);
            if (pi != null) {
                res[idx++] = pi;
            }
            cu2 = cu2.getNextClass();
        }
        return res;
    }

    public void updateLocalInfo(NamedUnit unit, Project prj) {
        ClassUnit theClass;
        if (unit instanceof ClassUnit && (theClass = (ClassUnit)unit).getAll() != null) {
            Field instanceField = this.findInstanceField(theClass);
            this.instanceMethod = null;
            if (instanceField != null && this.allConstructorsArePrivate(theClass) && this.hasInstanceMethod(instanceField, theClass)) {
                this.setSlotValue(unit, new SingletonPatternInstance(theClass, this.instanceMethod, instanceField));
            }
        }
    }

    private boolean allConstructorsArePrivate(ClassUnit theClass) {
        AstType tp = (AstType)theClass.getAstObject();
        AstMethod[] ctrs = tp.getConstructors();
        if (ctrs == null) {
            return false;
        }
        int i = 0;
        while (i < ctrs.length) {
            if (!ctrs[i].isPrivate()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Field findInstanceField(ClassUnit theClass) {
        Field fld = null;
        INamedUnit[] subUnits = theClass.getAll();
        int i = 0;
        while (i < subUnits.length) {
            Field f;
            if (subUnits[i] instanceof Field && this.isSuitableForInstanceField(f = (Field)subUnits[i], theClass)) {
                if (fld != null) {
                    return null;
                }
                fld = f;
            }
            ++i;
        }
        return fld;
    }

    private boolean isSuitableForInstanceField(Field fld, ClassUnit theClass) {
        return fld.isStatic() && fld.accessType() == 3 && ((AstField)fld.getAstObject()).getType() == theClass.getAstObject();
    }

    private boolean hasInstanceMethod(Field fld, ClassUnit theClass) {
        this.instanceMethod = null;
        this.initMethod = null;
        INamedUnit[] subUnits = theClass.getAll();
        int i = 0;
        while (i < subUnits.length) {
            if (subUnits[i] instanceof ClassUnit) {
                return false;
            }
            if (subUnits[i] instanceof Method && !this.goodForSingletonMethod((Method)subUnits[i], fld)) {
                return false;
            }
            ++i;
        }
        return this.instanceMethod != null && this.initMethod != null;
    }

    private boolean goodForSingletonMethod(Method m, Field fld) {
        DataFlowGraph dfg = m.getDFG();
        if (dfg == null) {
            return false;
        }
        ITuple t = dfg.getTupleList();
        while (t != null) {
            IVar v;
            if (t.getCode() == 31 && (v = t.result()) instanceof MemberVariable && ((MemberVariable)v).fieldUnit() == fld) {
                this.initMethod = m;
            }
            t = t.getNext();
        }
        AstMethod am = (AstMethod)m.getAstObject();
        if (!am.isConstructor() && am.getReturnType() == am.getDeclaringType()) {
            this.instanceMethod = m;
        }
        return true;
    }

    public void updateGlobalInfo(Project prj) {
    }

    public boolean[] getRequestedSlots() {
        if (attributeMap == null) {
            attributeMap = new boolean[8];
            SingletonDetector.attributeMap[7] = true;
        }
        return attributeMap;
    }
}

