/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.patterns;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.dataflow.IMethod;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.values.IObjectDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.Attribute;
import com.togethersoft.sca.internal.dataflow.AttributesProvider;
import com.togethersoft.sca.internal.dataflow.Behavior;
import com.togethersoft.sca.internal.dataflow.ClassUnit;
import com.togethersoft.sca.internal.dataflow.DataFlowAnalyzer;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.NamedUnit;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.flowgraph.DataFlowGraph;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.NewTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ReturnTuple;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AbstractFactoryDetector
extends AttributesProvider {
    private static boolean[] attributeMap;
    private Set patterns = new HashSet();
    private Set classNodes = new HashSet();
    private DataFlowAnalyzer analyzer;

    public String name() {
        return "Abstract Factory";
    }

    public boolean[] getRequestedSlots() {
        if (attributeMap == null) {
            attributeMap = new boolean[8];
            AbstractFactoryDetector.attributeMap[4] = true;
        }
        return attributeMap;
    }

    private void setMethodAttribute(Method mth, Behavior value) {
        this.setSlotValue(mth, new MethodAttribute(value));
    }

    public Behavior getMethodAttribute(Method mth) {
        return ((MethodAttribute)this.getSlotValue((NamedUnit)mth)).value;
    }

    public void updateLocalInfo(NamedUnit unit, Project prj) {
        if (unit instanceof Method) {
            AstMethod am;
            AstTypeReference tr;
            AstObject ao;
            Method m = (Method)unit;
            Behavior b = null;
            if (m.getDFG() != null && (ao = m.getAstObject()) instanceof AstMethod && (tr = (am = (AstMethod)ao).getReturnType()).getBaseType() != null && tr.numDimensions() == 0 && (tr = this.actuallyGeneratedType(m)) != null && this.bodySuitableForInstanceCreator(m, tr)) {
                b = prj.getFor(tr.getBaseType());
            }
            this.setMethodAttribute(m, b);
        }
    }

    private AstTypeReference actuallyGeneratedType(Method m) {
        AstTypeReference gr = null;
        DataFlowGraph dfg = m.getDFG();
        if (dfg != null) {
            ITuple t = dfg.getTupleList();
            while (t != null) {
                IValueDomain v;
                ReturnTuple rt;
                if (t.getCode() == 43 && (rt = (ReturnTuple)t).operands() != null && rt.operands().length != 0 && (v = rt.operandValue(0)) instanceof IObjectDomain) {
                    IObjectDomain od = (IObjectDomain)v;
                    AstTypeReference tr = od.frontEndType();
                    gr = gr == null ? tr : tr;
                }
                t = t.getNext();
            }
        }
        return gr;
    }

    private boolean bodySuitableForInstanceCreator(Method m, AstTypeReference tr) {
        DataFlowGraph dfg = m.getDFG();
        if (dfg != null) {
            ITuple t = dfg.getTupleList();
            while (t != null) {
                NewTuple nt;
                if (t.getCode() == 29 && (nt = (NewTuple)t).getTypeReference() == tr) {
                    return true;
                }
                t = t.getNext();
            }
        }
        return false;
    }

    public void updateGlobalInfo(Project prj) {
        this.analyzer = prj.getAnalyzer();
        this.patterns.clear();
        ClassUnit cu = this.analyzer.classList();
        while (cu != null) {
            PatternInstance pi = this.checkForAbstractFactory(cu);
            if (pi != null) {
                this.patterns.add(pi);
            }
            cu = cu.getNextClass();
        }
    }

    private boolean isEligibleForAbstractFactory(Behavior b) {
        Iterator i = this.patterns.iterator();
        while (i.hasNext()) {
            PatternInstance pi = (PatternInstance)i.next();
            if (!pi.containsAsFactory(b)) continue;
            return false;
        }
        return true;
    }

    private TNode build(Behavior b) {
        TNode t = new TNode(b);
        AstType at = (AstType)b.getAstObject();
        AstType[] sub = at.getSubtypes();
        if (sub != null) {
            t.children = new TNode[sub.length];
            int i = 0;
            while (i < sub.length) {
                Behavior c = this.analyzer.getFor(sub[i]);
                if (c != null) {
                    t.children[i] = this.build(c);
                } else {
                    System.err.println("Can't find dataflow info for ast " + sub[i]);
                }
                ++i;
            }
        } else {
            t.children = new TNode[0];
        }
        return t;
    }

    private Method findOverrider(TNode r, TNode n, Method m) {
        AstMethod am = (AstMethod)m.getAstObject();
        AstMethod[] ams = am.overriddenBy();
        if (ams != null) {
            int i = 0;
            while (i < ams.length) {
                Behavior b0 = this.analyzer.getFor(ams[i].getDeclaringType());
                if (b0 == n.b) {
                    Method om = this.analyzer.getFor(ams[i]);
                    if (om != null && this.getMethodAttribute(om) != null) {
                        return om;
                    }
                    return null;
                }
                ++i;
            }
        }
        return null;
    }

    private TNode[] asArray(TNode t) {
        int l = t.nNodes();
        TNode[] tna = new TNode[l];
        t.put(tna, 0);
        return tna;
    }

    private boolean matchesAsProduct(TNode f, TNode p, Method m) {
        TNode[] tna = this.asArray(f);
        if (tna.length == 1) {
            return false;
        }
        int i = 1;
        while (i < tna.length) {
            Method mo = this.findOverrider(p, tna[i], m);
            if (mo == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public PatternInstance checkForAbstractFactory(Behavior b) {
        PatternInstance p = null;
        if (this.isEligibleForAbstractFactory(b)) {
            TNode t = this.build(b);
            if (t.children == null || t.children.length == 0) {
                return null;
            }
            IMethod[] meths = t.getMethods();
            int i = 0;
            while (i < meths.length) {
                TNode t0;
                Behavior tp0;
                AstType apat;
                Method m = (Method)meths[i];
                AstMethod am = (AstMethod)m.getAstObject();
                if (am != null && (apat = am.getReturnType().getBaseType()) != null && (tp0 = this.analyzer.getFor(apat)) != null && this.matchesAsProduct(t, t0 = this.build(tp0), m)) {
                    if (p == null) {
                        p = new PatternInstance(new ClassNode(b));
                        TNode[] cf = this.asArray(t);
                        int j = 1;
                        while (j < cf.length) {
                            p.concreteFactories.add(cf[j].b);
                            ++j;
                        }
                    }
                    TNode[] pr = this.asArray(t0);
                    Behavior[] prb = new Behavior[pr.length];
                    int j = 0;
                    while (j < prb.length) {
                        prb[j] = pr[j].b;
                        ++j;
                    }
                    p.products.add(prb);
                }
                ++i;
            }
        }
        return p;
    }

    public Object[][] getInfo() {
        PatternInstance[] pi = this.getPatterns();
        Object[][] res = new Object[pi.length][];
        int i = 0;
        while (i < pi.length) {
            res[i] = new Object[]{pi[i].abstractFactory.theType, pi[i].concreteFactories.toArray(), pi[i].products.toArray((T[])new Object[pi[i].products.size()][])};
            ++i;
        }
        return res;
    }

    public PatternInstance[] getPatterns() {
        PatternInstance[] pi = new PatternInstance[this.patterns.size()];
        this.patterns.toArray(pi);
        return pi;
    }

    private class TNode {
        Behavior b;
        TNode[] children;

        IMethod[] getMethods() {
            return this.b.getMethods();
        }

        TNode(Behavior b) {
            this.b = b;
        }

        boolean hasChild(Behavior b1) {
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i].contains(b1)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        int nNodes() {
            int i = 1;
            int j = 0;
            while (j < this.children.length) {
                i += this.children[j].nNodes();
                ++j;
            }
            return i;
        }

        int put(TNode[] a, int idx) {
            a[idx++] = this;
            int i = 0;
            while (i < this.children.length) {
                idx = this.children[i].put(a, idx);
                ++i;
            }
            return idx;
        }

        private boolean contains(Behavior b1) {
            return b1 == this.b || this.hasChild(b1);
        }
    }

    class PatternInstance {
        private ClassNode abstractFactory;
        private Set concreteFactories;
        private Set products;

        void remove() {
        }

        boolean containsAsFactory(Behavior b) {
            if (this.abstractFactory.getType() == b) {
                return true;
            }
            Iterator e = this.concreteFactories.iterator();
            while (e.hasNext()) {
                Behavior c = (Behavior)e.next();
                if (c != b) continue;
                return true;
            }
            return false;
        }

        boolean obsoleted() {
            return false;
        }

        PatternInstance(ClassNode abstractFactory) {
            this.abstractFactory = abstractFactory;
            this.concreteFactories = new HashSet();
            this.products = new HashSet();
        }

        class ProductInfo {
            private MethodNode generator;
            private ClassNode abstractProduct;
            private Set products;

            ProductInfo(MethodNode generator, ClassNode abstractProduct) {
                this.generator = generator;
                this.abstractProduct = abstractProduct;
                this.products = new HashSet();
            }
        }
    }

    private class MethodNode {
        private Method theMethod;
        private ClassNode theType;
        private ClassNode generates;

        MethodNode(Method theMethod, ClassNode theType, ClassNode generates) {
            this.theMethod = theMethod;
            this.theType = theType;
            this.generates = generates;
        }
    }

    private class ClassNode {
        private Behavior theType;
        private Set bases;
        private Set derived;
        private Set generators;
        private boolean valid;

        boolean isValid() {
            return this.valid;
        }

        void markAsInvalid() {
            this.valid = false;
        }

        Behavior getType() {
            return this.theType;
        }

        ClassNode(Behavior theType) {
            this.theType = theType;
            this.bases = new HashSet();
            this.derived = new HashSet();
            this.generators = new HashSet();
            this.valid = true;
        }
    }

    private class MethodAttribute
    extends Attribute {
        Behavior value;

        MethodAttribute(Behavior value) {
            this.value = value;
        }
    }
}

