/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.known;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.dataflow.IKnownMethod;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.values.IBooleanConstant;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IObjectConstant;
import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.core.ErrorLog;
import com.togethersoft.sca.internal.core.Parser;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import com.togethersoft.sca.internal.dataflow.flowgraph.TempVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.MemberAccessTuple;
import com.togethersoft.sca.internal.dataflow.known.KnownClass;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import com.togethersoft.sca.internal.dataflow.values.ByteConstant;
import com.togethersoft.sca.internal.dataflow.values.CharConstant;
import com.togethersoft.sca.internal.dataflow.values.ConstantVal;
import com.togethersoft.sca.internal.dataflow.values.DoubleConstant;
import com.togethersoft.sca.internal.dataflow.values.FloatConstant;
import com.togethersoft.sca.internal.dataflow.values.IntConstant;
import com.togethersoft.sca.internal.dataflow.values.IntegralDomain;
import com.togethersoft.sca.internal.dataflow.values.LongConstant;
import com.togethersoft.sca.internal.dataflow.values.ObjectConstant;
import com.togethersoft.sca.internal.dataflow.values.ShortConstant;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.w3c.dom.Element;

public class KnownMethod
implements IKnownMethod {
    private AstDeclaration decl;
    private boolean sideEffect;
    private boolean interpretFromLibrary;
    private KnownClass classInfo;
    private IValueDomain returnValue;
    private java.lang.reflect.Method theMetaMethod;
    private String methodName;
    private String signature;
    private int[] operandRTTypes;
    private Class[] operandClasses;
    private IValueDomain[] parameterValues;

    KnownMethod(KnownClass classInfoValue, AstDeclaration declValue, String methodNameValue, String signatureValue, boolean sideEffectValue, boolean interpretFromLibraryValue, Element el, Project prj) {
        this.decl = declValue;
        this.sideEffect = sideEffectValue;
        this.interpretFromLibrary = interpretFromLibraryValue;
        this.returnValue = this.buildReturnValue(signatureValue, el);
        this.classInfo = classInfoValue;
        this.classInfo.addMethod(this);
        Method methodBlock = null;
        if (declValue instanceof AstMethod) {
            methodBlock = prj.getFor((AstMethod)declValue);
        } else if (declValue instanceof AstInitializer) {
            methodBlock = prj.getFor((AstInitializer)declValue);
        }
        if (methodBlock != null) {
            if (methodBlock.extraInfo == null) {
                methodBlock.extraInfo = this;
            } else {
                methodBlock.extraInfo.sideEffect = this.sideEffect;
            }
        }
        this.methodName = methodNameValue;
        this.signature = signatureValue;
        int nOperands = 0;
        int i = 1;
        while (this.signature.charAt(i) != ')') {
            ++nOperands;
            while (this.signature.charAt(i) == '[') {
                ++i;
            }
            if (this.signature.charAt(i) == 'L') {
                while (this.signature.charAt(++i) != ';') {
                }
            }
            ++i;
        }
        this.operandRTTypes = new int[nOperands];
        this.operandClasses = new Class[nOperands];
        this.parameterValues = new IValueDomain[nOperands];
        int idx = 1;
        int i2 = 0;
        while (i2 < nOperands) {
            switch (this.signature.charAt(idx)) {
                case 'B': {
                    this.operandRTTypes[i2] = 1;
                    this.operandClasses[i2] = Byte.TYPE;
                    break;
                }
                case 'C': {
                    this.operandRTTypes[i2] = 3;
                    this.operandClasses[i2] = Character.TYPE;
                    break;
                }
                case 'D': {
                    this.operandRTTypes[i2] = 7;
                    this.operandClasses[i2] = Double.TYPE;
                    break;
                }
                case 'F': {
                    this.operandRTTypes[i2] = 6;
                    this.operandClasses[i2] = Float.TYPE;
                    break;
                }
                case 'I': {
                    this.operandRTTypes[i2] = 4;
                    this.operandClasses[i2] = Integer.TYPE;
                    break;
                }
                case 'J': {
                    this.operandRTTypes[i2] = 5;
                    this.operandClasses[i2] = Long.TYPE;
                    break;
                }
                case 'L': {
                    int startIdx = idx + 1;
                    idx = this.signature.indexOf(59, idx);
                    String name = this.signature.substring(startIdx, idx).replace('/', '.');
                    this.operandRTTypes[i2] = 9;
                    try {
                        this.operandClasses[i2] = Class.forName(name);
                    }
                    catch (ClassNotFoundException cnf) {
                        ErrorLog.log(1, "Class not found: " + name);
                    }
                    break;
                }
                case 'S': {
                    this.operandRTTypes[i2] = 2;
                    this.operandClasses[i2] = Short.TYPE;
                    break;
                }
                case 'Z': {
                    this.operandRTTypes[i2] = 8;
                    this.operandClasses[i2] = Boolean.TYPE;
                    break;
                }
                case '[': {
                    int startIdx = idx;
                    while (this.signature.charAt(++idx) == '[') {
                    }
                    String name = this.signature.substring(startIdx, idx + 1);
                    this.operandRTTypes[i2] = 10;
                    try {
                        this.operandClasses[i2] = Class.forName(name);
                    }
                    catch (ClassNotFoundException cnf) {
                        ErrorLog.log(1, "Array class not found: " + name);
                    }
                    break;
                }
                default: {
                    ErrorLog.log(1, "Strange character in signature: " + this.signature.charAt(idx));
                }
            }
            this.parameterValues[i2] = this.buildDomain(this.signature, idx, Parser.getFirstElement(el, "arg" + i2));
            ++idx;
            ++i2;
        }
        try {
            this.theMetaMethod = classInfoValue.getMetaObject().getDeclaredMethod(methodNameValue, this.operandClasses);
        }
        catch (Exception e) {
            this.theMetaMethod = null;
        }
    }

    private IValueDomain buildReturnValue(String signature, Element el) {
        int index = signature.lastIndexOf(41);
        if (index < 0 || signature.length() != index + 2) {
            return null;
        }
        return this.buildDomain(signature, index + 1, el);
    }

    private IValueDomain buildDomain(String typespec, int index, Element el) {
        long max;
        long min;
        int type;
        if (el == null) {
            return null;
        }
        switch (typespec.charAt(index)) {
            case 'B': {
                type = 1;
                min = -128L;
                max = 127L;
                break;
            }
            case 'C': {
                type = 3;
                min = 0L;
                max = 65535L;
                break;
            }
            case 'S': {
                type = 2;
                min = -32768L;
                max = 32767L;
                break;
            }
            case 'I': {
                type = 4;
                min = Integer.MIN_VALUE;
                max = Integer.MAX_VALUE;
                break;
            }
            case 'J': {
                type = 5;
                min = Long.MIN_VALUE;
                max = Long.MAX_VALUE;
                break;
            }
            default: {
                return null;
            }
        }
        try {
            String minValue = el.getAttribute("minvalue");
            String maxValue = el.getAttribute("maxvalue");
            if (!minValue.equals("")) {
                min = Long.parseLong(minValue);
            }
            if (!maxValue.equals("")) {
                max = Long.parseLong(maxValue);
            }
        }
        catch (Exception e) {
            ErrorLog.log(1, "Invalid known method constrain: " + e.getMessage());
        }
        return IntegralDomain.build(type, min, max, 0L, 0L, false);
    }

    IValueDomain invoke(ExprTuple t) {
        Object res;
        IValueDomain v;
        TempVariable tv;
        IVal[] opVal = t.operands();
        Object[] ops = new Object[opVal.length - 1];
        int i = 0;
        while (i < ops.length) {
            switch (this.operandRTTypes[i]) {
                case 1: {
                    long l = ((IIntegralDomain)((Object)opVal[i + 1])).getLowValue();
                    ops[i] = new Byte((byte)l);
                    break;
                }
                case 2: {
                    long l = ((IIntegralDomain)((Object)opVal[i + 1])).getLowValue();
                    ops[i] = new Short((short)l);
                    break;
                }
                case 3: {
                    long l = ((IIntegralDomain)((Object)opVal[i + 1])).getLowValue();
                    ops[i] = new Character((char)l);
                    break;
                }
                case 4: {
                    long l = ((IIntegralDomain)((Object)opVal[i + 1])).getLowValue();
                    ops[i] = new Integer((int)l);
                    break;
                }
                case 5: {
                    long l = ((IIntegralDomain)((Object)opVal[i + 1])).getLowValue();
                    ops[i] = new Long(l);
                    break;
                }
                case 7: {
                    double d = ((IRealDomain)((Object)opVal[i + 1])).getLowValue();
                    ops[i] = new Double(d);
                    break;
                }
                case 6: {
                    double d = ((IRealDomain)((Object)opVal[i + 1])).getLowValue();
                    ops[i] = new Float((float)d);
                    break;
                }
                case 8: {
                    ops[i] = new Boolean(((IBooleanConstant)opVal[i + 1]).getValue());
                    break;
                }
                case 9: 
                case 10: {
                    ops[i] = ((IObjectConstant)opVal[i + 1]).getValue();
                    break;
                }
            }
            ++i;
        }
        Object theObject = null;
        if (!Modifier.isStatic(this.theMetaMethod.getModifiers()) && t.operand(0) instanceof TempVariable && (tv = (TempVariable)t.operand(0)).sourceTuple() instanceof MemberAccessTuple && (v = tv.sourceTuple().operandValue(0)) instanceof IObjectConstant) {
            theObject = ((IObjectConstant)v).getValue();
        }
        try {
            res = this.theMetaMethod.invoke(theObject, ops);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        ConstantVal resVal = null;
        switch (t.backEndType()) {
            case 1: {
                resVal = new ByteConstant(((Byte)res).byteValue());
                break;
            }
            case 2: {
                resVal = new ShortConstant((Short)res);
                break;
            }
            case 3: {
                resVal = new CharConstant(((Character)res).charValue());
                break;
            }
            case 4: {
                resVal = new IntConstant((Integer)res);
                break;
            }
            case 5: {
                resVal = new LongConstant((Long)res);
                break;
            }
            case 7: {
                resVal = new DoubleConstant((Double)res);
                break;
            }
            case 6: {
                resVal = new FloatConstant(((Float)res).floatValue());
                break;
            }
            case 8: {
                resVal = BooleanConstant.make((Boolean)res);
                break;
            }
            case 9: 
            case 10: {
                resVal = new ObjectConstant(res);
                AstExpression aExpr = (AstExpression)t.getAstObject();
                AstTypeReference aType = aExpr.getType();
                ((ObjectConstant)resVal).setFrontEndTypeReference(aType);
                break;
            }
        }
        return resVal;
    }

    public IValueDomain propagateValues(ExprTuple t) {
        block3: {
            if (this.interpretFromLibrary) {
                IVal[] operands = t.operands();
                int i = 1;
                while (i < operands.length) {
                    if (operands[i].isConstant()) {
                        ++i;
                        continue;
                    }
                    break block3;
                }
                return this.invoke(t);
            }
        }
        return this.returnValue;
    }

    public void constrain(ExprTuple t, IValueDomain value, ConstraintCollection coll) {
    }

    public boolean hasSideEffect() {
        return this.sideEffect;
    }

    public IValueDomain getReturnValue() {
        return this.returnValue;
    }

    public IValueDomain getParameterValue(int arg) {
        if (arg >= 0 && arg < this.parameterValues.length) {
            return this.parameterValues[arg];
        }
        return null;
    }

    public AstDeclaration getDeclaration() {
        return this.decl;
    }
}

