/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.known;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.core.ErrorLog;
import com.togethersoft.sca.internal.core.Parser;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.known.KnownClass;
import com.togethersoft.sca.internal.dataflow.known.KnownMethod;
import java.io.InputStream;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class KnownInfoLoader {
    private static Project theProject;
    private static AstModel theModel;
    private static KnownClass javaLangString;
    private static KnownClass javaLangObject;

    public KnownInfoLoader(Project prj, AstModel model) {
        theProject = prj;
        theModel = model;
        this.loadInfo();
    }

    public void cleanup() {
        theProject = null;
        theModel = null;
        javaLangString = null;
        javaLangObject = null;
    }

    private void loadInfo() {
        Parser parser = new Parser();
        InputStream info = this.getClass().getClassLoader().getResourceAsStream("com/togethersoft/sca/internal/dataflow/known/knownLibrary.xml");
        if (info != null && parser.parse(new InputSource(info))) {
            this.parseInfo(parser);
        } else {
            ErrorLog.log(1, "Invalid known info description");
        }
    }

    private void parseInfo(Parser parser) {
        String tag = "class";
        Element known = parser.getElement("/known");
        if (known != null) {
            Element el = Parser.getFirstElement(known, tag);
            while (el != null) {
                String className = el.getAttribute("name");
                AstType typeNode = theModel.findType(className);
                KnownClass cls = KnownClass.getFor(theProject, theModel, className);
                if (typeNode != null && cls != null) {
                    ErrorLog.log(4, "loading known info on " + className);
                    Element me = Parser.getFirstElement(el, "method");
                    while (me != null) {
                        String methodName = me.getAttribute("name");
                        String signature = me.getAttribute("signature");
                        ErrorLog.log(4, " . " + methodName + ":" + signature);
                        String sideEffect = me.getAttribute("sideeffect");
                        String interpret = me.getAttribute("interpret");
                        ErrorLog.log(4, " . . sideeffect = " + sideEffect);
                        AstMethod meth = typeNode.findMethod(methodName, signature, false);
                        if (meth == null) {
                            ErrorLog.log(4, "not found");
                        } else {
                            new KnownMethod(cls, meth, methodName, signature, sideEffect == null || !sideEffect.equals("no"), interpret != null && interpret.equals("yes"), me, theProject);
                        }
                        me = Parser.getNextElement(me, "method");
                    }
                }
                el = Parser.getNextElement(el, tag);
            }
        }
    }

    public static final KnownClass getJavaLangObject() {
        if (javaLangObject == null) {
            javaLangObject = KnownClass.getFor(theProject, theModel, "java/lang/Object");
        }
        return javaLangObject;
    }

    public static final KnownClass getJavaLangString() {
        if (javaLangString == null) {
            javaLangString = KnownClass.getFor(theProject, theModel, "java/lang/String");
        }
        return javaLangString;
    }
}

