/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.known;

import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.dataflow.Behavior;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.known.KnownMethod;
import java.util.Vector;

public class KnownClass {
    private AstType astType;
    private String name;
    private Vector methods;
    private Class metaObject;
    private Behavior theBehavior;

    private KnownClass(Behavior b, AstType astTypeValue, String nameValue) {
        this.astType = astTypeValue;
        this.name = nameValue;
        this.methods = new Vector();
        try {
            this.metaObject = Class.forName(nameValue.replace('/', '.'));
        }
        catch (ClassNotFoundException cnf) {
            System.err.println("Class not found ::: " + this.name);
            this.metaObject = null;
        }
        this.theBehavior = b;
        if (this.theBehavior != null) {
            this.theBehavior.knownInfo = this;
        }
    }

    public static KnownClass getFor(Project prj, AstModel model, String nameValue) {
        AstType typeNode = model.findType(nameValue);
        if (typeNode == null) {
            return null;
        }
        Behavior b = prj.getFor(typeNode);
        if (b == null) {
            return null;
        }
        if (b.knownInfo != null) {
            return b.knownInfo;
        }
        return new KnownClass(b, typeNode, nameValue);
    }

    protected KnownClass() {
        this.methods = new Vector();
    }

    void addMethod(KnownMethod m) {
        this.methods.add(m);
    }

    public Class getMetaObject() {
        return this.metaObject;
    }

    public final AstType getAstType() {
        return this.astType;
    }

    public final String getName() {
        return this.name;
    }

    Behavior getBehavior() {
        return this.theBehavior;
    }
}

