/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.fsa;

import com.togethersoft.sca.internal.dataflow.fsa.FSAState;

public class StateSet {
    private static final int initSize = 4;
    private static final int incrSize = 4;
    private FSAState[] states;
    private short nStates;
    private short recent;

    public StateSet() {
        this.nStates = 0;
        this.recent = 0;
        this.states = new FSAState[4];
    }

    StateSet(StateSet s) {
        this.nStates = s.nStates;
        this.recent = s.recent;
        this.states = new FSAState[this.nStates];
        int i = 0;
        while (i < this.nStates) {
            this.states[i] = s.states[i];
            ++i;
        }
    }

    void playChange(FSAState sFrom, FSAState sTo) {
        if (sFrom.equals(sTo)) {
            System.err.println("  #################  !");
            return;
        }
        int i = 0;
        while (i < this.nStates) {
            if (sFrom.equals(this.states[i])) {
                if (this.haveItem(sTo)) {
                    this.states[i] = this.states[this.nStates - 1];
                    this.nStates = (short)(this.nStates - 1);
                } else {
                    this.states[i] = sTo;
                }
                return;
            }
            ++i;
        }
    }

    public final boolean addItem(FSAState state) {
        if (state == null) {
            return false;
        }
        if (this.haveItem(state)) {
            return false;
        }
        if (this.nStates == this.states.length) {
            FSAState[] newStates = new FSAState[this.nStates + 4];
            System.arraycopy(this.states, 0, newStates, 0, this.nStates);
            this.states = newStates;
        }
        this.states[this.nStates] = state;
        this.nStates = (short)(this.nStates + 1);
        return true;
    }

    public final boolean haveItem(FSAState state) {
        int i = 0;
        while (i < this.nStates) {
            if (state.equals(this.states[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final FSAState getRecent() {
        if (this.recent == this.nStates) {
            return null;
        }
        short s = this.recent;
        this.recent = (short)(s + 1);
        return this.states[s];
    }

    public boolean changed() {
        return this.recent != this.nStates;
    }

    public final int nItems() {
        return this.nStates;
    }

    public final FSAState item(int n) {
        return this.states[n];
    }
}

