/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.fsa;

import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.flowgraph.BasicBlock;
import com.togethersoft.sca.internal.dataflow.flowgraph.DataFlowGraph;
import com.togethersoft.sca.internal.dataflow.flowgraph.ValueTable;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.AssignmentTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.IfTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.SwitchTuple;
import com.togethersoft.sca.internal.dataflow.fsa.FSA;
import com.togethersoft.sca.internal.dataflow.fsa.FSAState;
import com.togethersoft.sca.internal.dataflow.fsa.StateSet;

public class FSAAnalyzer {
    private Method[] method;
    private boolean[] rootMethod;
    private StateSet[] returnValue;
    private StateSet[][] parameterValue;
    private MethodContext currentContext;
    private FSA automaton;

    public FSAAnalyzer(FSA automaton) {
        this.automaton = automaton;
        this.automaton.setAnalyzer(this);
    }

    private void computeRootSet(Project p) {
    }

    private void prepareGlobalDatabase(Project p) {
        int nMethods = p.getNumberOfMethods();
        this.method = new Method[nMethods];
        this.rootMethod = new boolean[nMethods];
        this.returnValue = new StateSet[nMethods];
        this.parameterValue = new StateSet[nMethods][];
        Method m = p.methodList();
        while (m != null) {
            this.method[m.getMethodId()] = m;
            m = m.getNext();
        }
        this.computeRootSet(p);
    }

    private void initGlobalValues() {
    }

    private boolean anyValueChanged() {
        boolean changed = false;
        int nMethods = this.method.length;
        int i = 0;
        while (i < nMethods) {
            if (this.method[i] != null) {
                changed |= this.returnValue[i].changed();
                StateSet[] pChanged = this.parameterValue[i];
                if (pChanged != null) {
                    int j = 0;
                    while (j < pChanged.length) {
                        changed |= pChanged[j].changed();
                        ++j;
                    }
                }
            }
            ++i;
        }
        return changed;
    }

    public void doGlobalAnalysis(Project p) {
        int nMethods = p.getNumberOfMethods();
        this.prepareGlobalDatabase(p);
        this.initGlobalValues();
        do {
            int i = 0;
            while (i < nMethods) {
                this.processMethod(this.method[i]);
                ++i;
            }
        } while (this.anyValueChanged());
    }

    public void noteResult(ITuple tuple, FSAState state) {
        this.currentContext.noteResult(tuple, state);
    }

    public void processMethod(Method m) {
        if (m.getDFG() != null) {
            MethodContext mc;
            this.currentContext = mc = new MethodContext(m, this.automaton);
            mc.initInputs(this.automaton);
            mc.analyseGraph(this.automaton);
            if (this.automaton.havePostStep()) {
                mc.postAnalyze(this.automaton);
            }
            mc.checkExit(this.automaton);
            this.currentContext = null;
        }
    }

    private FSAState rollOver(Var v, FSAState state, BasicBlock b) {
        ITuple tCurr;
        ITuple tNext = b.getFirstTuple();
        FSAState s = state;
        do {
            tCurr = tNext;
            s = this.automaton.step(v, s, tCurr);
            tNext = tCurr.getNext();
        } while (tCurr != b.getLastTuple());
        return s;
    }

    class MethodContext {
        Var[] vars;
        BasicBlock[] blocks;
        StateSet[][] in;
        ChangeSet changes;
        int resVarIdx;
        StateSet resultSet;
        AssignmentInfo asgs;

        void initInputs(FSA a) {
            int i = 0;
            while (i < this.vars.length) {
                this.in[0][i].addItem(a.start(this.vars[i]));
                ++i;
            }
        }

        void checkExit(FSA a) {
            if (this.resVarIdx != -1) {
                FSAAnalyzer.this.automaton.checkExitSet(this.resultSet);
            }
        }

        public void noteResult(ITuple tuple, FSAState state) {
            this.asgs.addResultState(tuple, state);
        }

        /*
         * Unable to fully structure code
         */
        void analyseGraph(FSA a) {
            nBasicBlocks = this.blocks.length;
            nVars = this.vars.length;
            do {
                changed = false;
                bbNo = 0;
                while (bbNo < nBasicBlocks) {
                    varNo = 0;
                    ** GOTO lbl13
                    {
                        changed |= this.analyseBasicBlock(bbNo, varNo, a, (FSAState)var7_7, null);
                        do {
                            if ((state = this.in[bbNo][varNo].getRecent()) != null) continue block2;
                            ++varNo;
lbl13:
                            // 2 sources

                        } while (varNo < nVars);
                    }
                    ++bbNo;
                }
            } while (changed |= this.analyseAssignmentSets(a));
        }

        void postAnalyze(FSA a) {
            int nBasicBlocks = this.blocks.length;
            int nVars = this.vars.length;
            int bbNo = 0;
            while (bbNo < nBasicBlocks) {
                int varNo = 0;
                while (varNo < nVars) {
                    this.postAnalyzeBasicBlock(bbNo, varNo, a, this.in[bbNo][varNo]);
                    ++varNo;
                }
                ++bbNo;
            }
        }

        private void postAnalyzeBasicBlock(int bbNo, int varNo, FSA a, StateSet set) {
            ITuple tCurr;
            BasicBlock b = this.blocks[bbNo];
            if (!b.isReachable()) {
                return;
            }
            StateSet s = new StateSet(set);
            Var v = this.vars[varNo];
            ITuple tNext = b.getFirstTuple();
            boolean chg = false;
            do {
                tCurr = tNext;
                s = this.changes.apply(v, tCurr, s);
                if (tCurr instanceof AssignmentTuple && tCurr.result() == v) {
                    StateSet sn = this.asgs.find(tCurr);
                    if (sn != null) {
                        s = new StateSet(this.asgs.find(tCurr));
                    } else {
                        System.err.println(" ================ 0 !");
                    }
                }
                a.postStep(v, s, tCurr);
                tNext = tCurr.getNext();
            } while (tCurr != b.getLastTuple());
        }

        /*
         * Unable to fully structure code
         */
        private final boolean analyseAssignmentSets(FSA a) {
            chg = false;
            i = 0;
            ** GOTO lbl19
            {
                t = this.asgs.asgs[i];
                bbNo = ((BasicBlock)t.basicBlock()).getId();
                v = t.result();
                varNo = 0;
                j = 0;
                while (j < this.vars.length) {
                    if (this.vars[j] == v) {
                        varNo = j;
                        break;
                    }
                    ++j;
                }
                chg |= this.analyseBasicBlock(bbNo, varNo, a, (FSAState)var4_4, t);
                do {
                    if ((s = this.asgs.transferInfo[i].getRecent()) != null) continue block0;
                    ++i;
lbl19:
                    // 2 sources

                } while (i < this.asgs.transferInfo.length);
            }
            return chg;
        }

        private final boolean analyseBasicBlock(int bbNo, int varNo, FSA a, FSAState state, ITuple tStart) {
            ITuple tCurr;
            BasicBlock b = this.blocks[bbNo];
            if (!b.isReachable()) {
                return false;
            }
            Var v = this.vars[varNo];
            ITuple tNext = tStart == null ? b.getFirstTuple() : tStart;
            FSAState s = state;
            boolean chg = false;
            do {
                FSAState s0;
                if (this.changes.find(v, tCurr = tNext, s)) {
                    return chg;
                }
                if (tCurr instanceof AssignmentTuple) {
                    StateSet ss;
                    if (tCurr.operand(0) == v && (ss = this.asgs.find(tCurr)) != null) {
                        chg |= ss.addItem(s);
                    }
                    if (tCurr != tStart && tCurr.result() == v) {
                        a.endOfPath(s, tCurr);
                        return chg;
                    }
                }
                if ((s0 = s) != (s = a.step(v, s, tCurr))) {
                    this.changes.record(v, tCurr, s0, s);
                    chg = true;
                }
                tNext = tCurr.getNext();
            } while (tCurr != b.getLastTuple());
            IBasicBlock[] succ = b.getSuccessors();
            if (succ != null) {
                if (tCurr instanceof IfTuple) {
                    FSAState sTrue = a.stepTrue(v, s, tCurr);
                    FSAState sFalse = a.stepFalse(v, s, tCurr);
                    chg |= this.setTargetState(varNo, sTrue, tCurr, 0);
                    chg |= this.setTargetState(varNo, sFalse, tCurr, 1);
                } else if (tCurr instanceof SwitchTuple) {
                    ITuple[] targets = tCurr.targets();
                    int i = 0;
                    while (i < targets.length) {
                        FSAState ts = a.stepSwitch(v, s, tCurr, i);
                        chg |= this.setTargetState(varNo, ts, tCurr, i);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < succ.length) {
                        int succId = ((BasicBlock)succ[i]).getId();
                        chg |= this.in[succId][varNo].addItem(s);
                        ++i;
                    }
                }
            } else if (this.resVarIdx == varNo && bbNo == this.blocks.length - 1) {
                this.resultSet.addItem(s);
            }
            return chg;
        }

        private final boolean setTargetState(int varNo, FSAState s, ITuple t, int targetNo) {
            int tId = ((BasicBlock)t.target(targetNo).basicBlock()).getId();
            return this.in[tId][varNo].addItem(s);
        }

        MethodContext(Method m, FSA a) {
            DataFlowGraph dfa = m.getDFG();
            if (dfa == null) {
                return;
            }
            ValueTable vt = (ValueTable)dfa.getValueTable();
            int nBasicBlocks = 0;
            IBasicBlock bb = dfa.getBasicBlockList();
            while (bb != null) {
                ++nBasicBlocks;
                bb = bb.getNext();
            }
            Var[] allVars = vt.getVariables();
            int nVars = 0;
            int i = 0;
            while (i < allVars.length) {
                if (FSAAnalyzer.this.automaton.applicable(allVars[i])) {
                    ++nVars;
                }
                ++i;
            }
            this.vars = new Var[nVars];
            this.resVarIdx = -1;
            int j = 0;
            int i2 = 0;
            while (i2 < allVars.length) {
                if (FSAAnalyzer.this.automaton.applicable(allVars[i2])) {
                    if (allVars[i2] == vt.getResultVar()) {
                        this.resVarIdx = j;
                    }
                    this.vars[j++] = allVars[i2];
                }
                ++i2;
            }
            this.blocks = new BasicBlock[nBasicBlocks];
            this.in = new StateSet[nBasicBlocks][];
            int i3 = 0;
            IBasicBlock bb2 = dfa.getBasicBlockList();
            while (bb2 != null) {
                this.in[i3] = new StateSet[nVars];
                int j2 = 0;
                while (j2 < nVars) {
                    this.in[i3][j2] = new StateSet();
                    ++j2;
                }
                this.blocks[i3++] = (BasicBlock)bb2;
                bb2 = bb2.getNext();
            }
            if (this.resVarIdx != -1) {
                this.resultSet = new StateSet();
            }
            this.changes = new ChangeSet();
            this.asgs = new AssignmentInfo(this.vars, dfa.getTupleList(), a);
        }

        class ChangeSet {
            ChangeItem[] items = new ChangeItem[50];
            int used = 0;
            private static final int initSize = 50;
            private static final int extSize = 20;

            ChangeSet() {
            }

            StateSet apply(Var v, ITuple t, StateSet set) {
                int i = 0;
                while (i < this.used) {
                    ChangeItem it = this.items[i];
                    if (v == it.v && t == it.t) {
                        set.playChange(it.from, it.to);
                    }
                    ++i;
                }
                return set;
            }

            boolean find(Var v, ITuple t, FSAState from) {
                int i = 0;
                while (i < this.used) {
                    ChangeItem it = this.items[i];
                    if (v == it.v && t == it.t && from.equals(it.from)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            void record(Var v, ITuple t, FSAState from, FSAState to) {
                if (this.used == this.items.length) {
                    ChangeItem[] newItems = new ChangeItem[this.used + 20];
                    System.arraycopy(this.items, 0, newItems, 0, this.used);
                    this.items = newItems;
                }
                this.items[this.used] = new ChangeItem(v, t, from, to);
                ++this.used;
            }

            class ChangeItem {
                Var v;
                ITuple t;
                FSAState from;
                FSAState to;

                ChangeItem(Var v, ITuple t, FSAState from, FSAState to) {
                    this.v = v;
                    this.t = t;
                    this.from = from;
                    this.to = to;
                }
            }
        }

        class AssignmentInfo {
            ITuple[] asgs;
            StateSet[] transferInfo;

            final boolean isIn(Var[] vars, Var v) {
                int i = 0;
                while (i < vars.length) {
                    if (vars[i] == v) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            AssignmentInfo(Var[] vars, ITuple tList, FSA a) {
                int nAsgs = 0;
                ITuple t = tList;
                while (t != null) {
                    if (t instanceof AssignmentTuple && this.isIn(vars, (Var)t.result())) {
                        ++nAsgs;
                    }
                    t = t.getNext();
                }
                int cAsg = 0;
                this.asgs = new ITuple[nAsgs];
                this.transferInfo = new StateSet[nAsgs];
                ITuple t2 = tList;
                while (t2 != null) {
                    if (t2 instanceof AssignmentTuple && this.isIn(vars, (Var)t2.result())) {
                        this.asgs[cAsg] = t2;
                        this.transferInfo[cAsg] = new StateSet();
                        if (!(t2.operand(0) instanceof Var) || !this.isIn(vars, (Var)t2.operand(0))) {
                            this.transferInfo[cAsg].addItem(a.start((Var)t2.result(), t2));
                        }
                        ++cAsg;
                    }
                    t2 = t2.getNext();
                }
            }

            final void addState(ITuple t, FSAState s) {
                int i = 0;
                while (i < this.asgs.length) {
                    if (this.asgs[i] == t) {
                        this.transferInfo[i].addItem(s);
                        break;
                    }
                    ++i;
                }
            }

            final void addResultState(ITuple t, FSAState s) {
                if (t instanceof ExprTuple) {
                    ExprTuple et = (ExprTuple)t;
                    IVar v = et.result();
                    int i = 0;
                    while (i < this.asgs.length) {
                        if (this.asgs[i].operand(0) == v) {
                            this.transferInfo[i].addItem(s);
                            break;
                        }
                        ++i;
                    }
                }
            }

            final StateSet find(ITuple t) {
                int i = 0;
                while (i < this.asgs.length) {
                    if (this.asgs[i] == t) {
                        return this.transferInfo[i];
                    }
                    ++i;
                }
                return null;
            }
        }
    }
}

