/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.flowgraph.BasicBlock;
import com.togethersoft.sca.internal.dataflow.flowgraph.DataFlowGraph;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;

public abstract class VarArgsTuple
extends ExprTuple {
    private static final Method[] emptyMethodSet = new Method[0];
    private static final AstDeclaration[] emptyDeclSet = new AstDeclaration[0];

    public final void setOperand(int operandNumber, IVal value) {
        this.operand[operandNumber] = value;
    }

    public AstDeclaration getCalledDeclaration() {
        AstObject a = this.getAstObject();
        if (!(a instanceof AstReference)) {
            throw new Error("***** bad node");
        }
        AstDeclaration d = ((AstReference)a).getReferencedElement();
        return d;
    }

    public Method getCalledMethod() {
        AstMethod m = (AstMethod)this.getCalledDeclaration();
        if (m == null) {
            return null;
        }
        Project p = ((DataFlowGraph)((BasicBlock)this.basicBlock).getCFG()).getProject();
        return p.getFor(m);
    }

    public AstDeclaration[] getCalledDeclarations() {
        AstMethod m = (AstMethod)this.getCalledDeclaration();
        if (m == null) {
            return emptyDeclSet;
        }
        AstMethod[] om = m.overriddenBy();
        if (om.length != 0) {
            AstDeclaration[] ad = new AstDeclaration[om.length + 1];
            ad[0] = m;
            System.arraycopy(om, 0, ad, 1, om.length);
            return ad;
        }
        return new AstDeclaration[]{m};
    }

    public Method[] getCalledMethods() {
        Method m = this.getCalledMethod();
        if (m == null) {
            return emptyMethodSet;
        }
        if (m.overrideClosure != null) {
            return m.overrideClosure;
        }
        AstDeclaration[] decls = this.getCalledDeclarations();
        if (decls.length == 0) {
            m.overrideClosure = emptyMethodSet;
            return emptyMethodSet;
        }
        Method[] meths = new Method[decls.length];
        Project p = ((DataFlowGraph)((BasicBlock)this.basicBlock).getCFG()).getProject();
        int i = 0;
        while (i < decls.length) {
            meths[i] = p.getFor((AstMethod)decls[i]);
            ++i;
        }
        m.overrideClosure = meths;
        return meths;
    }

    public void propagateInterprocedural() {
        if (this.operand != null) {
            Method[] meths = this.getCalledMethods();
            int i = 0;
            while (i < meths.length) {
                int off;
                int j = off = this.getCode() == 27 ? 1 : 0;
                while (j < this.operand.length) {
                    try {
                        meths[i].updateParameterDomain(j - off, this.operandValue(j));
                    }
                    catch (Throwable e) {
                        this.print(System.err);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected VarArgsTuple(int arity, ITuple prevTuple, AstExpression associatedObject) {
        super(prevTuple, associatedObject);
        if (arity != 0) {
            this.operand = new IVal[arity];
        }
    }

    protected VarArgsTuple(int arity, int backEndTypeValue, ITuple prevTuple, AstObject associatedObject) {
        super(backEndTypeValue, prevTuple, associatedObject);
        if (arity != 0) {
            this.operand = new IVal[arity];
        }
    }
}

