/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.flowgraph.BasicBlock;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintTable;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ReferenceToAst;
import com.togethersoft.sca.internal.dataflow.values.ObjectDomain;
import com.togethersoft.sca.internal.dataflow.values.TypeConstant;
import com.togethersoft.sca.internal.dataflow.values.Val;
import java.io.PrintStream;

public abstract class Tuple
extends ReferenceToAst
implements ITuple {
    private int tupleId;
    private Tuple prev;
    private Tuple next;
    protected IBasicBlock basicBlock;
    protected IVal[] operand;
    private IValueDomain[] operandValue;
    private IVar[][] operandsSymbolicValues;
    private int mask;
    private static final int tupleIsUsed = 1;
    private static final int assertGenerated = 2;

    public abstract int getCode();

    public IVal[] operands() {
        return this.operand;
    }

    public int nOperands() {
        if (this.operand == null) {
            return 0;
        }
        return this.operand.length;
    }

    public IVal operand(int operandNumber) {
        return this.operand[operandNumber];
    }

    public IValueDomain[] operandValues() {
        return this.operandValue;
    }

    public IValueDomain operandValue(int operandNumber) {
        return this.operandValue[operandNumber];
    }

    public IVar[][] operandsSymbolicValues() {
        return this.operandsSymbolicValues;
    }

    public IVar[] operandSymbolicValues(int operandNumber) {
        if (this.operandsSymbolicValues == null) {
            return null;
        }
        return this.operandsSymbolicValues[operandNumber];
    }

    public boolean hasSymbolicValue(IVal v, int operandNumber) {
        if (v == this.operand[operandNumber]) {
            return true;
        }
        IVar[] vars = this.operandSymbolicValues(operandNumber);
        if (vars != null) {
            int i = 0;
            while (i < vars.length) {
                if (v == vars[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public IVar operandSymbolicValue(int operandNumber, int valueNumber) {
        if (this.operandsSymbolicValues == null || this.operandsSymbolicValues[operandNumber] == null) {
            return null;
        }
        return this.operandsSymbolicValues[operandNumber][valueNumber];
    }

    public boolean addOperandSymbolicValue(IVar value, int operandNumber) {
        if (this.operandsSymbolicValues == null) {
            this.operandsSymbolicValues = new IVar[this.operand.length][];
        }
        if (this.operandsSymbolicValues[operandNumber] == null) {
            this.operandsSymbolicValues[operandNumber] = new IVar[1];
            this.operandsSymbolicValues[operandNumber][0] = value;
        } else {
            IVar[] values = this.operandsSymbolicValues[operandNumber];
            int i = 0;
            while (i < values.length) {
                if (values[i] == value) {
                    return false;
                }
                ++i;
            }
            IVar[] newValues = new IVar[values.length + 1];
            int i2 = 0;
            while (i2 < values.length) {
                newValues[i2] = values[i2];
                ++i2;
            }
            newValues[values.length] = value;
            this.operandsSymbolicValues[operandNumber] = newValues;
        }
        return true;
    }

    public void clearOperandsSymbolicValues() {
        this.operandsSymbolicValues = null;
    }

    public abstract ITuple[] targets();

    public abstract ITuple target(int var1);

    public abstract IVar result();

    public abstract IValueDomain resultValue();

    public IBasicBlock basicBlock() {
        return this.basicBlock;
    }

    public abstract boolean isTarget();

    public abstract boolean transfersControl();

    public ITuple getNext() {
        return this.next;
    }

    public ITuple getPrev() {
        return this.prev;
    }

    public void insertAfter(ITuple prevTuple) {
        this.prev = (Tuple)prevTuple;
        this.next = (Tuple)this.prev.getNext();
        this.prev.next = this;
        if (this.next != null) {
            this.next.prev = this;
        }
    }

    public void removeFromList() {
        if (this.prev != null) {
            this.prev.next = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
        this.next = null;
        this.prev = null;
    }

    public void print(PrintStream out) {
        AstObject astObject = this.getAstObject();
        out.print("Tuple #" + this.tupleId + " runtime type =");
        if (astObject != null) {
            if (astObject instanceof AstExpression) {
                AstExpression astExpr = (AstExpression)astObject;
                if (astExpr.getRuntimeType() != null) {
                    out.print(" " + astExpr.getRuntimeType().getTypeName());
                } else {
                    out.print("### astObject has null Runtime type !!!###");
                }
            } else {
                out.print("[no value]");
            }
        } else {
            out.print("### astObject == null !!!###");
        }
        out.println(" prev =" + (this.prev == null ? -1 : this.prev.getTupleId()) + " next =" + (this.next == null ? -1 : this.next.getTupleId()) + " at line " + this.getStartLine() + ":" + this.getStartColumn() + " file = " + this.getFileName());
        out.println("Code = " + this.getCode() + " (" + this.mnemo() + ") used = " + this.isUsed() + " side effect = " + this.hasSideEffect());
        this.printValues(out, this.operand, "Operands:");
        this.printValues(out, this.operandValue, "Operands Values");
        if (this.operandsSymbolicValues != null) {
            out.println("Operands Symbolic Values:");
            int i = 0;
            while (i < this.operandsSymbolicValues.length) {
                IVar[] values = this.operandsSymbolicValues[i];
                out.print(" . For operand[" + i + "] ");
                if (values != null) {
                    int j = 0;
                    while (j < values.length) {
                        if (j != 0) {
                            out.print(",");
                        }
                        if (values[j] != null) {
                            ((Var)values[j]).printBrief(out);
                        } else {
                            out.println("########### NULL  " + j + " VALUE !");
                        }
                        ++j;
                    }
                    out.println();
                } else {
                    out.println("<EMPTY>");
                }
                ++i;
            }
            out.println();
        }
    }

    private void printValues(PrintStream out, IVal[] value, String text) {
        if (value != null) {
            out.println(text);
            int i = 0;
            while (i < value.length) {
                if (i != 0) {
                    out.print(",");
                }
                if (value[i] != null) {
                    ((Val)value[i]).printBrief(out);
                } else {
                    out.println("########### NULL OPERAND " + i);
                }
                ++i;
            }
            out.println();
        }
    }

    private void printValues(PrintStream out, IValueDomain[] value, String text) {
        if (value != null) {
            out.println(text);
            int i = 0;
            while (i < value.length) {
                if (i != 0) {
                    out.print(",");
                }
                if (value[i] != null) {
                    value[i].printBrief(out);
                } else {
                    out.println("########### NULL OPERAND " + i);
                }
                ++i;
            }
            out.println();
        }
    }

    public abstract String mnemo();

    public final int getTupleId() {
        return this.tupleId;
    }

    public final boolean isUsed() {
        return (this.mask & 1) != 0;
    }

    public boolean hasSideEffect() {
        return false;
    }

    public boolean allOperandValuesAreConstant() {
        if (this.operandValue != null) {
            int i = 0;
            while (i < this.operandValue.length) {
                if (this.operandValue[i] == null || !this.operandValue[i].isConstant()) {
                    return false;
                }
                ++i;
            }
        } else {
            return this.operand == null;
        }
        return true;
    }

    public boolean isConstant() {
        AstObject ast = this.getAstObject();
        if (ast instanceof AstExpression) {
            return ((AstExpression)ast).isConstant();
        }
        return false;
    }

    public void setAsUnused() {
        this.mask &= 0xFFFFFFFE;
    }

    public void setAsUsed() {
        this.mask |= 1;
    }

    public boolean isAssertGenerated() {
        return (this.mask & 2) != 0;
    }

    public void setAsAssertGenerated() {
        this.mask |= 2;
    }

    public final void setTupleId(int idValue) {
        this.tupleId = idValue;
    }

    public abstract void propagateValues();

    public void setBasicBlock(IBasicBlock basicBlockValue) {
        this.basicBlock = basicBlockValue;
    }

    public void computeConstraints(ConstraintTable table) {
    }

    public void markReachableBlocks() {
        ITuple nextTuple = this.getNext();
        if (nextTuple != null) {
            nextTuple.basicBlock().setAsReachable();
        }
    }

    public AstTypeReference getTypeReference() {
        return null;
    }

    protected IValueDomain updateOperandValue(int operandNumber) {
        IVal val = this.operand(operandNumber);
        IValueDomain value = null;
        if (val.getValueKind() == 1) {
            Var var = (Var)val;
            value = ((BasicBlock)this.basicBlock).getCurrentValue(var);
            if (value == null) {
                value = var.defaultDomain();
            }
        } else {
            value = val instanceof TypeConstant ? ObjectDomain.getDefault(((TypeConstant)val).getValue()) : (IValueDomain)((Object)val);
        }
        if (this.operandValue == null) {
            this.operandValue = new IValueDomain[this.operand.length];
        }
        this.operandValue[operandNumber] = value;
        return value;
    }

    protected void setupOperands(IVal leftOperand, IVal rightOperand) {
        this.operand = new IVal[]{leftOperand, rightOperand};
    }

    protected void setupOperand(IVal operandVal) {
        this.operand = new IVal[]{operandVal};
    }

    protected Tuple(ITuple prevTuple, AstObject associatedObject) {
        super(associatedObject);
        if (prevTuple == null) {
            this.prev = null;
            this.next = null;
        } else {
            this.insertAfter(prevTuple);
        }
        this.mask = 1;
    }
}

