/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.dataflow.flowgraph.ITempVariable;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintTable;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ControlTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LabelTuple;

public class SwitchTuple
extends ControlTuple {
    private boolean hasDefaultLabel;

    public String mnemo() {
        return "SWITCH";
    }

    public void propagateValues() {
        int i = 0;
        while (i < this.operand.length) {
            this.updateOperandValue(i);
            ++i;
        }
    }

    public void computeConstraints(ConstraintTable table) {
        block4: {
            int nBranches;
            int opKind;
            IVar v;
            block5: {
                IVal op = this.operand(0);
                if (op.getValueKind() != 1) break block4;
                v = (IVar)op;
                opKind = v.getVariableKind();
                nBranches = this.operands().length;
                if (opKind != 1) break block5;
                ExprTuple t = (ExprTuple)((ITempVariable)v).sourceTuple();
                int i = 1;
                while (i < nBranches) {
                    if (this.target(i) != this.target(0)) {
                        ConstraintCollection coll = new ConstraintCollection();
                        t.constrain(this.operandValue(i), coll);
                        table.include(this.target(i).basicBlock(), coll);
                    }
                    ++i;
                }
                break block4;
            }
            if (opKind != 2 && opKind != 3) break block4;
            int varIdx = ((Var)v).getVarIndex();
            int i = 1;
            while (i < nBranches) {
                if (this.target(i) != this.target(0)) {
                    table.include(this.target(i).basicBlock(), varIdx, this.operandValue(i));
                }
                ++i;
            }
        }
    }

    public void pushCase(LabelTuple label, IVal expr) {
        int oldLength = this.target.length;
        ITuple[] newTarget = new ITuple[oldLength + 1];
        IVal[] newOperand = new IVal[oldLength + 1];
        int i = 0;
        while (i < oldLength) {
            newTarget[i] = this.target[i];
            newOperand[i] = this.operand[i];
            ++i;
        }
        newTarget[oldLength] = label;
        newOperand[oldLength] = expr;
        this.target = newTarget;
        this.operand = newOperand;
    }

    public void setDefaultLabel(LabelTuple defaultLabel) {
        this.target[0] = defaultLabel;
        this.hasDefaultLabel = true;
    }

    public ITuple defaultLabel() {
        return this.target[0];
    }

    public boolean hasDefault() {
        return this.hasDefaultLabel;
    }

    public void markReachableBlocks() {
        this.target(0).basicBlock().setAsReachable();
        IValueDomain v = this.operandValue(0);
        if (v instanceof IIntegralDomain) {
            IIntegralDomain ds = (IIntegralDomain)v;
            int i = 1;
            while (i < this.targets().length) {
                v = this.operandValue(i);
                if (v instanceof IIntegralDomain) {
                    IIntegralDomain dl = (IIntegralDomain)v;
                    if (ds.getLowValue() <= dl.getHighValue() && ds.getHighValue() >= dl.getLowValue() && (ds.getOnesBitMask() & dl.getZeroBitMask()) == 0L && (dl.getOnesBitMask() & ds.getZeroBitMask()) == 0L) {
                        this.target(i).basicBlock().setAsReachable();
                    }
                } else {
                    this.target(i).basicBlock().setAsReachable();
                }
                ++i;
            }
        } else {
            int i = 1;
            while (i < this.targets().length) {
                this.target(i).basicBlock().setAsReachable();
                ++i;
            }
        }
    }

    public int getCode() {
        return 42;
    }

    public SwitchTuple(IVal expr, ITuple end, ITuple prevTuple, AstObject associatedObject) {
        super(prevTuple, associatedObject);
        this.setupOperand(expr);
        this.target = new ITuple[1];
        this.target[0] = end;
        this.hasDefaultLabel = false;
    }
}

