/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.values.IntegralDomain;

public class MulTuple
extends ExprTuple {
    public String mnemo() {
        return "MUL";
    }

    public void propagateValues() {
        IValueDomain op0 = this.updateOperandValue(0);
        IValueDomain op1 = this.updateOperandValue(1);
        if (this.voidValues()) {
            return;
        }
        IValueDomain res = op0 instanceof IIntegralDomain && op1 instanceof IIntegralDomain ? ((IIntegralDomain)op0).doMUL((IIntegralDomain)op1) : (op0 instanceof IRealDomain && op1 instanceof IRealDomain ? ((IRealDomain)op0).doMUL((IRealDomain)op1) : op0);
        this.setResultValue(res);
    }

    void constrain(IValueDomain value, ConstraintCollection coll) {
        if (!this.goodResult()) {
            return;
        }
        IVal op0 = this.operand(0);
        IValueDomain op0v = this.operandValue(0);
        IVal op1 = this.operand(1);
        IValueDomain op1v = this.operandValue(1);
        if (op0 instanceof IVar) {
            MulTuple.constrain(value, (IVar)op0, op0v, op1v, coll);
        }
        if (op1 instanceof IVar) {
            MulTuple.constrain(value, (IVar)op1, op1v, op0v, coll);
        }
    }

    private static void constrain(IValueDomain value, IVar op0, IValueDomain op0v, IValueDomain op1v, ConstraintCollection coll) {
        if (value instanceof IIntegralDomain) {
            if (op1v.isConstant()) {
                IIntegralDomain resd = (IIntegralDomain)value;
                IIntegralDomain op0d = (IIntegralDomain)op0v;
                IIntegralDomain op1d = (IIntegralDomain)op1v;
                IIntegralDomain d = resd.doDIV(op1d);
                ExprTuple.constrainOperand(op0, IntegralDomain.intersect(d, op0d), coll);
            }
        } else if (value instanceof IRealDomain && op1v.isConstant()) {
            IRealDomain resd = (IRealDomain)value;
            IRealDomain op0d = (IRealDomain)op0v;
            IRealDomain op1d = (IRealDomain)op1v;
            IRealDomain d = resd.doDIV(op1d);
            ExprTuple.constrainOperand(op0, d.meet(op0d), coll);
        }
    }

    public int getCode() {
        return 1;
    }

    public MulTuple(IVal leftOperand, IVal rightOperand, ITuple prevTuple, AstExpression associatedObject) {
        super(prevTuple, associatedObject);
        this.setupOperands(leftOperand, rightOperand);
    }
}

