/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IBooleanConstant;
import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.GE_Tuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.GT_Tuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.LT_Tuple;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import com.togethersoft.sca.internal.dataflow.values.BooleanDomain;
import com.togethersoft.sca.internal.dataflow.values.IntegralDomain;

public class LE_Tuple
extends ExprTuple {
    public String mnemo() {
        return "LE";
    }

    public void propagateValues() {
        IValueDomain op0 = this.updateOperandValue(0);
        IValueDomain op1 = this.updateOperandValue(1);
        if (this.voidValues()) {
            return;
        }
        IBooleanDomain res = this.operand(0) instanceof IVar && this.operand(0).getValueType() != 6 && this.operand(0).getValueType() != 7 && this.operand(1) instanceof IVar && (this.hasSymbolicValue(this.operand(0), 1) || this.hasSymbolicValue(this.operand(1), 0)) ? BooleanConstant.forTrue() : (op0 instanceof IIntegralDomain && op1 instanceof IIntegralDomain ? ((IIntegralDomain)op0).doLE((IIntegralDomain)op1) : (op0 instanceof IRealDomain && op1 instanceof IRealDomain ? ((IRealDomain)op0).doLE((IRealDomain)op1) : BooleanDomain.get()));
        this.setResultValue(res);
    }

    public void constrain(IValueDomain value, ConstraintCollection coll) {
        if (!this.goodResult()) {
            return;
        }
        if (!(value instanceof IBooleanConstant)) {
            return;
        }
        boolean rv = ((IBooleanConstant)value).getValue();
        IVal op0 = this.operand(0);
        IValueDomain op0v = this.operandValue(0);
        IVal op1 = this.operand(1);
        IValueDomain op1v = this.operandValue(1);
        if (op0 instanceof IVar) {
            if (rv) {
                LE_Tuple.constrainForLe((IVar)op0, op0v, op1v, coll);
            } else {
                GT_Tuple.constrainForGt((IVar)op0, op0v, op1v, coll);
            }
        }
        if (op1 instanceof IVar) {
            if (rv) {
                GE_Tuple.constrainForGe((IVar)op1, op1v, op0v, coll);
            } else {
                LT_Tuple.constrainForLt((IVar)op1, op1v, op0v, coll);
            }
        }
    }

    static void constrainForLe(IVar op0, IValueDomain op0v, IValueDomain op1v, ConstraintCollection coll) {
        if (op0v == null || op1v == null) {
            return;
        }
        switch (op0.getValueType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (!(op0v instanceof IIntegralDomain) || !(op1v instanceof IIntegralDomain)) break;
                IIntegralDomain idm0 = (IIntegralDomain)op0v;
                IIntegralDomain idm1 = (IIntegralDomain)op1v;
                long tLow = idm1.minTypeValue();
                long tHigh = idm1.getHighValue();
                ExprTuple.constrainOperand(op0, IntegralDomain.intersect(idm0, tLow, tHigh), coll);
                break;
            }
            case 6: 
            case 7: {
                IRealDomain rdm0 = (IRealDomain)op0v;
                IRealDomain rdm1 = (IRealDomain)op1v;
                double tLow = rdm1.minTypeValue();
                double tHigh = rdm1.getHighValue();
                ExprTuple.constrainOperand(op0, rdm0.intersect(tLow, tHigh), coll);
                break;
            }
        }
    }

    public int getCode() {
        return 17;
    }

    public LE_Tuple(IVal leftOperand, IVal rightOperand, ITuple prevTuple, AstExpression associatedObject) {
        super(8, prevTuple, associatedObject);
        this.setupOperands(leftOperand, rightOperand);
    }
}

