/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.flowgraph.ITempVariable;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintTable;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ControlTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;

public class IfTuple
extends ControlTuple {
    public String mnemo() {
        return "IF";
    }

    public void propagateValues() {
        this.updateOperandValue(0);
    }

    public void computeConstraints(ConstraintTable table) {
        IBasicBlock noBranch;
        IBasicBlock yesBranch = this.target[0].basicBlock();
        if (yesBranch == (noBranch = this.target[1].basicBlock())) {
            return;
        }
        IVal op = this.operand(0);
        if (op.getValueKind() == 1) {
            IVar v = (IVar)op;
            int opKind = v.getVariableKind();
            if (opKind == 1) {
                ExprTuple t = (ExprTuple)((ITempVariable)v).sourceTuple();
                ConstraintCollection coll = new ConstraintCollection();
                t.constrain(BooleanConstant.forTrue(), coll);
                table.include(yesBranch, coll);
                coll = new ConstraintCollection();
                t.constrain(BooleanConstant.forFalse(), coll);
                table.include(noBranch, coll);
            } else if (opKind == 2 || opKind == 3) {
                int varIdx = ((Var)v).getVarIndex();
                table.include(yesBranch, varIdx, BooleanConstant.forTrue());
                table.include(noBranch, varIdx, BooleanConstant.forFalse());
            }
        }
    }

    public void markReachableBlocks() {
        IValueDomain opVal = this.operandValue(0);
        if (opVal instanceof BooleanConstant) {
            if (((BooleanConstant)opVal).getValue()) {
                this.target(0).basicBlock().setAsReachable();
            } else {
                this.target(1).basicBlock().setAsReachable();
            }
        } else {
            this.target(0).basicBlock().setAsReachable();
            this.target(1).basicBlock().setAsReachable();
        }
    }

    public int getCode() {
        return 41;
    }

    public IfTuple(IVal condVal, ITuple yesBranch, ITuple noBranch, ITuple prevTuple, AstObject associatedObject) {
        super(prevTuple, associatedObject);
        this.setupOperand(condVal);
        this.target = new ITuple[2];
        this.target[0] = yesBranch;
        this.target[1] = noBranch;
    }
}

