/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstAssertStatement;
import com.togethersoft.sca.ast.AstConstructorInvocation;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectCreationExpression;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.dataflow.flowgraph.ITempVariable;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.flowgraph.BasicBlock;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import com.togethersoft.sca.internal.dataflow.flowgraph.ControlFlowGraph;
import com.togethersoft.sca.internal.dataflow.flowgraph.TempVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.ValueTable;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;
import com.togethersoft.sca.internal.dataflow.values.BadDomain;
import com.togethersoft.sca.internal.dataflow.values.ValueDomain;
import java.io.PrintStream;

public abstract class ExprTuple
extends Tuple {
    private IVar result;
    private IValueDomain resultValue;
    private int backEndType;

    public boolean isTarget() {
        return false;
    }

    public boolean transfersControl() {
        return false;
    }

    public ITuple[] targets() {
        return null;
    }

    public ITuple target(int targetNumber) {
        return null;
    }

    public IVar result() {
        return this.result;
    }

    public IValueDomain resultValue() {
        return this.resultValue;
    }

    public boolean hasSideEffect() {
        if (this.result != null) {
            TempVariable tv;
            int kind = this.result.getVariableKind();
            if (kind != 2 && kind != 3 && kind != 1) {
                return true;
            }
            if (kind == 1 && (tv = (TempVariable)this.result).sourceTuple() != this) {
                return true;
            }
        }
        if (this.getCode() == 27 || this.getCode() == 29) {
            AstObject o = this.getAstObject();
            AstDeclaration d = null;
            Method m = null;
            if (o instanceof AstMethodCallExpression) {
                d = ((AstMethodCallExpression)o).getReferencedElement();
            } else if (o instanceof AstConstructorInvocation) {
                d = ((AstConstructorInvocation)o).getReferencedElement();
            } else if (o instanceof AstObjectCreationExpression) {
                d = ((AstObjectCreationExpression)o).getReferencedElement();
            }
            if (d == null) {
                return true;
            }
            Project prj = ((ControlFlowGraph)this.basicBlock.getCFG()).getProject();
            if (d instanceof AstMethod) {
                m = prj.getFor((AstMethod)d);
            } else if (d instanceof AstInitializer) {
                m = prj.getFor((AstInitializer)d);
            }
            if (m == null) {
                return true;
            }
            return m.hasSideEffect();
        }
        return false;
    }

    public void print(PrintStream out) {
        super.print(out);
        if (this.result != null) {
            out.println("Result:");
            ((Var)this.result).printBrief(out);
            out.println();
        }
        if (this.resultValue != null) {
            out.println("Result value:");
            this.resultValue.printBrief(out);
            out.println();
        }
    }

    public final void setResultVar(IVar var) {
        this.result = var;
    }

    public final void setResultValue(IValueDomain value) {
        ((BasicBlock)this.basicBlock).setCurrentValue(this.result, value);
        this.resultValue = value;
    }

    final IValueDomain getResultValue() {
        return ((BasicBlock)this.basicBlock).getCurrentValue(this.result);
    }

    public AstTypeReference getTypeReference() {
        AstObject astObject = this.getAstObject();
        if (astObject != null) {
            if (astObject instanceof AstExpression) {
                return ((AstExpression)astObject).getRuntimeType();
            }
            if (astObject instanceof AstAssertStatement) {
                AstAssertStatement as = (AstAssertStatement)astObject;
                return as.getReferencedElement().getDeclaringType();
            }
            if (astObject instanceof AstVariable) {
                AstVariable dcl = (AstVariable)astObject;
                return dcl.getType();
            }
        }
        return null;
    }

    public int backEndType() {
        return this.backEndType;
    }

    abstract void constrain(IValueDomain var1, ConstraintCollection var2);

    protected static void constrainOperand(IVar op, IValueDomain value, ConstraintCollection coll) {
        int varKind = op.getVariableKind();
        int varIdx = ((Var)op).getVarIndex();
        if (varKind == 1) {
            ExprTuple t = (ExprTuple)((ITempVariable)op).sourceTuple();
            t.constrain(value, coll);
        } else if (varKind == 2 || varKind == 3) {
            coll.push(varIdx, value);
        }
    }

    protected boolean voidValues() {
        boolean haveBad = false;
        boolean haveEmpty = false;
        int i = this.nOperands();
        while (--i >= 0) {
            IValueDomain v = this.operandValue(i);
            if (v == null) continue;
            if (v.getValueType() == 0) {
                haveBad = true;
                continue;
            }
            if (!v.isEmpty()) continue;
            haveEmpty = true;
        }
        if (haveBad) {
            this.setResultValue(BadDomain.instance());
            return true;
        }
        if (haveEmpty) {
            this.setResultValue(ValueDomain.getEmpty(this.backEndType, this.getTypeReference()));
            return true;
        }
        return false;
    }

    protected boolean goodResult() {
        return this.resultValue() != null && this.resultValue().getValueType() != 0;
    }

    protected ExprTuple(int backEndTypeValue, ITuple prevTuple, AstObject associatedObject) {
        super(prevTuple, associatedObject);
        this.backEndType = backEndTypeValue;
    }

    protected ExprTuple(ITuple prevTuple, AstExpression associatedObject) {
        super(prevTuple, associatedObject);
        this.backEndType = ValueTable.translateType(associatedObject.getType());
        this.setAsUnused();
    }
}

