/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.values.BadDomain;
import com.togethersoft.sca.internal.dataflow.values.BooleanDomain;
import com.togethersoft.sca.internal.dataflow.values.ByteConstant;
import com.togethersoft.sca.internal.dataflow.values.CharConstant;
import com.togethersoft.sca.internal.dataflow.values.DoubleConstant;
import com.togethersoft.sca.internal.dataflow.values.DoubleDomain;
import com.togethersoft.sca.internal.dataflow.values.FloatConstant;
import com.togethersoft.sca.internal.dataflow.values.FloatDomain;
import com.togethersoft.sca.internal.dataflow.values.IntConstant;
import com.togethersoft.sca.internal.dataflow.values.IntegralDomain;
import com.togethersoft.sca.internal.dataflow.values.LongConstant;
import com.togethersoft.sca.internal.dataflow.values.ObjectConstant;
import com.togethersoft.sca.internal.dataflow.values.ObjectDomain;
import com.togethersoft.sca.internal.dataflow.values.RealDomain;
import com.togethersoft.sca.internal.dataflow.values.ShortConstant;

public class CastTuple
extends ExprTuple {
    public String mnemo() {
        return "CAST";
    }

    public void propagateValues() {
        IValueDomain op0 = this.updateOperandValue(0);
        IValueDomain v = null;
        if (this.voidValues()) {
            return;
        }
        block0 : switch (this.backEndType()) {
            case 1: {
                switch (op0.getValueType()) {
                    case 1: {
                        v = op0;
                        break block0;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (op0.isConstant()) {
                            long val = ((IIntegralDomain)op0).getLowValue();
                            v = new ByteConstant((byte)val);
                            break block0;
                        }
                        IntegralDomain opd = (IntegralDomain)op0;
                        long newLowValue = opd.getLowValue();
                        long newHighValue = opd.getHighValue();
                        if (newLowValue < -128L) {
                            newLowValue = -128L;
                        }
                        if (newHighValue > 127L) {
                            newHighValue = 127L;
                        }
                        v = IntegralDomain.build(1, newLowValue, newHighValue, opd.getZeroBitMask() & 0xFFL, opd.getOnesBitMask() & 0xFFL, false);
                        break block0;
                    }
                    case 6: 
                    case 7: {
                        if (op0.isConstant()) {
                            double val = ((IRealDomain)op0).getLowValue();
                            v = new ByteConstant((byte)val);
                            break block0;
                        }
                        RealDomain opd = (RealDomain)op0;
                        long newLowValue = -128.0 >= opd.getLowValue() ? -128L : (long)((byte)opd.getLowValue());
                        long newHighValue = 127.0 <= opd.getHighValue() ? 127L : (long)((byte)opd.getHighValue());
                        v = IntegralDomain.build(1, newLowValue, newHighValue, 0L, 0L, false);
                        break block0;
                    }
                }
                v = new IntegralDomain(1);
                break;
            }
            case 3: {
                switch (op0.getValueType()) {
                    case 3: {
                        v = op0;
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        if (op0.isConstant()) {
                            long val = ((IIntegralDomain)op0).getLowValue();
                            v = new CharConstant((byte)val);
                            break block0;
                        }
                        IntegralDomain opd = (IntegralDomain)op0;
                        long newLowValue = opd.getLowValue();
                        long newHighValue = opd.getHighValue();
                        long newZeroBitMask = opd.getZeroBitMask() & 0xFFFFL;
                        long newOnesBitMask = opd.getOnesBitMask() & 0xFFFFL;
                        if (newLowValue < 0L) {
                            newLowValue = 0L;
                        }
                        if (newHighValue > 65535L) {
                            newHighValue = 65535L;
                        }
                        newZeroBitMask = op0.getValueType() == 1 ? (newZeroBitMask |= 0xFFFFFFFFFFFFFF80L) : (newZeroBitMask |= 0xFFFFFFFFFFFF0000L);
                        v = IntegralDomain.build(3, newLowValue, newHighValue, newZeroBitMask, newOnesBitMask, false);
                        break block0;
                    }
                    case 6: 
                    case 7: {
                        if (op0.isConstant()) {
                            double val = ((IRealDomain)op0).getLowValue();
                            v = new CharConstant((byte)val);
                            break block0;
                        }
                        RealDomain opd = (RealDomain)op0;
                        long newLowValue = 0.0 >= opd.getLowValue() ? 0L : (long)((char)opd.getLowValue());
                        long newHighValue = 65535.0 <= opd.getHighValue() ? 65535L : (long)((char)opd.getHighValue());
                        v = IntegralDomain.build(3, newLowValue, newHighValue, 0L, 0L, false);
                        break block0;
                    }
                }
                v = new IntegralDomain(3);
                break;
            }
            case 2: {
                switch (op0.getValueType()) {
                    case 2: {
                        v = op0;
                        break block0;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (op0.isConstant()) {
                            long val = ((IIntegralDomain)op0).getLowValue();
                            v = new ShortConstant((short)val);
                            break block0;
                        }
                        IntegralDomain opd = (IntegralDomain)op0;
                        long newLowValue = opd.getLowValue();
                        long newHighValue = opd.getHighValue();
                        long newZeroBitMask = opd.getZeroBitMask() & 0xFFFFL;
                        long newOnesBitMask = opd.getOnesBitMask() & 0xFFFFL;
                        if (newLowValue < -32768L) {
                            newLowValue = -32768L;
                        }
                        if (newHighValue > 32767L) {
                            newHighValue = 32767L;
                        }
                        if (newLowValue >= 0L) {
                            newZeroBitMask = op0.getValueType() == 1 ? (newZeroBitMask |= 0xFFFFFFFFFFFFFF80L) : (newZeroBitMask |= 0xFFFFFFFFFFFF8000L);
                        }
                        v = IntegralDomain.build(2, newLowValue, newHighValue, newZeroBitMask, newOnesBitMask, false);
                        break block0;
                    }
                    case 6: 
                    case 7: {
                        if (op0.isConstant()) {
                            double val = ((IRealDomain)op0).getLowValue();
                            v = new ShortConstant((short)val);
                            break block0;
                        }
                        RealDomain opd = (RealDomain)op0;
                        long newLowValue = -32768.0 >= opd.getLowValue() ? -32768L : (long)((short)opd.getLowValue());
                        long newHighValue = 32767.0 <= opd.getHighValue() ? 32767L : (long)((short)opd.getHighValue());
                        v = IntegralDomain.build(2, newLowValue, newHighValue, 0L, 0L, false);
                        break block0;
                    }
                }
                v = new IntegralDomain(2);
                break;
            }
            case 4: {
                switch (op0.getValueType()) {
                    case 4: {
                        v = op0;
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: {
                        if (op0.isConstant()) {
                            long val = ((IIntegralDomain)op0).getLowValue();
                            v = new IntConstant((int)val);
                            break block0;
                        }
                        IntegralDomain opd = (IntegralDomain)op0;
                        long newLowValue = opd.getLowValue();
                        long newHighValue = opd.getHighValue();
                        long newZeroBitMask = opd.getZeroBitMask() & 0xFFFFFFFFL;
                        long newOnesBitMask = opd.getOnesBitMask() & 0xFFFFFFFFL;
                        if (newLowValue < Integer.MIN_VALUE) {
                            newLowValue = Integer.MIN_VALUE;
                        }
                        if (newHighValue > Integer.MAX_VALUE) {
                            newHighValue = Integer.MAX_VALUE;
                        }
                        if (newLowValue >= 0L) {
                            newZeroBitMask = op0.getValueType() == 1 ? (newZeroBitMask |= 0xFFFFFFFFFFFFFF80L) : (op0.getValueType() == 2 ? (newZeroBitMask |= 0xFFFFFFFFFFFF8000L) : (op0.getValueType() == 3 ? (newZeroBitMask |= 0xFFFFFFFFFFFF0000L) : (newZeroBitMask |= Integer.MIN_VALUE)));
                        }
                        v = IntegralDomain.build(4, newLowValue, newHighValue, newZeroBitMask, newOnesBitMask, false);
                        break block0;
                    }
                    case 6: 
                    case 7: {
                        if (op0.isConstant()) {
                            double val = ((IRealDomain)op0).getLowValue();
                            v = new IntConstant((int)val);
                            break block0;
                        }
                        RealDomain opd = (RealDomain)op0;
                        long newLowValue = -2.147483648E9 >= opd.getLowValue() ? Integer.MIN_VALUE : (long)((int)opd.getLowValue());
                        long newHighValue = 2.147483647E9 <= opd.getHighValue() ? Integer.MAX_VALUE : (long)((int)opd.getHighValue());
                        v = IntegralDomain.build(4, newLowValue, newHighValue, 0L, 0L, false);
                        break block0;
                    }
                }
                v = new IntegralDomain(4);
                break;
            }
            case 5: {
                switch (op0.getValueType()) {
                    case 5: {
                        v = op0;
                        break block0;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (op0.isConstant()) {
                            long val = ((IIntegralDomain)op0).getLowValue();
                            v = new LongConstant(val);
                            break block0;
                        }
                        IntegralDomain opd = (IntegralDomain)op0;
                        long newLowValue = opd.getLowValue();
                        long newHighValue = opd.getHighValue();
                        long newZeroBitMask = opd.getZeroBitMask();
                        long newOnesBitMask = opd.getOnesBitMask();
                        if (newLowValue >= 0L) {
                            newZeroBitMask = op0.getValueType() == 1 ? (newZeroBitMask |= 0xFFFFFFFFFFFFFF80L) : (op0.getValueType() == 2 ? (newZeroBitMask |= 0xFFFFFFFFFFFF8000L) : (op0.getValueType() == 3 ? (newZeroBitMask |= 0xFFFFFFFFFFFF0000L) : (newZeroBitMask |= Integer.MIN_VALUE)));
                        }
                        v = IntegralDomain.build(5, newLowValue, newHighValue, newZeroBitMask, newOnesBitMask, false);
                        break block0;
                    }
                    case 6: 
                    case 7: {
                        if (op0.isConstant()) {
                            double val = ((IRealDomain)op0).getLowValue();
                            v = new LongConstant((long)val);
                            break block0;
                        }
                        RealDomain opd = (RealDomain)op0;
                        long newLowValue = -9.223372036854776E18 >= opd.getLowValue() ? Long.MIN_VALUE : (long)opd.getLowValue();
                        long newHighValue = 9.223372036854776E18 <= opd.getHighValue() ? Long.MAX_VALUE : (long)opd.getHighValue();
                        v = IntegralDomain.build(5, newLowValue, newHighValue, 0L, 0L, false);
                        break block0;
                    }
                }
                v = new IntegralDomain(5);
                break;
            }
            case 6: {
                switch (op0.getValueType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (op0.isConstant()) {
                            long val = ((IIntegralDomain)op0).getLowValue();
                            v = new FloatConstant(val);
                            break block0;
                        }
                        IntegralDomain opd = (IntegralDomain)op0;
                        long newLowValue = opd.getLowValue();
                        long newHighValue = opd.getHighValue();
                        v = FloatDomain.build(0, newLowValue, newHighValue);
                        break block0;
                    }
                    case 6: {
                        v = op0;
                        break block0;
                    }
                    case 7: {
                        if (op0.isConstant()) {
                            double val = ((IRealDomain)op0).getLowValue();
                            v = new FloatConstant((float)val);
                            break block0;
                        }
                        RealDomain opd = (RealDomain)op0;
                        double newLowValue = (double)-1.4E-45f >= opd.getLowValue() ? (double)-1.4E-45f : (double)((float)opd.getLowValue());
                        double newHighValue = 3.4028234663852886E38 <= opd.getHighValue() ? 3.4028234663852886E38 : (double)((float)opd.getHighValue());
                        v = FloatDomain.build(0, (float)newLowValue, (float)newHighValue);
                        break block0;
                    }
                }
                v = FloatDomain.getDefault();
                break;
            }
            case 7: {
                switch (op0.getValueType()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (op0.isConstant()) {
                            long val = ((IIntegralDomain)op0).getLowValue();
                            v = new DoubleConstant(val);
                            break block0;
                        }
                        IntegralDomain opd = (IntegralDomain)op0;
                        long newLowValue = opd.getLowValue();
                        long newHighValue = opd.getHighValue();
                        v = DoubleDomain.build(0, newLowValue, newHighValue);
                        break block0;
                    }
                    case 6: {
                        if (op0.isConstant()) {
                            double val = ((FloatConstant)op0).getLowValue();
                            v = new DoubleConstant(val);
                            break block0;
                        }
                        RealDomain opd = (RealDomain)op0;
                        double newLowValue = opd.getLowValue();
                        double newHighValue = opd.getHighValue();
                        v = DoubleDomain.build(0, newLowValue, newHighValue);
                        break block0;
                    }
                    case 7: {
                        v = op0;
                        break block0;
                    }
                }
                v = DoubleDomain.getDefault();
                break;
            }
            case 8: {
                v = BooleanDomain.get();
                break;
            }
            case 9: {
                if (op0 instanceof ObjectConstant) {
                    v = new ObjectConstant(((ObjectConstant)op0).getValue());
                    AstObject ao = this.getAstObject();
                    if (ao == null || !(ao instanceof AstExpression)) break;
                    AstExpression ae = (AstExpression)ao;
                    ((ObjectConstant)v).setFrontEndTypeReference(ae.getRuntimeType());
                    break;
                }
                if (op0 instanceof ObjectDomain) {
                    v = ObjectDomain.build(((ObjectDomain)op0).getMask(), this.getTypeReference());
                    break;
                }
                v = ObjectDomain.getDefault(this.getTypeReference());
                break;
            }
            case 10: {
                if (op0 instanceof ObjectDomain) {
                    ObjectDomain op0d = (ObjectDomain)op0;
                    v = ObjectDomain.build(op0d.getMask(), this.getTypeReference(), op0d.arrayLengthDomain() == null ? IntegralDomain.forArray() : op0d.arrayLengthDomain());
                    break;
                }
                v = ObjectDomain.getDefault(this.getTypeReference());
                break;
            }
            default: {
                v = BadDomain.instance();
            }
        }
        this.setResultValue(v);
    }

    void constrain(IValueDomain value, ConstraintCollection coll) {
        if (!this.goodResult()) {
            return;
        }
        IVal op0 = this.operand(0);
        if (op0 instanceof IVar) {
            IValueDomain op0v = this.operandValue(0);
            if (op0v instanceof IIntegralDomain) {
                if (value instanceof IIntegralDomain) {
                    IValueDomain id = op0v.meet(value);
                    ExprTuple.constrainOperand((IVar)op0, id, coll);
                } else if (value instanceof IRealDomain) {
                    double newLowValue = ((IRealDomain)value).getLowValue();
                    double newHighValue = ((IRealDomain)value).getHighValue();
                    IIntegralDomain valueI = IntegralDomain.build(op0v.getValueType(), (long)newLowValue, (long)newHighValue, 0L, 0L, false);
                    IIntegralDomain id = IntegralDomain.intersect(valueI, (IIntegralDomain)op0v);
                    ExprTuple.constrainOperand((IVar)op0, id, coll);
                }
            } else if (op0v instanceof IRealDomain) {
                if (value instanceof IRealDomain) {
                    IValueDomain id = op0v.meet(value);
                    ExprTuple.constrainOperand((IVar)op0, id, coll);
                } else if (value instanceof IIntegralDomain) {
                    long newLowValue;
                    IRealDomain valueR;
                    long val;
                    if (((IRealDomain)op0v).getValueType() == 6) {
                        if (value.isConstant()) {
                            val = ((IIntegralDomain)value).getLowValue();
                            valueR = new FloatConstant(val);
                        } else {
                            newLowValue = ((IIntegralDomain)value).getLowValue();
                            long newHighValue = ((IIntegralDomain)value).getHighValue();
                            valueR = FloatDomain.build(0, newLowValue, newHighValue);
                        }
                    } else if (value.isConstant()) {
                        val = ((IIntegralDomain)value).getLowValue();
                        valueR = new DoubleConstant(val);
                    } else {
                        newLowValue = ((IIntegralDomain)value).getLowValue();
                        long newHighValue = ((IIntegralDomain)value).getHighValue();
                        valueR = DoubleDomain.build(0, newLowValue, newHighValue);
                    }
                    IValueDomain id = valueR.meet(op0v);
                    ExprTuple.constrainOperand((IVar)op0, id, coll);
                }
            }
        }
    }

    public int getCode() {
        return 28;
    }

    public CastTuple(IVal operandVal, int backEndTypeValue, ITuple prevTuple, AstExpression associatedObject) {
        super(backEndTypeValue, prevTuple, associatedObject);
        this.setupOperand(operandVal);
    }

    public CastTuple(IVal operandVal, ITuple prevTuple, AstExpression associatedObject) {
        super(prevTuple, associatedObject);
        this.setupOperand(operandVal);
    }
}

