/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.dataflow.IKnownMethod;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.Method;
import com.togethersoft.sca.internal.dataflow.Project;
import com.togethersoft.sca.internal.dataflow.flowgraph.BasicBlock;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import com.togethersoft.sca.internal.dataflow.flowgraph.ControlFlowGraph;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.VarArgsTuple;
import com.togethersoft.sca.internal.dataflow.known.KnownMethod;
import com.togethersoft.sca.internal.dataflow.values.ValueDomain;

public class CallTuple
extends VarArgsTuple {
    private boolean checkedForInfo = false;
    private KnownMethod info = null;

    public String mnemo() {
        return "CALL";
    }

    public void propagateValues() {
        IValueDomain res = null;
        if (this.haveInfo()) {
            res = this.info.propagateValues(this);
        } else {
            Method[] cm = this.getCalledMethods();
            if (cm != null && cm.length > 0 && cm[0] != null) {
                res = cm[0].getResultDomain();
                int i = 1;
                while (i < cm.length) {
                    if (cm[i] == null) {
                        res = null;
                        break;
                    }
                    res = res.join(cm[i].getResultDomain());
                    ++i;
                }
            }
        }
        if (res == null) {
            res = ValueDomain.getDefault(this.backEndType(), this.getTypeReference());
        }
        if (this.operands() != null) {
            int i = this.operands().length;
            while (--i >= 0) {
                this.updateOperandValue(i);
            }
            if (this.operand(0) != null) {
                this.updateOperandValue(0);
            }
        }
        if (this.voidValues()) {
            return;
        }
        ((BasicBlock)this.basicBlock()).updateValuesForCall();
        this.setResultValue(res);
    }

    void constrain(IValueDomain value, ConstraintCollection coll) {
        if (!this.goodResult()) {
            return;
        }
        if (this.haveInfo()) {
            this.info.constrain(this, value, coll);
        }
    }

    public int getCode() {
        return 27;
    }

    public CallTuple(int arity, ITuple prevTuple, AstExpression associatedObject) {
        super(arity, prevTuple, associatedObject);
    }

    private boolean haveInfo() {
        if (!this.checkedForInfo) {
            Method m;
            AstDeclaration d = this.getCalledDeclaration();
            if (d == null) {
                return false;
            }
            Project prj = ((ControlFlowGraph)this.basicBlock.getCFG()).getProject();
            if (d instanceof AstMethod) {
                m = prj.getFor((AstMethod)d);
            } else if (d instanceof AstInitializer) {
                m = prj.getFor((AstInitializer)d);
            } else {
                System.err.println("********* unknown Ast with method definition" + d.getObjectKind());
                return false;
            }
            if (m == null) {
                return false;
            }
            this.info = m.extraInfo;
            this.checkedForInfo = true;
        }
        return this.info != null;
    }

    public IKnownMethod getKnownMethod() {
        this.haveInfo();
        return this.info;
    }
}

