/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IBooleanConstant;
import com.togethersoft.sca.dataflow.values.IBooleanDomain;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;
import com.togethersoft.sca.internal.dataflow.values.IntegralDomain;

public class BitXorTuple
extends ExprTuple {
    public String mnemo() {
        return "BXOR";
    }

    public void propagateValues() {
        IValueDomain op0 = this.updateOperandValue(0);
        IValueDomain op1 = this.updateOperandValue(1);
        if (this.voidValues()) {
            return;
        }
        IValueDomain res = this.operand(0) instanceof IVar && this.operand(1) instanceof IVar && (this.hasSymbolicValue(this.operand(0), 1) || this.hasSymbolicValue(this.operand(1), 0)) ? IntegralDomain.build(op0.getValueType(), 0L, 0L, 0L, 0L, false) : (op0 instanceof IIntegralDomain && op1 instanceof IIntegralDomain ? ((IIntegralDomain)op0).doBXOR((IIntegralDomain)op1) : (op0 instanceof IBooleanDomain && op1 instanceof IBooleanDomain ? ((IBooleanDomain)op0).doBXOR((IBooleanDomain)op1) : op0));
        this.setResultValue(res);
    }

    void constrain(IValueDomain value, ConstraintCollection coll) {
        if (!this.goodResult()) {
            return;
        }
        IVal op0 = this.operand(0);
        IValueDomain op0v = this.operandValue(0);
        IVal op1 = this.operand(1);
        IValueDomain op1v = this.operandValue(1);
        if (op0 instanceof IVar) {
            BitXorTuple.constrain(value, (IVar)op0, op0v, op1v, coll);
        }
        if (op1 instanceof IVar) {
            BitXorTuple.constrain(value, (IVar)op1, op1v, op0v, coll);
        }
    }

    private static void constrain(IValueDomain value, IVar op0, IValueDomain op0v, IValueDomain op1v, ConstraintCollection coll) {
        if (op0v == null || op1v == null || value == null) {
            return;
        }
        switch (op0.getValueType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                IIntegralDomain resd = (IIntegralDomain)value;
                IIntegralDomain op0d = (IIntegralDomain)op0v;
                IIntegralDomain op1d = (IIntegralDomain)op1v;
                if (op1d.getLowValue() != op1d.getHighValue() || resd.getLowValue() != resd.getHighValue()) break;
                long dv = op1d.getLowValue() ^ resd.getLowValue();
                IIntegralDomain d = IntegralDomain.build(op0.getValueType(), dv, dv, dv ^ 0xFFFFFFFFFFFFFFFFL, dv, false);
                ExprTuple.constrainOperand(op0, IntegralDomain.intersect(d, op0d), coll);
                break;
            }
            case 8: {
                if (!value.isConstant()) break;
                boolean rv = ((IBooleanConstant)value).getValue();
                if (!op1v.isConstant()) break;
                boolean d = rv ^ ((IBooleanConstant)op1v).getValue();
                ExprTuple.constrainOperand(op0, BooleanConstant.make(d), coll);
                break;
            }
        }
    }

    public int getCode() {
        return 14;
    }

    public BitXorTuple(IVal leftOperand, IVal rightOperand, ITuple prevTuple, AstExpression associatedObject) {
        super(prevTuple, associatedObject);
        this.setupOperands(leftOperand, rightOperand);
    }
}

