/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.dataflow.flowgraph.IBasicBlock;
import com.togethersoft.sca.dataflow.flowgraph.ITempVariable;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintTable;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;
import com.togethersoft.sca.internal.dataflow.values.BooleanConstant;

public class AssumeTuple
extends Tuple {
    public AssumeTuple(IVal operandVal, ITuple prevTuple, AstObject associatedObject) {
        super(prevTuple, associatedObject);
        this.setupOperand(operandVal);
    }

    public int getCode() {
        return 60;
    }

    public ITuple[] targets() {
        return null;
    }

    public ITuple target(int targetNumber) {
        return null;
    }

    public IVar result() {
        return null;
    }

    public IValueDomain resultValue() {
        return null;
    }

    public boolean isTarget() {
        return false;
    }

    public boolean transfersControl() {
        return true;
    }

    public String mnemo() {
        return "ASSUME";
    }

    public void propagateValues() {
        this.updateOperandValue(0);
    }

    public void computeConstraints(ConstraintTable table) {
        ITuple nextTuple = this.getNext();
        if (nextTuple == null) {
            return;
        }
        IBasicBlock yesBranch = this.getNext().basicBlock();
        IVal op = this.operand(0);
        if (op.getValueKind() == 1) {
            IVar v = (IVar)op;
            int opKind = v.getVariableKind();
            if (opKind == 1) {
                ExprTuple t = (ExprTuple)((ITempVariable)v).sourceTuple();
                ConstraintCollection coll = new ConstraintCollection();
                t.constrain(BooleanConstant.forTrue(), coll);
                table.include(yesBranch, coll);
            } else if (opKind == 2 || opKind == 3) {
                int varIdx = ((Var)v).getVarIndex();
                table.include(yesBranch, varIdx, BooleanConstant.forTrue());
            }
        }
    }
}

