/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph.tuples;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IVal;
import com.togethersoft.sca.dataflow.flowgraph.IVar;
import com.togethersoft.sca.dataflow.values.IIntegralDomain;
import com.togethersoft.sca.dataflow.values.IObjectDomain;
import com.togethersoft.sca.dataflow.values.IRealDomain;
import com.togethersoft.sca.dataflow.values.IValueDomain;
import com.togethersoft.sca.internal.dataflow.flowgraph.ConstraintCollection;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;

public class AssignmentTuple
extends ExprTuple {
    public static final int POST_INC = 1;
    public static final int POST_DEC = 2;
    public static final int ASSIGN_TO_ZERO = 4;
    private int flags;

    public String mnemo() {
        return "ASG";
    }

    public void propagateValues() {
        IValueDomain op0 = this.updateOperandValue(0);
        if (this.voidValues()) {
            return;
        }
        IValueDomain res = op0;
        this.flags &= 0xFFFFFFFB;
        IValueDomain resVal = this.getResultValue();
        if (resVal instanceof IObjectDomain && ((IObjectDomain)resVal).isNull()) {
            this.flags |= 4;
        }
        this.setResultValue(res);
    }

    void constrain(IValueDomain valueArg, ConstraintCollection coll) {
        if (!this.goodResult()) {
            return;
        }
        IVal op0 = this.operand(0);
        IValueDomain value = valueArg;
        if (op0 instanceof Var) {
            Var v = (Var)op0;
            int varKind = v.getVariableKind();
            if (varKind == 2 || varKind == 3) {
                if (this.flags == 1) {
                    if (value instanceof IIntegralDomain) {
                        value = ((IIntegralDomain)value).doINC();
                    } else if (value instanceof IRealDomain) {
                        value = ((IRealDomain)value).doINC();
                    }
                } else if (this.flags == 2) {
                    if (value instanceof IIntegralDomain) {
                        value = ((IIntegralDomain)value).doDEC();
                    } else if (value instanceof IRealDomain) {
                        value = ((IRealDomain)value).doDEC();
                    }
                }
            }
            ExprTuple.constrainOperand(v, value, coll);
        }
    }

    public AssignmentTuple(IVar leftOperand, IVal rightOperand, ITuple prevTuple, AstExpression associatedObject) {
        super(31, prevTuple, associatedObject);
        this.setupOperand(rightOperand);
        this.setResultVar(leftOperand);
        this.flags = 0;
    }

    public int getCode() {
        return 31;
    }

    public AssignmentTuple(IVal operandVal, ITuple prevTuple, AstExpression associatedObject) {
        super(prevTuple, associatedObject);
        this.setupOperand(operandVal);
        this.flags = 0;
    }

    public AssignmentTuple(IVal operandVal, int specialFlags, ITuple prevTuple, AstExpression associatedObject) {
        super(prevTuple, associatedObject);
        this.setupOperand(operandVal);
        this.flags = specialFlags;
    }

    public int getFlags() {
        return this.flags;
    }
}

