/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.dataflow.flowgraph.ITempVariable;
import com.togethersoft.sca.dataflow.flowgraph.ITuple;
import com.togethersoft.sca.dataflow.flowgraph.IUserVariable;
import com.togethersoft.sca.dataflow.flowgraph.IValueTable;
import com.togethersoft.sca.internal.dataflow.Field;
import com.togethersoft.sca.internal.dataflow.flowgraph.MemberVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.ParameterVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.TempVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.UserVariable;
import com.togethersoft.sca.internal.dataflow.flowgraph.Var;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;
import java.io.PrintStream;

public class ValueTable
implements IValueTable {
    private UserVariable thisVar;
    private UserVariable superVar;
    private UserVariable resultVar;
    private static int numberOfExternalVars;
    private static final UserVariable externalByteVariable;
    private static final UserVariable externalCharVariable;
    private static final UserVariable externalShortVariable;
    private static final UserVariable externalIntVariable;
    private static final UserVariable externalLongVariable;
    private static final UserVariable externalFloatVariable;
    private static final UserVariable externalDoubleVariable;
    private static final UserVariable externalBooleanVariable;
    private static final UserVariable externalObjectVariable;
    private static final UserVariable externalVoidVariable;
    private static final UserVariable externalBadVariable;
    private int numberOfVars;
    private int numberOfSpecial;
    private Var[] vars;

    public ValueTable(AstMethod method) {
        int modifiers = method.getModifiers();
        this.vars = new Var[this.numberOfVars + 15];
        this.addVariable(externalByteVariable);
        this.addVariable(externalCharVariable);
        this.addVariable(externalShortVariable);
        this.addVariable(externalIntVariable);
        this.addVariable(externalLongVariable);
        this.addVariable(externalFloatVariable);
        this.addVariable(externalDoubleVariable);
        this.addVariable(externalBooleanVariable);
        this.addVariable(externalObjectVariable);
        this.addVariable(externalVoidVariable);
        this.addVariable(externalBadVariable);
        if ((modifiers & 8) == 0) {
            this.thisVar = new UserVariable(9, "this", 4, method.getDeclaringType(), this.numberOfVars);
            this.addVariable(this.thisVar);
            this.superVar = new UserVariable(9, "super", 5, method.getDeclaringType().getSuperClass(), this.numberOfVars);
            this.addVariable(this.superVar);
        } else {
            this.thisVar = null;
            this.superVar = null;
        }
        this.numberOfSpecial = this.numberOfVars - 1;
        AstTypeReference resultType = method.getReturnType();
        if (resultType.getKind() != 1) {
            this.resultVar = new UserVariable(ValueTable.translateType(resultType), "$result", 2, null, this.numberOfVars);
            this.addVariable(this.resultVar);
        } else {
            this.resultVar = null;
        }
        AstVariable[] parms = method.getParameters();
        int i = 0;
        while (i < parms.length) {
            ParameterVariable v = new ParameterVariable(ValueTable.translateType(parms[i].getType()), parms[i].getElementName(), parms[i], this.numberOfVars, i);
            this.addVariable(v);
            ++i;
        }
    }

    public UserVariable pseudo(AstTypeReference typeRef) {
        if (typeRef == null) {
            return externalObjectVariable;
        }
        if (typeRef.numDimensions() != 0) {
            return externalObjectVariable;
        }
        int astType = typeRef.getKind();
        switch (astType) {
            case 2: {
                return externalByteVariable;
            }
            case 3: {
                return externalShortVariable;
            }
            case 4: {
                return externalCharVariable;
            }
            case 5: {
                return externalIntVariable;
            }
            case 6: {
                return externalLongVariable;
            }
            case 7: {
                return externalFloatVariable;
            }
            case 8: {
                return externalDoubleVariable;
            }
            case 9: {
                return externalBooleanVariable;
            }
            case 1: {
                return externalVoidVariable;
            }
            case 0: {
                return externalBadVariable;
            }
        }
        return externalObjectVariable;
    }

    public static int translateType(AstTypeReference typeRef) {
        if (typeRef == null) {
            return 0;
        }
        if (typeRef.numDimensions() != 0) {
            return 10;
        }
        int astType = typeRef.getKind();
        switch (astType) {
            case 1: {
                return 11;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 8;
            }
            case 10: 
            case 11: 
            case 12: {
                return 9;
            }
        }
        return 0;
    }

    public ITuple[] getNullSuspicious() {
        int nBads = 0;
        int i = this.numberOfSpecial;
        while (i < this.numberOfVars) {
            Var v = this.vars[i];
            if (v instanceof UserVariable) {
                UserVariable uv = (UserVariable)v;
                if (uv.accessTuple != null && uv.compareTuple != null) {
                    ++nBads;
                }
            }
            ++i;
        }
        ITuple[] res = new ITuple[nBads * 2];
        int idx = 0;
        int i2 = this.numberOfSpecial;
        while (i2 < this.numberOfVars) {
            Var v = this.vars[i2];
            if (v instanceof UserVariable) {
                UserVariable uv = (UserVariable)v;
                if (uv.accessTuple != null && uv.compareTuple != null) {
                    res[idx] = uv.accessTuple;
                    res[++idx] = uv.compareTuple;
                    ++idx;
                }
            }
            ++i2;
        }
        return res;
    }

    public IUserVariable findUserVariable(Object key) {
        int i = this.numberOfSpecial;
        while (i < this.numberOfVars) {
            UserVariable uv;
            Var v = this.vars[i];
            if (v instanceof UserVariable && (uv = (UserVariable)v).getKey() == key) {
                return uv;
            }
            ++i;
        }
        return null;
    }

    public IUserVariable addUserVariable(AstVariable var, int varKind) {
        UserVariable v = new UserVariable(ValueTable.translateType(var.getType()), var.getElementName(), varKind, var, this.numberOfVars);
        this.addVariable(v);
        return v;
    }

    public IUserVariable addMemberVariable(AstVariable var, Field fld) {
        MemberVariable v = new MemberVariable(fld, ValueTable.translateType(var.getType()), var.getElementName(), (Object)var, this.numberOfVars);
        this.addVariable(v);
        return v;
    }

    public ITempVariable addTempVariable(int type, ITuple source) {
        TempVariable v = new TempVariable(type, (Tuple)source, this.numberOfVars);
        this.addVariable(v);
        return v;
    }

    public Var[] getVariables() {
        if (this.vars.length != this.numberOfVars) {
            Var[] arr = new Var[this.numberOfVars];
            System.arraycopy(this.vars, 0, arr, 0, this.numberOfVars);
            this.vars = arr;
        }
        return this.vars;
    }

    public Var getVar(int i) {
        return this.vars[i];
    }

    public void print(PrintStream out) {
        out.println("Dump of variables table");
        int i = 0;
        while (i < this.numberOfVars) {
            Var v = this.vars[i];
            out.println(" . " + v.getName() + " [idx = " + v.getVarIndex() + "]");
            ++i;
        }
    }

    public final int numberOfSpecialVars() {
        return this.numberOfSpecial;
    }

    public final UserVariable getThisVar() {
        return this.thisVar;
    }

    public final UserVariable getSuperVar() {
        return this.superVar;
    }

    public final UserVariable getResultVar() {
        return this.resultVar;
    }

    public final int getNumberOfVars() {
        return this.numberOfVars;
    }

    private final void addVariable(Var v) {
        if (this.numberOfVars == this.vars.length) {
            Var[] newVars = new Var[this.vars.length + 10];
            System.arraycopy(this.vars, 0, newVars, 0, this.vars.length);
            this.vars = newVars;
        }
        this.vars[this.numberOfVars++] = v;
    }

    static {
        externalByteVariable = new UserVariable(1, "EXTERNAL", 6, null, numberOfExternalVars++);
        externalCharVariable = new UserVariable(3, "EXTERNAL", 6, null, numberOfExternalVars++);
        externalShortVariable = new UserVariable(2, "EXTERNAL", 6, null, numberOfExternalVars++);
        externalIntVariable = new UserVariable(4, "EXTERNAL", 6, null, numberOfExternalVars++);
        externalLongVariable = new UserVariable(5, "EXTERNAL", 6, null, numberOfExternalVars++);
        externalFloatVariable = new UserVariable(6, "EXTERNAL", 6, null, numberOfExternalVars++);
        externalDoubleVariable = new UserVariable(7, "EXTERNAL", 6, null, numberOfExternalVars++);
        externalBooleanVariable = new UserVariable(8, "EXTERNAL", 6, null, numberOfExternalVars++);
        externalObjectVariable = new UserVariable(9, "EXTERNAL", 6, null, numberOfExternalVars++);
        externalVoidVariable = new UserVariable(11, "EXTERNAL", 6, null, numberOfExternalVars++);
        externalBadVariable = new UserVariable(0, "EXTERNAL", 6, null, numberOfExternalVars++);
    }
}

