/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.dataflow.flowgraph;

import com.togethersoft.sca.internal.dataflow.flowgraph.TupleSet;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.ExprTuple;
import com.togethersoft.sca.internal.dataflow.flowgraph.tuples.Tuple;

public class TupleWebs {
    private int[] links;
    private ExprTuple[] tuples;

    TupleWebs(ExprTuple[] tuplesArray) {
        this.tuples = tuplesArray;
        this.links = new int[tuplesArray.length];
        int i = 0;
        while (i < this.links.length) {
            this.links[i] = i;
            ++i;
        }
    }

    TupleSet[] extract() {
        int[] counts = new int[this.links.length];
        int[] indices = new int[this.links.length];
        int i = 0;
        while (i < this.links.length) {
            int n = this.top(i);
            counts[n] = counts[n] + 1;
            ++i;
        }
        int numWebs = 0;
        int i2 = 0;
        while (i2 < counts.length) {
            if (counts[i2] != 0) {
                indices[i2] = numWebs++;
            }
            ++i2;
        }
        TupleSet[] webs = new TupleSet[numWebs];
        int i3 = 0;
        while (i3 < counts.length) {
            if (counts[i3] != 0) {
                webs[indices[i3]] = new TupleSet();
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.links.length) {
            webs[indices[this.links[i4]]].insert(this.tuples[i4]);
            ++i4;
        }
        return webs;
    }

    void merge(TupleSet ts) {
        Tuple[] ta = ts.getStorage();
        int count = ts.getUsedCount();
        if (ta.length > 1) {
            ExprTuple leader = (ExprTuple)ta[0];
            int i = 1;
            while (i < count) {
                this.merge(leader, (ExprTuple)ta[i]);
                ++i;
            }
        }
    }

    void merge(TupleSet ts, ExprTuple t) {
        Tuple[] ta = ts.getStorage();
        int count = ts.getUsedCount();
        if (count != 0) {
            this.merge((ExprTuple)ta[0], t);
        }
    }

    void merge(ExprTuple t1, ExprTuple t2) {
        int itemIdx;
        int setIdx = this.top(this.find(t1));
        if (setIdx != (itemIdx = this.top(this.find(t2)))) {
            this.links[itemIdx] = setIdx;
        }
    }

    private int top(int idx) {
        int idx0 = idx;
        int i = idx;
        while (this.links[i] != i) {
            i = this.links[i];
        }
        this.links[idx0] = i;
        return i;
    }

    private int find(ExprTuple t) {
        int i = 0;
        while (i < this.tuples.length) {
            if (this.tuples[i] == t) {
                return i;
            }
            ++i;
        }
        t.print(System.err);
        throw new Error("Webs construction consistency check");
    }
}

